#!/usr/bin/perl

print "Number of input units: ";
$inputUnits = <STDIN>;
print "Number of output categories: ";
$outputUnits = <STDIN>;
print "Width of each input pattern: ";
$width = <STDIN>;
print "Step down by 1/^2? [y/n] :";
$exponents = <STDIN>;


$numDistinctPatterns = 1 + $inputUnits - $width;
print "There will be $numDistinctPatterns distinct patterns.\n";
$numPatternsPerCategory = $numDistinctPatterns / $outputUnits;

$unique = 0;

for ($cat = 0; $cat < $outputUnits; $cat++)
{
	$category = "";
	for ($i = 0; $i < $outputUnits; $i++)
	{
		if ($i == $cat)
		{
			$category .= "1 ";
		}
		else
		{
			$category .= "0 ";
		}
	}
	chop $category;

	$offset = int($cat * $numPatternsPerCategory);
	for ($i = 0; $i < $numPatternsPerCategory; $i++)
	{
		$start = $offset + $i;
		$cease = $start + $width;
		$stimulus = "";
		$center = int($start + ($width / 2));
		print "center = $center\n";
		print "category $cat --> ";
		$value = 0;
		for ($n = 0; $n < $inputUnits; $n++)
		{
			if (($n >= $start) && ($n < $cease))
			{
				if ($exponents eq "y")
				{
				 $value = (1/(2**abs($n-$center)));
				 $stimulus .= $value." ";
				}
				else
				{
				 $stimulus .= "1 ";
				}
			}
			else
			{
				$stimulus .= "0 ";
			}
		}	
		chop $stimulus;
		print "$category -->  $stimulus\n";
		# --------------------------------------------
		# Store this stimulus and output code into
		# a file.
		# --------------------------------------------
		$unique++;
		$label = $unique;
		if ($label < 10) { $label = "0".$label; }	
		if ($label < 100) { $label = "0".$label; }	
		open (O, ">input".$label);
		print O $stimulus."\n";
		close(O);
		open (O, ">output".$label);
		print O $category."\n";
		close (O);
	}
}
