#!/usr/bin/perl

# -------------------------------------------------------------
# Converts a bunch of input and output stimuli into stimuli
# that are appropriate for a Simple Recurrent Network training
# over time, possibly settling over time to the central tendency
# of the stimulus given the context input which preceeds.
# -------------------------------------------------------------


use strict;

print "Num stimuli (i/o pairs)? ";
my $numStimuli = <STDIN>;
print "How many timesteps for context pattern? (5) ";
my $contextPatternDuration = <STDIN>;
print "How many timesteps for actual stimulus? (5) ";
my $stimulusPatternDuration = <STDIN>;
print "Context input pattern? (1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) ";
my $contextPattern = <STDIN>;
print "Context destination directory? (context2/) ";
my $destinationDir = <STDIN>;
chop $destinationDir;

system "mkdir $destinationDir";
my $i = 0;
for ($i = 1; $i <= $numStimuli; $i++)
{
	my $j = $i;
	if ($j < 10) { $j = "0". $j; }
	if ($j < 100) { $j = "0". $j; }
	my $stimulusFile = "input".$j;
	my $teachingFile = "output".$j;
	print "Writing $destinationDir/$stimulusFile \n";
	open (STIMSRC, "$stimulusFile");
	open (TCHRSRC, "$teachingFile");
	open (STIM, ">"."$destinationDir/$stimulusFile");
	open (TCHR, ">"."$destinationDir/$teachingFile");
	
	my $stimLine = <STIMSRC>;
	my $tchrLine = <TCHRSRC>;
	my $k = 0;
	for ($k = 0; $k < $contextPatternDuration; $k++)
	{
		print STIM $contextPattern;
		print TCRH $tchrLine;
	}
	for ($k = 0; $k < $stimulusPatternDuration; $k++)
	{
		print STIM $stimLine;
		print TCHR $tchrLine;
	}
	close (STIM);
	close (TCHR);
	close (STIMSRC);
	close (TCHRSRC);
}


