#!/usr/bin/perl

# STATEREL: [attDst=0,attTIM=30,sacPrg=true,sacPrgTIM=5,sacDst=1,ID'd?=true,pred=0.1,attlen=1,prevlen=0,nextlen=3,fixWid=0,attWid=0] (eyepos=0) = -8.0
# STATEREL: [attDst=-5,attTIM=45,sacPrg=true,sacPrgTIM=0,sacDst=-5,ID'd?=true,pred=0.1,attlen=1,prevlen=0,nextlen=3,fixWid=1,attWid=0] (eyepos=5) = -8.0

while ($line = <STDIN>)
{
	# --------------------------------------------------------------------
	# Extract value of the state
	# --------------------------------------------------------------------
	$original = $line;
	@pieces = split(" ", $original);	
	$value = $pieces[4];

	# --------------------------------------------------------------------
	# Prepare state row for extracting dimension values
	# --------------------------------------------------------------------
	$line =~ s/\[/,/g;
	$line =~ s/\]/,/g;
	@pieces = split(",", $line);


	# --------------------------------------------------------------------
	# Extract desired dimensions of this state
	# --------------------------------------------------------------------
	$attTIM = getValueOf("attTIM", @pieces);
	$sacDst = getValueOf("sacDst", @pieces);
	
	$key = $attTIM . "/" . $sacDst;
	$values{$key} = $value;
}	
# --------------------------------------------------------------------
# Display the desired values
# --------------------------------------------------------------------

if ($showHeader)
{
	print "\t";
	for ($d = 0; $d < 9; $d++)
	{
		print "sac=$d\t";
	}
	print "\n";
}
for ($t = 0; $t < 50; $t += 5)
{
	if ($showHeader) { print "t=".$t."\t"; }
	for ($d = 0; $d < 9; $d++)
	{
		$key = $t."/".$d;
		print $values{$key}."\t";
	}
	print "\n";
}


sub getValueOf
{
	my $target = $_[0];
	for (my $i = 1; $i <= $#_; $i++)
	{
		my @temp = split("=", $_[$i]);
		if ($target eq $temp[0]) { return $temp[1]; }
	}
	return "?";
}

