/*
 * Word.java
 *
 * Created on February 13, 2004, 4:13 PM
 */


package org.eyelanguage.rl.reading;

import java.io.Serializable;

/**
 *
 * @author  patryk
 */
public class Word implements Serializable
{
    private String text;
    private double frequency;
    private Word preceedingWord;
    private double predictabilityFromPreceedingWord;
    private int id;
    private int identificationTime = 15; // a default
    
    private int manuallySetLength = 0;
    private boolean stringLengthOverridden = false;
    
    public Word(String wordText)
    {
        this.text = wordText;
    }
    public Word(String wordText, double frequency)
    {
        this.text = wordText;
        this.frequency = frequency;
    }
    public Word(String wordText, double frequency, Word preceedingWord, double predictability)
    {
        this.text = wordText;
        this.frequency = frequency;
        this.preceedingWord = preceedingWord;
        this.predictabilityFromPreceedingWord = predictability; 
    }
    
    public boolean equals(Object o)
    {
        if (o instanceof Word)
        {
            Word other = (Word) o; 
            if (this.getID() != other.getID()) { return false; }
            if (!this.getText().equals(other.getText())) { return false; }
            return true;
        }
        return false;
    }
    
    public Word()
    {
    }
    
    public String toString()
    {
        return "["+text+",aid="+this.getIdentificationTime()+"ms]";
    }
    
    public int getID()
    {
        return id;
    }
    
    public Word setID(int id)
    {
        this.id = id;
        return this;
    }
    
    public void setLengthOverride(int newLength)
    {
        this.manuallySetLength = newLength;
        stringLengthOverridden = true;
    }
    
    public void unsetLengthOverride()
    {
        stringLengthOverridden = false;
    }
    
    public int getLength()
    {
        return text.length();
    }

    public int getPsychologicalLength()
    {
        if (stringLengthOverridden) 
        {
            return manuallySetLength;
        }
        return text.length();
    }
    
    public boolean hasPreceedingWord()
    {
        if (preceedingWord == null) return false;
        return true;
    }

    public java.lang.String getText()
    {
        return text;
    }    
    
    public void setText(java.lang.String text)
    {
        this.text = text;
    }    

    public double getFrequency()
    {
        return frequency;
    }
    
    public void setFrequency(double frequency)
    {
        this.frequency = frequency;
    }
    public void setFrequency(Double frequencyObject)
    {
        this.frequency = frequencyObject.doubleValue();
    }
    
    public Word getPreceedingWord()
    {
        return preceedingWord;
    }
    
    public void setPreceedingWord(Word preceedingWord)
    {
        this.preceedingWord = preceedingWord;
    }

    public double getPredictabilityFromPreceedingWord()
    {
        return predictabilityFromPreceedingWord;
    }
    
    public void setPredictabilityFromPreceedingWord(double predictabilityFromPreceedingWord)
    {
        this.predictabilityFromPreceedingWord = predictabilityFromPreceedingWord;
    }
    public void setPredictabilityFromPreceedingWord(Double predictabilityFromPreceedingWordObject)
    {
        this.predictabilityFromPreceedingWord = predictabilityFromPreceedingWordObject.doubleValue();
    }
    

    public int getIdentificationTime()
    {
        return identificationTime;
    }
    

    public void setIdentificationTime(int identificationTime)
    {
        this.identificationTime = identificationTime;
    }
    
}
