package org.eyelanguage.rl.reading;

import java.util.*;
import java.io.*;
import net.pakl.rl.*;

//import edu.emory.mathcs.backport.java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ArrayBlockingQueue;

/**   Defines how states evolve in response to actions when a parallel reading process is underway, such as
    when various words become identified.  Word identification can proceed on words in parallel according to
    an attentional gradient, which specifies how word identification resources are applied to far away words.
    After identification of words, the AttNext {@link ReadingAction} can advance attention through multiple words if
    those words (which are to the right) are already identified due to parallel word identification.
     When we attend the next word, shift all attended times over to the left.
     If a word in the distance is identified, allow it to be identified.
     Visual acuity applies to all of the words.  So does the attentional gradient.
     Attention still shifts from left to right.
*/
public class SentenceWorldParallel extends org.eyelanguage.rl.reading.SentenceWorld
{
    
private static final String VERSION = "20060130-1029";

    static final long serialVersionUID = -7282356923040031291L;
    public static int PARALLEL_ATTENDABLE_WORDS = 4;        
    public static int CENTER_OF_ATTENTION = 1;

    
    public static int MAX_WORDS_IN_SENTENCE = 10;
    public static int TIME_GRANULARITY = 5;
    
    public static boolean UNIFORM_ATTENTION = true;
    public static boolean LINEAR_ATTENTION_GRADIENT = false;
    public static boolean DIVIDED_ATTENTION = false;

    public static boolean LEXICAL_PROCESSING_RIGHTAFTER_ATTN_SHIFT = true;
    
    public boolean PARALLEL_ATTENTION_ALWAYS_POSITIVE = false;
    
    private boolean EXHAUSTIVE_MODE = true;
    
    public SentenceWorldParallel()
    {
        super("parallel", 1);
        System.out.println("SentenceWorldParallel VERSION " + VERSION);
        setupReadingStateFactory(ReadingStateFactory.RELATIVE_PARALLEL_READING_STATES);
    }
    
    public SentenceWorldParallel(String name, long seed)
    {
        super(name, seed);
        System.out.println("SentenceWorldParallel VERSION " + VERSION);
        setupReadingStateFactory(ReadingStateFactory.RELATIVE_PARALLEL_READING_STATES);
    }

    private boolean saccadicEyeMovementJustOccured(ReadingState oldState, ReadingState newState)
    {
        return (oldState.isProgrammingSaccade() && !newState.isProgrammingSaccade());
    }
    
    /** Call the same code that is in the serial {@link SentenceWorld} newState(state, action), but also calls a new function called
     {@link #performParallelLexicalProcessing} on the state. */
    public State getNewState(State oldGenericState, Action genericAction)
    {
        throw new RuntimeException("Not yet implemented.");
    }
    

    
  
    private void addSaccadicTimePenaltyToParallelAttendance(ReadingStateParallelRelative newState)
    {
        for (int i = 0; i < PARALLEL_ATTENDABLE_WORDS; i++)
        {
           newState.setParallelTimeAttended(i, newState.getParallelTimeAttended(i)+SACCADE_TIME_PENALTY); 
        }
    }

    public void applyAcuityAdjustmentsParallel(ReadingStateParallelRelative previousState, ReadingStateParallelRelative newState)
    {
        int [] adjustments = acuityAdjustmentParallel(previousState.getEyePosition(), newState);
        for (int i = 0; i < PARALLEL_ATTENDABLE_WORDS; i++)
        {
            int newAttendedTime = newState.getParallelTimeAttended(i)+adjustments[i];
            newState.setParallelTimeAttended(i, newAttendedTime);
        }
    }
    
  public static void main(String args[])
    {
    }
  
    public int [] acuityAdjustmentParallel(int previousEyePosition, ReadingStateParallelRelative currentState)
    {
        throw new RuntimeException("Not yet implemented.");   
    }

    
    public ReadingState attendCurrentWord(ReadingState newState)
    {
        // all lexical processing is performed in performParallelLexicalProcessing
        newState.setDistanceFromAttendCenter(calculateDistFromAttendedWordCenter(newState));
        return setWordLengths(newState);
    }
    
    
    private ReadingStateParallelRelative setWordLengths(ReadingState newStateX)
    {
        throw new RuntimeException("Not yet implemented.");  
    }
    /** Core function of parallel sentence  world, allows the parallel attention slots to 
     * increment according to an {@link #attentionalGradient}. REALIZE that identification of the word 
     * (the amount of lexical processing required) is modulated by acuity constraints. */
    public void performParallelLexicalProcessing(ReadingStateParallelRelative newState)
    {
        throw new RuntimeException("Not yet implemented.");
    }
    
    

    /** The final word in the sentence, and all preceding words, must be identified. */
    public boolean isTerminalState(State state)
    {
        ReadingStateParallelRelative s = (ReadingStateParallelRelative) state;

        int finalWordID = getNumWords() - 1;
        for (int i = 0; i < PARALLEL_ATTENDABLE_WORDS; i++)
        {
            // Have we been processing the final word?
            if ((s.getBeginningOfAttWindow() + i) == finalWordID)
            {
                int finalWordSlot = i;
                if (s.attWindowIdentified[finalWordSlot])
                {
                    for (int goingBackwards = finalWordSlot; goingBackwards >= 0; goingBackwards--)
                    {
                        if (s.attWindowIdentified[goingBackwards] == false)
                        {
                            return false;
                        }
                    }
                    return true;
                }
            }
        }
        
        return false;
    }
        


    public State getStartingState()
    {
        if (setStartingState != null) 
        {
            return setStartingState; 
        }
        ReadingState startingState = readingStateFactory.createNewReadingState();
        startingState.setAttendedWordID(0);
        startingState = attendCurrentWord(startingState);
        startingState.setTimeAttending(0);

        return startingState;
    }
    

    public ReadingState checkForWordIdentification(ReadingState state)
    {
        // do nothing (but a call to checkForWordIdentificationParallel will be perfomed later).
        return state;
    }

    /** Checks whether any words which are currently receivers of attention have become identified.  If so, makes
        a note of this by setting boolean variables. */
    public ReadingState checkForWordIdentificationParallel(ReadingState state)
    {
        throw new RuntimeException("Not yet implemented.");
    }

    public int calculateDistFromAttendedWordCenter(ReadingState state)
    {
        ReadingStateParallelRelative s = (ReadingStateParallelRelative) state;
        Word centerOfAttention = getWord(s.getCenterOfAttentionID());
        List eyePositions = this.getPossibleEyePositions(centerOfAttention);
        int center = ((Integer) eyePositions.get((eyePositions.size()-1) / 2)).intValue();
        return state.getEyePosition() - center;
    }
    

    
    /** If the next word is already identified, a single attNext action keeps moving you 
     * through the identified word to the following word. */
    protected void attemptAttendNextWord(ReadingState newState)
    {
        ReadingStateParallelRelative result = (ReadingStateParallelRelative) newState;
        while (!isTerminalState(result) 
            && result.leftMostAttendedWordIsIdentified()
            && (result.getCenterOfAttentionID()+1) < getNumWords())
        {
            super.attemptAttendNextWord(result);
            advanceAttentionWindow(result);
            result.setDistanceFromAttendCenter(calculateDistFromAttendedWordCenter(result));
        }

    }

    public void advanceAttentionWindow(ReadingStateParallelRelative newState)
    {
        throw new RuntimeException("Not yet implemented.");
    }
    
    
    
    public Iterator stateIterator() 
    { 
        Iterator result = new ParallelStateIteratorIndividualist(this);
        
        return result;
    }

    class ParallelStateIteratorIndividualist extends Thread implements Iterator, Serializable
    {
        private boolean running = true;
        private ArrayBlockingQueue boundedBuffer = null;
        private boolean ceaseRunning = false;
        
        
        public synchronized void emptyBuffer()
        {
            while (boundedBuffer.size() > 0)
            {
                ReadingState rs = (ReadingState) next();
            }
        }
        volatile boolean deliveredLast = false;
        volatile Object nextToReturn = null;
        volatile Object LAST_OBJECT_MARKER = new ReadingState();
        
        public boolean hasNext()
        {
            if (deliveredLast) return false;
            if (nextToReturn == null)
            {
                try
                {
                    nextToReturn = boundedBuffer.take();
                }
                catch (InterruptedException ie)
                {
                    ie.printStackTrace();
                }
            }
            if (nextToReturn == LAST_OBJECT_MARKER)
            {
                deliveredLast = true;
                return false;
            }
            return true;
        }
        
        SentenceWorldParallel sentenceWorld = null;
        public ParallelStateIteratorIndividualist(SentenceWorldParallel parent)
        {
            sentenceWorld = parent;
            boundedBuffer = new ArrayBlockingQueue(boundedBufferSize);
            this.setDaemon(true);
            this.start();
        }
        
        public synchronized Object next()
        {
            Object returned = nextToReturn;
            nextToReturn = null;
            return returned;
        }
        
        public void run()
        {
            try
            {
                running = true;
                loadInNext();
                running = false;
                ceaseRunning = false;
            }
            catch (Exception e)
            {
                e.printStackTrace();
                System.exit(1);
            }
        }
        
        
        public void performParallelLexicalProcessingUntil(ReadingStateParallelRelative s, int focusedWord, int timeAttended)
        {
            while (s.attWindowTimes[focusedWord] < timeAttended)
            {
                performParallelLexicalProcessing(s);
            }
        }
                
        public void loadInNext()
        {
            throw new RuntimeException("Not yet implemented.");
        }

        
        public void remove()
        {
        }
    }
    
    


    public static int roundTo(int value, int roundToNearest)
    {
        return (int) roundTo((double) value, (double)roundToNearest);
    }

    public static double roundTo(double value, double roundToNearest) 
    {
        return Math.round(value * (1.0 / roundToNearest)) / (1.0 / roundToNearest);
    }    

    public void setPARALLEL_ATTENDABLE_WORDS(int newPARALLEL_ATTENDABLE_WORDS)
    {
        this.PARALLEL_ATTENDABLE_WORDS = newPARALLEL_ATTENDABLE_WORDS;
    }
    public int getPARALLEL_ATTENDABLE_WORDS()
    {
        return this.PARALLEL_ATTENDABLE_WORDS;
    }
    public void setCENTER_OF_ATTENTION(int newCENTER_OF_ATTENTION)
    {
        this.CENTER_OF_ATTENTION = newCENTER_OF_ATTENTION;
    }
    public int getCENTER_OF_ATTENTION()
    {
        return this.CENTER_OF_ATTENTION;
    }
                
    public String getSettings()
    {
        String result = super.getSettings();
        result += "\nParallel Attention Settings:";
        result += "\n----------------------------";
        result += "\nUNIFORM_ATTENTION = " + UNIFORM_ATTENTION;
        result += "\nLINEAR_ATTENTION_GRADIENT = " + LINEAR_ATTENTION_GRADIENT;
        result += "\nDIVIDED_ATTENTION = " + DIVIDED_ATTENTION;
        return result;
    }
    
}
