/*
 * ReadingTest.java
 *
 * Created on February 16, 2004, 10:55 AM
 */

package org.eyelanguage.rl.reading;
import net.pakl.rl.*;
import java.util.*;
import java.io.*;

public class ReadingTest
{
    
    /** Creates a new instance of ReadingTest aka DUMB READER */
    public ReadingTest()
    {
        //System.err.println("First test-simulating Dumb Reader...  [checking integrity]");
        //simulateDumbReader();
        //System.err.println("-----------------------------------------------------------------------------");
        //System.err.println("Now running ValueIteration Smart Reader...");
        simulateSmartReader();
    }
    
    
    public void simulateSmartReader()
    {
        SentenceWorld sWorld = new SentenceWorld("testSentence");
        sWorld.setSentence("a cat", "0.1 0.2", "15 15 15");
        sWorld.setMAX_SACCADE_PROG_TIME(5);

        sWorld.setupReadingStateFactory(ReadingStateFactory.RELATIVE_READING_STATES);
        sWorld.build();         // Create all states
        System.out.println(sWorld.getSettings());
    
        ReadingPolicy readingPolicy = Toolbox.createSimpleReadingPolicy(sWorld);

        ReadingReinforcementFunction rf = new ReadingReinforcementFunction(sWorld);
        rf.setDefaultReinforcement(-1.0);
        rf.setRewardForSuccessfulIdentification(1.0);
        rf.setReinforcementsForActionsOntoTerminalState(0.0);               // Just like in FrogWorld's Toolbox
        
        Agent reader = new Agent("reader");
        reader.setWorld(sWorld);						
        reader.setReinforcementFunction(rf);
        reader.setPolicy(readingPolicy);
        reader.setDiscountFactor(1.0);
        
        System.err.println("Setting up ValueFunction...");
        ValueFunction valueFunction = new ValueFunctionHashMap(sWorld);
        ValueFunction tempNewValueFunction = new ValueFunctionHashMap(sWorld);
        ValueFunction swap = null;

        valueFunction.setValueOfTerminalStates(0.0d);
        tempNewValueFunction.setValueOfTerminalStates(0.0d);
        System.err.println("Done with ValueFunction...");

        int total = 30;
        int numStates = sWorld.getNumberOfStates();
        for (int j = 1; j < total; j++)
        {
            File f = new File("endrun.msg");
            if (f.exists())
            {
                System.err.println("File endrun.msg exists, stopping run.");
                break;
            }

            System.out.println("Running Iteration "+j);
            
            long timerStart = System.currentTimeMillis();
            reader.performValueIteration(tempNewValueFunction, valueFunction);
            swap = tempNewValueFunction;
            tempNewValueFunction = valueFunction;
            valueFunction = swap;

            long timerCease = System.currentTimeMillis();
            System.out.println("Iteration "+j+" took "+(timerCease-timerStart)+" ms"); 
            System.err.println("Iteration "+j+" took "+(timerCease-timerStart)+" ms");
            System.out.print("Rate: "+((double)(timerCease-timerStart))/(((double)(numStates)))+" ms/state ");
            System.err.print("Rate: "+((double)(timerCease-timerStart))/(((double)(numStates)))+" ms/state ");

            double minutes = ((timerCease-timerStart) * (double) (total-j) / (double) 1000 / (double) 60); double hours = minutes / 60d;
            System.err.print("Time left: ");
            System.err.println(minutes + " minutes, which is "+hours+" hours");
            System.err.print("Time left: ");
            System.err.println(minutes + " minutes, which is "+hours+" hours");
        }
        PolicyExtractor policyExtractor = new PolicyExtractor();
        System.out.println(policyExtractor.extractOptimalPolicy(readingPolicy, valueFunction, null, sWorld, rf, reader.getDiscountFactor()));
        //System.out.println(valueFunction);
        //System.out.println(valueFunction.toText());
    }
    
    
    public void simulateDumbReader()
    {
        SentenceWorld sWorld = new SentenceWorld("testSentence");
        sWorld.setSentence("This is a test sentence", "0.5 0.5 0.5 0.2", "100 100 100 100 100");
        sWorld.build();         // Create all states
        System.out.println(sWorld.getSettings());
                
        ReadingPolicy readingPolicy = Toolbox.createSimpleReadingPolicy(sWorld);

        ReadingReinforcementFunction rf = new ReadingReinforcementFunction(sWorld);
        rf.setDefaultReinforcement(-1.0);
        rf.setRewardForSuccessfulIdentification(+1.0);
                
        // DUMB Reader:
        // Let's READ manually by saccading to AND attending each word: saccade after we have identified each word.
        ReadingState rs = new ReadingState();
        Word previousWord = null;
        ReadingState currentState = new ReadingState();
        while (!sWorld.isTerminalState(currentState))
        {
            Word currentWord = sWorld.getWord(currentState.getAttendedWordID());
            if (currentWord != previousWord)
            {
                System.out.println("ATTENDED WORD IS NOW "+currentWord);
                System.out.println("Penalty for off-center eye is "+sWorld.acuityIdentificationPenalty(currentState.getAttendedWordID(), currentState.getEyePosition()));
                previousWord = currentWord;
            }
            
            if (currentState.isIdentified())
            {
                
                ReadingAction attendNextWord = new ReadingAction();
                attendNextWord.setAttendNextWord(true);
                currentState = sWorld.getNewState(currentState, attendNextWord);
                System.out.println("  "+currentState);
                
                if (!currentState.isProgrammingSaccade())
                {
                    ReadingAction saccadeRequest = new ReadingAction();
                    saccadeRequest.setRequestingSaccade(true);
                    saccadeRequest.setSaccadeRequestDistance(currentWord.getLength() + 1);
                    currentState = sWorld.getNewState(currentState, saccadeRequest);
                    System.out.println("  "+currentState);
                    continue;
                }
            }
            currentState = sWorld.getNewState(currentState, new ReadingAction().setAttendThisWord(true));
            System.out.println("  "+currentState);
            
            ReadingAction regularAttendAction = new ReadingAction();
            regularAttendAction.setAttendThisWord(true);
            currentState = sWorld.getNewState(currentState, regularAttendAction);

            System.out.println("  "+currentState);
        }
        System.out.println("[READING DONE!]");
    }
    
    
    public static void main(String args[])
    {
        new ReadingTest();
    }

    
               
            
            
    
}
