/*
 * ReadingStateFactory.java
 *
 * Created on May 10, 2004, 10:07 AM
 */

package org.eyelanguage.rl.reading;
import java.util.*;
import java.io.Serializable;


public class ReadingStateFactory implements Serializable
{
    public static int NORMAL_READING_STATES = 1001;
    public static int RELATIVE_READING_STATES = 1002;
    public static int RELATIVE_PARALLEL_READING_STATES = 1003;
    
    public int mode = NORMAL_READING_STATES;
    public int allocationCounter = 0;
    public static int GARBAGE_COLLECT_EVERY = 10000;
    
    Object [] pool;
    boolean [] inUse;
    // String [] auth = new String[1000];
    int GROW_BY = 50;
    //public boolean POOLING = false;
    
    HashMap records = new HashMap();
    
    public void diag()
    {
        Iterator i = records.keySet().iterator();
        while (i.hasNext())
        {
            Object key = i.next();
            System.out.print(key + "=" + records.get(key)+" ");
        }
        System.out.println("");
    }
    
    public ReadingStateFactory(int kindOfStatesRequested, boolean pooling)
    {
        this(kindOfStatesRequested);
    }

    public ReadingStateFactory()
    {
    }
    
    public ReadingStateFactory(int kindOfStatesRequested)
    {
        this.mode = kindOfStatesRequested;
        if (mode == NORMAL_READING_STATES) System.out.println("ReadingStateFactory: ABSOLUTE STATES");
        if (mode == RELATIVE_READING_STATES) System.out.println("ReadingStateFactory: RELATIVE STATES");
        if (mode == RELATIVE_PARALLEL_READING_STATES) System.out.println("ReadingStateFactory: RELATIVE PARALLEL STATES");
    }
    
    
    public ReadingState createNewReadingState()
    {
        return createNewReadingStateNoPool();
    }
    

    public ReadingState createNewReadingState(ReadingState rsSource)
    {
        return createNewReadingStateNoPool(rsSource);
    }
    
    
    
    public ReadingState createNewReadingStateNoPool()
    {
        if (mode == this.NORMAL_READING_STATES)
        {
            return new ReadingState();
        }
        if (mode == this.RELATIVE_READING_STATES)
        {
            return new ReadingStateRelative();
        }
        if (mode == this.RELATIVE_PARALLEL_READING_STATES)
        {
            return new ReadingStateParallelRelative();
        }
        throw new RuntimeException("ReadingStateFactory had been initialized somehow with an unknown value, " + mode);
    }

    public ReadingState createNewReadingStateNoPool(ReadingState rs)
    {
        if (mode == this.NORMAL_READING_STATES)
        {
            return new ReadingState(rs);
        }
        if (mode == this.RELATIVE_READING_STATES)
        {
            return new ReadingStateRelative((ReadingStateRelative) rs);
        }
        if (mode == this.RELATIVE_PARALLEL_READING_STATES)
        {
            return new ReadingStateParallelRelative((ReadingStateParallelRelative) rs);
        }
        throw new RuntimeException("ReadingStateFactory had been initialized somehow with an unknown value, " + mode);
    }
    
}
