package org.eyelanguage.rl.reading;

import net.pakl.rl.*;

/**
 *
 * This class represents the State of a reading Agent -- scroll down to Field Detail to see
 * more detailed on information for each dimension of the state. Implicit means that the
 * dimensions are not used in comparing states to each other (ignored.)
 */
public class ReadingState extends net.pakl.rl.State implements java.io.Serializable, net.pakl.rl.HasVectorRepresentation
{
    /**
     * A unique word identification number of the attended word.
     * The first word in the sentence is word number 0.
     */
    protected int attendedWordID;
    
    
    /**
     * This is an integer which indicates the number of
     * characters in the word being attended.
     */
    protected int attendedWordLen;
    protected int previousWordLen;
    protected int nextWordLen;
    //protected int nextNextWordLen;
    protected double attendedWordPredictability;
    //protected double previousWordPredictability;
    //protected double nextWordPredictability;
    //protected double nextNextWordPredictability;
    
    
    /**
     * (Implicit)
     * Indicates the number of characters, including whitespace, from the
     * current eye position to the center of the word that is being attended.
     */
    protected int distanceFromAttendCenter;
    
    
    /** Position of the eye, in integers, relative the to the entire text. */
    protected int eyePosition;
    
    /**
     * (Implicit) A unique word identification number of the fixated word.
     * The first word in the sentence is word number 0.
     */
    protected int fixatedWordID;
    
    /** Whether or not the word being attended has been identified. */
    protected boolean identified;
    
    /** True or false indicating whether we are in a saccade or not (but we can only be in a
     * saccade if we performed an action to get into one so do all these need to exist?). */
    protected boolean programmingSaccade;
    
    /** Result of an action issued by the agent to specify how much of a saccade distance is requested.
     * After some amount of timeInSaccade has elapsed, the agent will find itself looking at a different
     * word.
     */
    protected int saccadeRequestDistance;
    
    /** The amount of time the agent has spent in this state attending/processing this word.  After an amount
     * of time, dictated by the {@link ActionSet}, there will be actiosn transitioning us to the next word.
     */
    protected int timeAttending;
    
    /** Indicates the amount of time spent in a saccade. */
    protected int timeInProgrammingSaccade;
    
    public ReadingState(int uniqueCode)
    {
        throw new RuntimeException("Unique codes are no longer used.");
    }
    
    /** Preserves all relevant state information in the new state returned. */
    public ReadingState(ReadingState oldReadingState)
    {
        copyFrom(oldReadingState);
    }
    
    public int [] binaryRepresentation()
    {
        throw new RuntimeException("Not implemented.");
    }
    
    public double [] doubleRepresentation()
    {
        throw new RuntimeException("Not implemented.");
    }
    
    public void clear()
    {
        this.setAttendedWordID(0);
        this.setAttendedWordLen(0);
        this.setAttendedWordPredictability(0);
        this.setDistanceFromAttendCenter(0);
        this.setEyePosition(0);
        this.setFixatedWordID(0);
        this.setIdentified(false);
        this.setProgrammingSaccade(false);
        this.setSaccadeRequestDistance(0);
        this.setTimeAttending(0);
        this.setTimeInProgrammingSaccade(0);
        
        this.setPreviousWordLen(0);
        this.setNextWordLen(0);
        this.setNextNextWordLen(0);
        this.setPreviousWordPredictability(0);
        this.setNextWordPredictability(0);
        this.setNextNextWordPredictability(0);
    }
    
    public void copyFrom(ReadingState oldReadingState)
    {
        this.setAttendedWordID(oldReadingState.getAttendedWordID());
        this.setAttendedWordLen(oldReadingState.getAttendedWordLen());
        this.setAttendedWordPredictability(oldReadingState.getAttendedWordPredictability());
        this.setDistanceFromAttendCenter(oldReadingState.getDistanceFromAttendCenter());
        this.setEyePosition(oldReadingState.getEyePosition());
        this.setFixatedWordID(oldReadingState.getFixatedWordID());
        this.setIdentified(oldReadingState.isIdentified());
        this.setProgrammingSaccade(oldReadingState.isProgrammingSaccade());
        this.setSaccadeRequestDistance(oldReadingState.getSaccadeRequestDistance());
        this.setTimeAttending(oldReadingState.getTimeAttending());
        this.setTimeInProgrammingSaccade(oldReadingState.getTimeInProgrammingSaccade());
        
        this.setPreviousWordLen(oldReadingState.getPreviousWordLen());
        this.setNextWordLen(oldReadingState.getNextWordLen());
        this.setNextNextWordLen(oldReadingState.getNextNextWordLen());
        this.setPreviousWordPredictability(oldReadingState.getPreviousWordPredictability());
        this.setNextWordPredictability(oldReadingState.getNextWordPredictability());
        this.setNextNextWordPredictability(oldReadingState.getNextNextWordPredictability());
    }
    
    
    
    public ReadingState(double [] doubleRepresentation)
    {
        this.setAttendedWordID((int) doubleRepresentation[0]);
        this.setAttendedWordLen((int) doubleRepresentation[1]);
        this.setAttendedWordPredictability(doubleRepresentation[2]);
        this.setDistanceFromAttendCenter((int) doubleRepresentation[3]);
        this.setEyePosition((int) doubleRepresentation[4]);
        this.setFixatedWordID((int) doubleRepresentation[5]);
        this.setIdentified(doubleRepresentation[6] == 1.0d);
        this.setProgrammingSaccade(doubleRepresentation[7] == 1.0d);
        this.setSaccadeRequestDistance((int) doubleRepresentation[8]);
        this.setTimeAttending((int) doubleRepresentation[9]);
        this.setTimeInProgrammingSaccade((int) doubleRepresentation[10]);
        
        this.setPreviousWordLen((int) doubleRepresentation[11]);
        this.setNextWordLen((int) doubleRepresentation[12]);
        this.setNextNextWordLen((int) doubleRepresentation[13]);
        this.setPreviousWordPredictability(doubleRepresentation[14]);
        this.setNextWordPredictability(doubleRepresentation[15]);
        this.setNextNextWordPredictability(doubleRepresentation[16]);
    }
    
    
    public ReadingState()
    {
        this.timeAttending = 0;
        this.attendedWordID = 0;
        this.attendedWordLen = 0;
        this.fixatedWordID = 0;
        this.distanceFromAttendCenter = 0;
        this.eyePosition = 0;
        this.identified = false;
    }
    
    public String toString()
    {
        return "STATE: [pos=" + getEyePosition()
        + ",fixWid=" + getFixatedWordID()
        + ",attWid="+getAttendedWordID()
        + ",attDst="+this.getDistanceFromAttendCenter()
        + ",attTIM="+this.getTimeAttending()
        + ",sacPrg="+this.isProgrammingSaccade()
        + ",sacPrgTIM="+this.getTimeInProgrammingSaccade()
        + ",sacDst="+this.getSaccadeRequestDistance()
        + ",ID'd?="+this.isIdentified()
        +",pred="+this.getAttendedWordPredictability()
        +",attlen="+this.getAttendedWordLen()
        +"]";
    }
    
    /** Any two objects which are equal must have equal HashCodes, but not necessarily the other way around. */
    public int hashCode()
    {
        if (isIdentified() == true)
            return  1 +
                    + 10 * getEyePosition()
                    + 1000 * getTimeAttending()
                    + 100000 * getSaccadeRequestDistance()
                    + 10000000 * getTimeInProgrammingSaccade();
        
        return  2 +
                + 10 * getEyePosition()
                + 1000 * getTimeAttending()
                + 100000 * getSaccadeRequestDistance()
                + 10000000 * getTimeInProgrammingSaccade();
        
        
    }
    
    public static int uniqueCode()
    {
        throw new RuntimeException("Unique codes are no longer used.");
    }
    
    public boolean equals(Object otherObject)
    {
        
        if (otherObject instanceof ReadingState)
        {
            ReadingState otherState = (ReadingState) otherObject;
            if (otherState.getTimeAttending() != this.getTimeAttending())       return false;
            if (otherState.getEyePosition() != this.getEyePosition())           return false;
            if (otherState.isProgrammingSaccade() != this.isProgrammingSaccade()) return false;
            if (otherState.getTimeInProgrammingSaccade() != this.getTimeInProgrammingSaccade()) return false;
            
            if (otherState.isIdentified() != this.isIdentified())               return false;
            if (otherState.getSaccadeRequestDistance() != this.getSaccadeRequestDistance())     return false;
            if (otherState.getFixatedWordID() != this.getFixatedWordID())       return false;
            
            if (otherState.getAttendedWordID() != this.getAttendedWordID())     return false;
            if (otherState.getAttendedWordLen() != this.getAttendedWordLen())   return false;
            if (otherState.getAttendedWordPredictability() != this.getAttendedWordPredictability()) return false;
            if (otherState.getDistanceFromAttendCenter() != this.getDistanceFromAttendCenter()) return false;
            
            return true;
        }
        return false;
    }
    
    
    public int getTimeAttending()
    {
        return timeAttending;
    }
    
    public void setTimeAttending(int timeAttending)
    {
        this.timeAttending = timeAttending;
    }
    
    public int getAttendedWordID()
    {
        return attendedWordID;
    }
    
    public void setAttendedWordID(int attendedWordID)
    {
        this.attendedWordID = attendedWordID;
    }
    
    public int getAttendedWordLen()
    {
        return attendedWordLen;
    }
    
    public void setAttendedWordLen(int attendedWordLen)
    {
        this.attendedWordLen = attendedWordLen;
    }
    
    public int getFixatedWordID()
    {
        return fixatedWordID;
    }
    
    public void setFixatedWordID(int fixatedWordID)
    {
        this.fixatedWordID = fixatedWordID;
    }
    
    public int getDistanceFromAttendCenter()
    {
        return distanceFromAttendCenter;
    }
    
    public void setDistanceFromAttendCenter(int distanceFromAttendCenter)
    {
        this.distanceFromAttendCenter = distanceFromAttendCenter;
    }
    
    public boolean isIdentified()
    {
        return identified;
    }
    
    public void setIdentified(boolean identified)
    {
        this.identified = identified;
    }
    
    public int getEyePosition()
    {
        return eyePosition;
    }
    
    public void setEyePosition(int eyePosition)
    {
        this.eyePosition = eyePosition;
    }
    
    
    public int getSaccadeRequestDistance()
    {
        return saccadeRequestDistance;
    }
    
    public void setSaccadeRequestDistance(int saccadeRequestDistance)
    {
        this.saccadeRequestDistance = saccadeRequestDistance;
    }
    
    /** Getter for property programmingSaccade.
     * @return Value of property programmingSaccade.
     *
     */
    public boolean isProgrammingSaccade()
    {
        return programmingSaccade;
    }
    
    /** Setter for property programmingSaccade.
     * @param programmingSaccade New value of property programmingSaccade.
     *
     */
    public void setProgrammingSaccade(boolean programmingSaccade)
    {
        this.programmingSaccade = programmingSaccade;
    }
    
    /** Getter for property timeInProgrammingSaccade.
     * @return Value of property timeInProgrammingSaccade.
     *
     */
    public int getTimeInProgrammingSaccade()
    {
        return timeInProgrammingSaccade;
    }
    
    /** Setter for property timeInProgrammingSaccade.
     * @param timeInProgrammingSaccade New value of property timeInProgrammingSaccade.
     *
     */
    public void setTimeInProgrammingSaccade(int timeInProgrammingSaccade)
    {
        this.timeInProgrammingSaccade = timeInProgrammingSaccade;
    }
    
    
    /** Getter for property attendedWordPredictability.
     * @return Value of property attendedWordPredictability.
     *
     */
    public double getAttendedWordPredictability()
    {
        return attendedWordPredictability;
    }
    
    /** Setter for property attendedWordPredictability.
     * @param attendedWordPredictability New value of property attendedWordPredictability.
     *
     */
    public void setAttendedWordPredictability(double attendedWordPredictability)
    {
        this.attendedWordPredictability = attendedWordPredictability;
    }
    
    /** Getter for property previousWordLen.
     * @return Value of property previousWordLen.
     *
     */
    public int getPreviousWordLen()
    {
        return previousWordLen;
    }
    
    /** Setter for property previousWordLen.
     * @param previousWordLen New value of property previousWordLen.
     *
     */
    public void setPreviousWordLen(int previousWordLen)
    {
        this.previousWordLen = previousWordLen;
    }
    
    /** Getter for property nextWordLen.
     * @return Value of property nextWordLen.
     *
     */
    public int getNextWordLen()
    {
        return nextWordLen;
    }
    
    /** Setter for property nextWordLen.
     * @param nextWordLen New value of property nextWordLen.
     *
     */
    public void setNextWordLen(int nextWordLen)
    {
        this.nextWordLen = nextWordLen;
    }
    
    /** Getter for property nextNextWordLen.
     * @return Value of property nextNextWordLen.
     *
     */
    public int getNextNextWordLen()
    {
        return 0;
        //return nextNextWordLen;
    }
    
    /** Setter for property nextNextWordLen.
     * @param nextNextWordLen New value of property nextNextWordLen.
     *
     */
    public void setNextNextWordLen(int nextNextWordLen)
    {
        return;
        //this.nextNextWordLen = nextNextWordLen;
    }
    
    /** Getter for property previousWordPredictability.
     * @return Value of property previousWordPredictability.
     *
     */
    public double getPreviousWordPredictability()
    {
        return 0;
        //return previousWordPredictability;
    }
    
    /** Setter for property previousWordPredictability.
     * @param previousWordPredictability New value of property previousWordPredictability.
     *
     */
    public void setPreviousWordPredictability(double previousWordPredictability)
    {
        return;
        //this.previousWordPredictability = previousWordPredictability;
    }
    
    /** Getter for property nextWordPredictability.
     * @return Value of property nextWordPredictability.
     *
     */
    public double getNextWordPredictability()
    {
        return 0;
        //return nextWordPredictability;
    }
    
    /** Setter for property nextWordPredictability.
     * @param nextWordPredictability New value of property nextWordPredictability.
     *
     */
    public void setNextWordPredictability(double nextWordPredictability)
    {
        return;
        //this.nextWordPredictability = nextWordPredictability;
    }
    
    /** Getter for property nextNextWordPredictability.
     * @return Value of property nextNextWordPredictability.
     *
     */
    public double getNextNextWordPredictability()
    {
        return 0;
        //return nextNextWordPredictability;
    }
    
    /** Setter for property nextNextWordPredictability.
     * @param nextNextWordPredictability New value of property nextNextWordPredictability.
     *
     */
    public void setNextNextWordPredictability(double nextNextWordPredictability)
    {
        return;
        //this.nextNextWordPredictability = nextNextWordPredictability;
    }
    
}
