package org.eyelanguage.rl.reading;

import java.util.*;
import java.io.*;

public class ReadingSet implements Serializable
{
    
    ArrayList sentenceWorlds = new ArrayList();
    ArrayList readingPolicies = new ArrayList();
    ArrayList reinforcementFs = new ArrayList();
    
    public ReadingSet()
    {
    }
    
    public void add(SentenceWorld sWorld, ReadingPolicy readingPolicy, ReadingReinforcementFunction rf)
    {
        sentenceWorlds.add(sWorld);
        readingPolicies.add(readingPolicy);
        reinforcementFs.add(rf);
        System.out.println(sWorld.getName() + " has been added to the ReadingSet");
    }
    
    public int getNumSentenceWorlds()
    {
        return sentenceWorlds.size();
    }
    
    public SentenceWorld getSentenceWorld(int i)
    {
        return (SentenceWorld) sentenceWorlds.get(i);
    }
    
    public ReadingPolicy getReadingPolicy(int i)
    {
        return (ReadingPolicy) readingPolicies.get(i);
    }
    
    public ReadingReinforcementFunction getReadingReinforcementFunction(int i)
    {
        return (ReadingReinforcementFunction) reinforcementFs.get(i);
    }
    
    public int getMaxWordLength()
    {
        int max = 0;
        for (int i = 0; i < sentenceWorlds.size(); i++)
        {
            SentenceWorld sWorld = (SentenceWorld) sentenceWorlds.get(i);
            for (int j = 0; j < sWorld.getNumWords(); j++)
            {
                Word w = sWorld.getWord(j);
                if (w.getLength() > max)
                {
                    max = w.getLength();
                }
            }
        }
        return max;
    }

    public int getMaxSentenceLength()
    {
        int max = 0;
        for (int i = 0; i < sentenceWorlds.size(); i++)
        {
            SentenceWorld sWorld = (SentenceWorld) sentenceWorlds.get(i);
            if (sWorld.getSentenceLength() > max)
            {
                max = sWorld.getSentenceLength();
            }
        }
        return max;
    }
    
    public int getTotalNumStates()
    {
        int result = 0;
        for (int i = 0; i < sentenceWorlds.size(); i++)
        {
            SentenceWorld sWorld = (SentenceWorld) sentenceWorlds.get(i);
            result = result + sWorld.getNumberOfStates();
        }
        return result;
    }
    
    public int getMAX_POSSIBLE_ID_TIME()
    {
        int max = ((SentenceWorld)sentenceWorlds.get(0)).getMAX_POSSIBLE_ATTEND_TIME();
        for (int i = 1; i < sentenceWorlds.size(); i++)
        {
            int test = ((SentenceWorld)sentenceWorlds.get(i)).getMAX_POSSIBLE_ATTEND_TIME();
            if (test > max)
            {
                max = test;
            }
        }
        return max;
    }

    public int getMAX_SACCADE_PROG_TIME()
    {
        int max = ((SentenceWorld)sentenceWorlds.get(0)).getMAX_SACCADE_PROG_TIME();
        for (int i = 1; i < sentenceWorlds.size(); i++)
        {
            int test = ((SentenceWorld)sentenceWorlds.get(i)).getMAX_SACCADE_PROG_TIME();
            if (test > max)
            {
                max = test;
            }
        }
        return max;
    }

    public int getMAX_POSSIBLE_ATTEND_TIME()
    {
        int max = ((SentenceWorld)sentenceWorlds.get(0)).getMAX_POSSIBLE_ATTEND_TIME();
        for (int i = 1; i < sentenceWorlds.size(); i++)
        {
            int test = ((SentenceWorld)sentenceWorlds.get(i)).getMAX_POSSIBLE_ATTEND_TIME();
            if (test > max)
            {
                max = test;
            }
        }
        return max;
    }

    public int getMIN_ATTEND_TIME_WITH_PENALTIES()
    {
        int min = ((SentenceWorld)sentenceWorlds.get(0)).getMIN_ATTEND_TIME_WITH_PENALTIES();
        for (int i = 1; i < sentenceWorlds.size(); i++)
        {
            int test = ((SentenceWorld)sentenceWorlds.get(i)).getMIN_ATTEND_TIME_WITH_PENALTIES();
            if (test < min)
            {
                min = test;
            }
        }
        return min;
    }
    
    public int getMAX_ATTEND_TIME_WITH_PENALTIES()
    {
        int max = ((SentenceWorld)sentenceWorlds.get(0)).getMAX_ATTEND_TIME_WITH_PENALTIES();
        for (int i = 1; i < sentenceWorlds.size(); i++)
        {
            int test = ((SentenceWorld)sentenceWorlds.get(i)).getMAX_ATTEND_TIME_WITH_PENALTIES();
            if (test > max)
            {
                max = test;
            }
        }
        return max;
    }
}
