/*
 * ReadingReinforcementFunction.java
 *
 * Created on February 17, 2004, 2:51 PM
 */

package org.eyelanguage.rl.reading;

import net.pakl.rl.*;
import java.util.*;

public class ReadingReinforcementFunction extends ReinforcementFunction
{
    int sentenceLength = 0;
    private SentenceWorld sWorld;
    double rewardForSuccessfulIdentification = 1.0d;
    double rewardForReachingTerminalState = 100.0d;
    double rewardForOffSentenceSaccades = -100.0d;
    
    public void setReinforcementsForActionsOntoTerminalState(double reward)
    {
        this.rewardForReachingTerminalState = reward;
    }
        
    public ReadingReinforcementFunction(SentenceWorld sWorld)
    {
        this.sWorld = sWorld;
        this.sentenceLength = sWorld.getSentenceLength();
    }
    
    private boolean saccadeOffSentence(State s, Action a)
    {
        ReadingState rs = (ReadingState) s;
        ReadingAction ra = (ReadingAction) a;
        if (rs.getEyePosition() + ra.getSaccadeRequestDistance() >= sentenceLength) return true;
        if (rs.getEyePosition() + ra.getSaccadeRequestDistance() < 0)               return true;
        return false;
    }

    public double getReward(State state, Action action)
    {
        throw new RuntimeException("Since eye movements might be stochastic, please pass in the resulting state using a different function call.");     
    }

    
    public double getReward(State state, Action action, State resultingState)
    {
        ReadingState readingState = (ReadingState) state;
        ReadingAction readingAction = (ReadingAction) action;
        ReadingState resultingReadingState = (ReadingState) resultingState;


        if (!readingState.isIdentified() &&  resultingReadingState.isIdentified())
        {
            return rewardForSuccessfulIdentification;
        }

        // Cannot just use action, because the resulting state may be random, different from actual resulting state
        // ReadingState resultingState = (ReadingState) sWorld.getNewState(readingState, readingAction, "rrf-getReward");
        if (sWorld.isTerminalState(resultingState))
        {
            return this.rewardForReachingTerminalState;
        }
        
        return this.getDefaultReinforcement();
    }
    
    
    public double getRewardForSuccessfulIdentification()
    {
        return rewardForSuccessfulIdentification;
    }
    
    public void setRewardForSuccessfulIdentification(double rewardForSuccessfulIdentification)
    {
        this.rewardForSuccessfulIdentification = rewardForSuccessfulIdentification;
    }
    
}
