package org.eyelanguage.rl.reading;
import net.pakl.rl.*;

import java.util.*;


public class ReadingPolicyParallel extends ReadingPolicy
{
    private static boolean ALLOW_SIMULTANEOUS_SACREQ_AND_ATTNEXT = false;
    private static boolean ALLOW_SIMULTANEOUS_ATTNEXT_AND_IDENT = false;
    
    private static boolean ALLOW_ARBITRARY_ATTENTION_SHIFTS = false;
    
    private SentenceWorldParallel sWorld = null;
    

    int maxSaccadeIntendedDistance = 10;

    /** Creates a new instance of ReadingPolicy */
    public ReadingPolicyParallel(SentenceWorld sWorld)
    {
        this.sWorld = (SentenceWorldParallel) sWorld;
    }

    public ReadingPolicyParallel()
    {
    }
    
    public void setALLOW_SIMULTANEOUS_SACREQ_AND_ATTNEXT(boolean newValue)
    {
        ALLOW_SIMULTANEOUS_SACREQ_AND_ATTNEXT = newValue;
        System.out.println("ReadingPolicyParallel: ALLOW_SIMULTANEOUS_SACREQ_AND_ATTNEXT set = " + newValue);
    }
    
    public void setALLOW_SIMULTANEOUS_ATTNEXT_AND_IDENT(boolean newValue)
    {
        ALLOW_SIMULTANEOUS_SACREQ_AND_ATTNEXT = newValue;
        System.out.println("ReadingPolicyParallel: ALLOW_SIMULTANEOUS_ATTNEXT_AND_IDENT set = " + newValue);
    }

    public void allowSaccadeActions(int eyePosition, int charsBack, int charsForward)
    {
        maxSaccadeIntendedDistance = Math.max(Math.abs(charsForward), Math.abs(charsBack));
    }

    public void setMaxSaccadeIntendedDistance(int x)
    {
        this.maxSaccadeIntendedDistance = x;
    }
    

    
    
    // We must over-ride here to allow rule actions to come through
    // synchronized so that parallel agents don't get stuck here on 
    // the get() method for the hashmaps below.
    public synchronized List getAllPossibleActions(State state)
    {
        throw new RuntimeException("Not implemented.");        
    }
    


    
    public String toString()
    {
        return "[a policy]";
    }
    
}
