/*
 * ReadingPolicy.java
 *
 * Created on February 16, 2004, 4:21 PM
 */

package org.eyelanguage.rl.reading;
import net.pakl.rl.*;

import java.util.*;


public class ReadingPolicy extends ActionSet
{
    private static boolean ALLOW_SIMULTANEOUS_SACREQ_AND_ATTNEXT = false;
    private static boolean ALLOW_SIMULTANEOUS_ATTNEXT_AND_IDENT = false;
    
    private SentenceWorld sWorld = null;
    
    private int maxSaccadeIntendedDistance = 10;
    
    /** Creates a new instance of ReadingPolicy */
    public ReadingPolicy(SentenceWorld sWorld)
    {
        this.sWorld = sWorld;
    }

    public ReadingPolicy()
    {
    }
    
    public void setALLOW_SIMULTANEOUS_SACREQ_AND_ATTNEXT(boolean newValue)
    {
        ALLOW_SIMULTANEOUS_SACREQ_AND_ATTNEXT = newValue;
        System.out.println("ReadingPolicy: ALLOW_SIMULTANEOUS_SACREQ_AND_ATTNEXT set = " + newValue);
    }
    
    public void setALLOW_SIMULTANEOUS_ATTNEXT_AND_IDENT(boolean newValue)
    {
        ALLOW_SIMULTANEOUS_SACREQ_AND_ATTNEXT = newValue;
        System.out.println("ReadingPolicy: ALLOW_SIMULTANEOUS_ATTNEXT_AND_IDENT set = " + newValue);
    }

    public void allowSaccadeActions(int eyePosition, int charsBack, int charsForward)
    {
        maxSaccadeIntendedDistance = Math.max(Math.abs(charsForward), Math.abs(charsBack));
    }

    public void setMaxSaccadeIntendedDistance(int x)
    {
        this.maxSaccadeIntendedDistance = x;
    }
    
    // We must over-ride here to allow rule actions to come through
    // synchronized so that parallel agents don't get stuck here on 
    // the get() method for the hashmaps below.
    public synchronized List getAllPossibleActions(State state)
    {
        if (sWorld.isTerminalState(state))
        {
            ReadingAction remainHere = new ReadingAction().setRemainHere(true).setAttendThisWord(false);
            ArrayList result = new ArrayList();
            result.add(remainHere);
            return result;
        }

        ArrayList result = new ArrayList();
        if (state instanceof ReadingState)
        {
            ReadingState readingState = (ReadingState) state;

            if (readingState.getTimeAttending() < (sWorld.MAX_ATTEND_TIME_WITH_PENALTIES - sWorld.MAX_SACCADE_PROG_TIME))
            {            
                    if (readingState.isIdentified() && !ALLOW_SIMULTANEOUS_SACREQ_AND_ATTNEXT)
                    {
                        // don't add saccade actions because only attendNext is allowed,
                        // not simultaneous sacc req.
                    }
                    else
                    if (!readingState.isProgrammingSaccade())
                    {
                        for (int i = -maxSaccadeIntendedDistance; i <= maxSaccadeIntendedDistance; i++)
                        {
                            if (i != 0)
                            {
                                if (isBetween(readingState.getEyePosition()+i, 0, sWorld.getSentenceLength()))
                                {
                                    result.add(new ReadingAction().setRequestingSaccade(true).setSaccadeRequestDistance(i));
                                }
                            }
                        }
                    }
            }
            
            if (readingState.isIdentified())
            {
                if (ALLOW_SIMULTANEOUS_SACREQ_AND_ATTNEXT)
                {
                    for (int i = 0; i < result.size(); i++)
                    {
                        ReadingAction action = (ReadingAction) result.get(i);
                        ReadingAction actionWithAttNext = new ReadingAction();
                        actionWithAttNext.copyFrom(action);
                        actionWithAttNext.setAttendNextWord(true);
                        if (ALLOW_SIMULTANEOUS_ATTNEXT_AND_IDENT) actionWithAttNext.setAttendThisWord(true);
                        result.set(i, actionWithAttNext);
                    }
                }
                
                if (ALLOW_SIMULTANEOUS_ATTNEXT_AND_IDENT)
                    result.add(new ReadingAction().setAttendNextWord(true).setAttendThisWord(true));
                else
                    result.add(new ReadingAction().setAttendNextWord(true).setAttendThisWord(false));
                
            }
            else
            {
                result.add(new ReadingAction().setAttendNextWord(false).setAttendThisWord(true));
            }
        }        
        
        return result;
    }
    
    protected boolean isBetween(int x, int lowerBound, int upperBound)
    {
        if (x < lowerBound) return false;
        if (x > upperBound) return false;
        return true;
    }
    
    public String toString()
    {
        return "[a policy]";
    }
    
}
