/*
 * ReadingReinforcementFunction.java
 *
 * Created on February 17, 2004, 2:51 PM
 */

package org.eyelanguage.rl.reading;

import net.pakl.rl.*;
import java.util.*;

public class ReadingParallelReinforcementFunction extends ReadingReinforcementFunction
{
    int sentenceLength = 0;
    private SentenceWorld sWorld;
    double rewardForSuccessfulIdentification = 1.0d;
    double rewardForReachingTerminalState = 100.0d;
    double rewardForOffSentenceSaccades = -100.0d;
    
    public void setReinforcementsForActionsOntoTerminalState(double reward)
    {
        this.rewardForReachingTerminalState = reward;
    }
        
    public ReadingParallelReinforcementFunction(SentenceWorld sWorld)
    {
        super(sWorld);
        this.sWorld = sWorld;
        this.sentenceLength = sWorld.getSentenceLength();
    }
    
    private boolean saccadeOffSentence(State s, Action a)
    {
        ReadingState rs = (ReadingState) s;
        ReadingAction ra = (ReadingAction) a;
        if (rs.getEyePosition() + ra.getSaccadeRequestDistance() >= sentenceLength) return true;
        if (rs.getEyePosition() + ra.getSaccadeRequestDistance() < 0)               return true;
        return false;
    }

    public double getReward(State state, Action action)
    {
        throw new RuntimeException("Since eye movements might be stochastic, please pass in the resulting state using a different function call.");
    }

    
    public double getReward(State state, Action action, State resultingState)
    {
        ReadingStateParallelRelative readingState = (ReadingStateParallelRelative) state;
        ReadingAction readingAction = (ReadingAction) action;
        ReadingStateParallelRelative resultingReadingState = (ReadingStateParallelRelative) resultingState;

        if (resultingReadingState.getNumIdentified() > readingState.getNumIdentified())
        {
            int numberOfIdentifiedWords = resultingReadingState.getNumIdentified() -  readingState.getNumIdentified();
            return numberOfIdentifiedWords * rewardForSuccessfulIdentification;
        }

        if (sWorld.isTerminalState(resultingState))
        {
            return this.rewardForReachingTerminalState;
        }

        return getDefaultReinforcement();
        
    }
    
    
    
    public double getRewardForSuccessfulIdentification()
    {
        return rewardForSuccessfulIdentification;
    }
    
    public void setRewardForSuccessfulIdentification(double rewardForSuccessfulIdentification)
    {
        this.rewardForSuccessfulIdentification = rewardForSuccessfulIdentification;
    }
    
}
