

package org.eyelanguage.rl.reading;

import net.pakl.rl.*;
import java.util.*;

public class ReadingAction implements Action
{
    protected boolean requestingSaccade = false;
    protected boolean attendNextWord = false;
    protected int saccadeRequestDistance = 0;
    protected boolean attendThisWord = true;
    protected boolean remainHere = false;
    public static final int MAXIMUM_SACCADE_DISTANCE = 10;
    
    private boolean SAFE_MODE = false;
    
    public void copyFrom(ReadingAction o)
    {
        this.requestingSaccade = o.requestingSaccade;
        this.attendNextWord = o.attendNextWord;
        this.saccadeRequestDistance = o.saccadeRequestDistance;
        this.attendThisWord = o.attendThisWord;
        this.remainHere = o.remainHere;
    }
    
    public ReadingAction()
    {
    }
    
    public static void main(String args[])
    {
        test();
    }
    
    public static void test()
    {
        ArrayList uniques = new ArrayList();

        ReadingAction ra = new ReadingAction();
        ra.setRequestingSaccade(true);
        ra.setAttendNextWord(false);
        ra.setRequestingSaccade(true);
        for (int i = -10; i <= 10; i++)
        {
            ra.setSaccadeRequestDistance(i);
            check(uniques, ra);
        }
        ra.setRequestingSaccade(false);
        ra.setAttendNextWord(true);
        check(uniques, ra);
//        ra.setRequestingSaccade(true);
//        for (int i = -10; i <= 10; i++)
//        {
//            ra.setSaccadeRequestDistance(i);
//            check(uniques, ra);
//        }

        ra.setRequestingSaccade(false);
        ra.setAttendNextWord(false);
        ra.setAttendThisWord(true);
        check(uniques, ra);
//        ra.setRequestingSaccade(true);
//        for (int i = -10; i <= 10; i++)
//        {
//            ra.setSaccadeRequestDistance(i);
//            check(uniques, ra);
//        }

        ra.setRequestingSaccade(false);
        ra.setAttendNextWord(false);
        ra.setAttendThisWord(false);
        ra.setRemainHere(true);
        check(uniques, ra);
        
        ra = new ReadingAction();
        ra.setAttendNextWord(true);
        ra.setAttendThisWord(false);
        check(uniques, ra);
    }
    
    public static void check(ArrayList uniques, ReadingAction ra)
    {
        System.out.println(ra+"\t"+ra.uniqueCode());
        int uniqueCode = ra.uniqueCode();
        Integer i = new Integer(uniqueCode);
        if (uniques.contains(i))
        {
            throw new RuntimeException("Fails.");
        }
        uniques.add(i);
    }
    
    public int uniqueCode()
    {
        if (SAFE_MODE)
        {
            if (isRequestingSaccade() && isAttendNextWord())
            {
                System.out.println(this);
                System.out.println("isRequestingSaccade() = " + isRequestingSaccade());
                System.out.println("isAttendNextWord() = " + isAttendNextWord());
                throw new RuntimeException("Unique Action Code not defined for both request saccade and attend word shift.");
            }
        }
        int result = 0;
        if (this.isRequestingSaccade()) result += 1;
        if (this.isAttendNextWord()) result += 2;
        if (this.isAttendThisWord()) result += 4;
        if (this.isRemainHere()) result += 8;
        int jumpCode = (2 * MAXIMUM_SACCADE_DISTANCE + this.getSaccadeRequestDistance());
        if (SAFE_MODE)
        {
            if (jumpCode < 0) throw new RuntimeException("Got negative jump code; cannot tolerate that for unique action codes.");
        }
        if (this.isRequestingSaccade())
            result = result + (8+4+2+1) + jumpCode;
        return result;
    }
    
    public int hashCode()
    {
        int result = 0;
        if (this.isRequestingSaccade()) result += 1;
        if (this.isAttendNextWord()) result += 2;
        if (this.isAttendThisWord()) result += 4;
        if (this.isRemainHere()) result += 8;
        return result;
    }
    public boolean equals(Object o)
    {
        if (o instanceof ReadingAction)
        {
            ReadingAction other = (ReadingAction) o;
            if (this.isRequestingSaccade() != other.isRequestingSaccade()) return false;
            if (this.isAttendNextWord() != other.isAttendNextWord()) return false;
            if (this.isAttendThisWord() != other.isAttendThisWord()) return false;
            if (this.isRemainHere() != other.isRemainHere()) return false;
            if (this.getSaccadeRequestDistance() != other.getSaccadeRequestDistance()) return false;
            return true;
        }
        return false;
    }
    public String toString()
    {
        String result = "ACTION: ";
        if (this.isRemainHere()) result += "Remain|";
        if (isRequestingSaccade()) 
        {   
            result += "ReqSacc"+this.saccadeRequestDistance+"|";
        }

        if (isAttendNextWord()) 
        {   
            result += "AttNext|";
        }
        if (attendingWord()) result += "Ident|";

        return result;
    }
    
    public boolean attendingWord()
    {
        return attendThisWord;
    }
    

    public boolean isRequestingSaccade()
    {
        return requestingSaccade;
    }
    
    public ReadingAction setRequestingSaccade(boolean requestingSaccade)
    {
        this.requestingSaccade = requestingSaccade;
        return this;
    }
    
    public boolean isAttendNextWord()
    {
        return attendNextWord;
    }
    
    public ReadingAction setAttendNextWord(boolean attendNextWord)
    {
        this.attendNextWord = attendNextWord;
        return this;
    }
    
    public int getSaccadeRequestDistance()
    {
        return saccadeRequestDistance;
    }
    
    public ReadingAction setSaccadeRequestDistance(int saccadeRequestDistance)
    {
        this.saccadeRequestDistance = saccadeRequestDistance;
        return this;
    }
    
    /** Getter for property attendThisWord.
     * @return Value of property attendThisWord.
     *
     */
    public boolean isAttendThisWord()
    {
        return attendThisWord;
    }
    
    /** Setter for property attendThisWord.
     * @param attendThisWord New value of property attendThisWord.
     *
     */
    public ReadingAction setAttendThisWord(boolean attendThisWord)
    {
        this.attendThisWord = attendThisWord;
        return this;
    }
    
    /** Getter for property remainHere.
     * @return Value of property remainHere.
     *
     */
    public boolean isRemainHere()
    {
        return remainHere;
    }
    
    /** Setter for property remainHere.
     * @param remainHere New value of property remainHere.
     *
     */
    public ReadingAction setRemainHere(boolean remainHere)
    {
        this.remainHere = remainHere;
        return this;
    }
    
}
