package org.eyelanguage.rl.reading;
import net.pakl.rl.*;

/** Wraps a normal value function but converts parallel states into serial 
 * states before relaying state value requests 
 * to the value function.  This is an instance of the "decorator" pattern.
 */
public class ParallelToSerialVFAdapter implements ValueFunction
{
    ValueFunction adaptedValueFunction;
    public final double SERIAL_ATTEND_INTERVAL = 5.0d;
    public ParallelToSerialVFAdapter(ValueFunction vf)
    {
        adaptedValueFunction = vf;
    }
    
    public void setWorld(World w)
    {
        adaptedValueFunction.setWorld(w);
    }

    public double getValue(State state)
    {
        ReadingStateRelative converted = convertParallelToSerial((ReadingStateParallelRelative) state);
        return adaptedValueFunction.getValue(converted);
    }

    /** Exploits the copyFrom() method of ReadingStates such that a newly 
     * created serial state (ReadingStateRelative) will automagically extract
     * the information it needs from a parallel state -- the only other thing
     * is that time spent attending has to be rounded to the granularity 
     * of which the agent was trained (e.g. 5). */
    public ReadingStateRelative convertParallelToSerial(ReadingStateParallelRelative s)
    {
        throw new RuntimeException("Not yet implemented.");
    }
    
    public String getName()
    {
        return adaptedValueFunction.getName();
    }

    public void setName(String name)
    {
        throw new RuntimeException("Adaptor is read-only.");
    }

    public void setValue(State state, double newValue)
    {
        throw new RuntimeException("Adaptor is read-only.");
    }

    public void setValueOfTerminalStates(double newValueOfTerminalStates)
    {
        throw new RuntimeException("Adaptor is read-only.");
    }
    
    public void setValueOfOutOfBoundsStates(double newValueOfOutOfBoundsStates)
    {
        throw new RuntimeException("Adaptor is read-only.");
    }
}
