package org.eyelanguage.rl.reading;
import java.util.*;

public class Corpus
{    
    ArrayList <Item> items = new ArrayList<Item>();
    class Item
    {
        public String sentence = new String();
        public String times = new String();
        public String overriddenLengths = new String();
        public String predictabilities = new String();
    }
    
    public void addSentence(String sentence, String overriddenWordLengths, String wordTimes, String wordPredictabilities)
    {
        Item item = new Item();
        item.sentence = sentence;
        item.times = wordTimes;
        item.overriddenLengths = overriddenWordLengths; 
        item.predictabilities = wordPredictabilities;
        items.add(item);
    }
    
    public void shuffle()
    {
        Collections.shuffle(items);
    }
    
    public String getSentence(int i)
    {
        return items.get(i).sentence;
    }
    public String getPredictabilites(int i)
    {
        return items.get(i).predictabilities;
    }
    public String getOverridenLengths(int i)
    {
        return items.get(i).overriddenLengths;
    }
    public String getTimes(int i)
    {
        return items.get(i).times;
    }
    
    
    
}
