package org.eyelanguage.rl.analysis;

import net.pakl.rl.*;
import java.util.*;
import java.io.*;
import java.util.zip.*;

public class ValueFunctionDumper
{
    public static void main(String args[]) throws Exception
    {
        String filename = args[0];
        ValueFunctionHashMap vf = loadValueFunction(filename);
        
        Iterator states = vf.getKeySetIterator();
        while (states.hasNext())
        {
            State s = (State) states.next();
            //System.out.println(s + " = " + vf.getValue(s));
            org.eyelanguage.rl.reading.ReadingStateRelative rs = (org.eyelanguage.rl.reading.ReadingStateRelative) s;
            System.out.println(pad(s.toString(), 150, " ") + "\t[" + net.pakl.rl.VectorTools.vectorToText(rs.doubleRepresentation()) +"]\t= " + vf.getValue(s));
        }
    }
    
    public static ValueFunctionHashMap loadValueFunction(String filename) throws Exception
    {
        ObjectInputStream ois = null;
        if (filename.endsWith(".gz"))
        {
            System.err.println("Opening compressed object stream.");
            ois = new ObjectInputStream(new GZIPInputStream(new FileInputStream(filename)));
        }
        else
        {
            System.err.println("Opening noncompressed object stream.");
            ois = new ObjectInputStream(new FileInputStream(filename));
        }
        System.err.println("Reading value function object into memory.");
        ValueFunctionHashMap vf = (ValueFunctionHashMap) ois.readObject();
        return vf;
    }
    
  private static String pad(Object str, int padlen, String pad)
    {
    String padding = new String();
    int len = Math.abs(padlen) - str.toString().length();
    if (len < 1)
      return str.toString();
    for (int i = 0 ; i < len ; ++i)
      padding = padding + pad;
      
    return (padlen < 0 ? padding + str : str + padding);
    }

    
}
