/*
 * VFPerceptronVisualizer.java
 *
 * Created on June 23, 2006, 11:46 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.eyelanguage.rl.analysis;
import net.pakl.rl.*;
import net.pakl.neuralnet.*;
import java.io.*;
import java.util.zip.*;

/** Allows visualization using GraphViz / dot of the weights in the perceptron underlying
 * a value function. */
public class VFPerceptronVisualizer
{
    
    /** Creates a new instance of VFPerceptronVisualizer */
    public VFPerceptronVisualizer()
    {
    }

    public static void main(String args[]) throws Exception
    {

        if (args.length < 3) 
        {
            System.out.println("Syntax: ___ filename threshold scale");
            System.exit(-1);
        }
        new VFPerceptronVisualizer().run(args[0], args[1], args[2]);
    }
    
    public void run(String filename, String threshold, String scale) throws Exception
    {
        ValueFunctionPerceptron v = load(filename);
        System.out.println(v.getNetwork().getGraphviz(new Double(threshold).doubleValue(), new Double(scale).doubleValue()));
    }
    
    public static ValueFunctionPerceptron load(String filename) throws Exception
    {
        ObjectInputStream ois = null;
        if (filename.endsWith(".gz"))
        {
            System.err.println("Opening compressed object stream.");
            ois = new ObjectInputStream(new GZIPInputStream(new FileInputStream(filename)));
        }
        else
        {
            System.err.println("Opening noncompressed object stream.");
            ois = new ObjectInputStream(new FileInputStream(filename));
        }
        System.err.println("Reading value function object into memory.");
        ValueFunctionPerceptron vf = (ValueFunctionPerceptron) ois.readObject();
        return vf;
    }    
}
