package org.eyelanguage.rl.analysis;

import net.pakl.rl.*;


import java.io.*;
import java.util.*;
import org.eyelanguage.rl.reading.ReadingMain;
import org.eyelanguage.rl.reading.ReadingPolicy;
import org.eyelanguage.rl.reading.ReadingReinforcementFunction;
import org.eyelanguage.rl.reading.ReadingStateFactory;
import org.eyelanguage.rl.reading.ReadingStateRelative;
import org.eyelanguage.rl.reading.SentenceWorld;
import org.eyelanguage.rl.reading.Toolbox;


/** Lists the optimal actions given any starting state and any reading.prop world. */
public class OptimalActionsLister extends ReadingMain
{
    public static void main(String args[])
    {
        try
        {
            new OptimalActionsLister().run(args);
        }
        catch (Exception e)
        {
            System.out.println("Sorry, an error occured:  " + e.getMessage());
        }
    }
    
    public void run(String args[]) throws Exception
    {
        String valueFunctionFilename = args[0];
        String startingStateString = args[1];
        
        loadProperties();
        
        SentenceWorld sWorld = recreateSentenceWorld();
        ReadingPolicy readingPolicy = Toolbox.createSimpleReadingPolicy(sWorld);
        ReadingReinforcementFunction rf = new ReadingReinforcementFunction(sWorld);
        rf.setDefaultReinforcement(defaultReinforcement);
        rf.setRewardForSuccessfulIdentification(identifyReinforcement);
        rf.setReinforcementsForActionsOntoTerminalState(reachTerminalReinforcement);
        PolicyExtractor extractor = new PolicyExtractor();

        ValueFunction vf = ValueFunctionDumper.loadValueFunction(valueFunctionFilename);
        
        
        ReadingStateRelative startState = new ReadingStateRelative();
        startState.parseString(startingStateString);
        extractor.forceInitialState(startState);
        
        throw new RuntimeException("discountFactor must be entered here");
        //String result = extractor.extractOptimalPolicy(readingPolicy, vf, sWorld, sWorld, rf, discountFactor);
        //System.out.println(result);
    }

    public SentenceWorld recreateSentenceWorld()
    {
        SentenceWorld sWorld = new SentenceWorld("environment", randomSeed);
        sWorld.setupReadingStateFactory(ReadingStateFactory.RELATIVE_READING_STATES);
        sWorld.setMAX_SACCADE_PROG_TIME(saccPrgTime);
        sWorld.SACCADIC_ERROR = saccadicError;
        sWorld.SACCADIC_ERROR_GAUSSIAN = saccadicErrorGaussian;
        sWorld.SACCADIC_ERROR_SPREAD = saccadicErrorSpread;
        sWorld.ACUITY_LINEAR_PENALIZE = acuityLinearPenalize;
        sWorld.SACCADE_TIME_PENALTY = saccadeTimePenalty;
        sWorld.setSentence(sentence, predictabilities, aidTimes);
        if (!sWorld.getIsBuilt()) sWorld.build();
        return sWorld;
    }
}