package org.eyelanguage.rl.analysis;
import java.io.*;
import java.util.*;

public class LogAnalyzer
{
    
    public static boolean SKIP_INTERNAL_ANALYSIS = false;
    public static boolean ENABLE_FIXATION_SPACE_BEFORE_WORD = true;
    public static boolean EXCLUDE_LAST_WORD_FROM_ANALYSIS = true;
    public static boolean EXCLUDE_FIRST_WORD_FROM_ANALYSIS = true;
    
    public static final int MS_PER_TIMESTEP = 5;
    public LogAnalyzer(String logFileName) throws Exception
    {
        process(logFileName);
    }
    public LogAnalyzer()
    {
    }
    
    int lastWordID = 0;
    protected void process(String logFileName) throws Exception
    {
        BufferedReader inputFile = new BufferedReader(new FileReader(logFileName));
        int count = 0;
        
        HashMap wordLenToInitialFixationPos = new HashMap();
        HashMap wordLenToRefixationPos = new HashMap();
        HashMap wordLenToAttIdDuration = new HashMap();
        HashMap wordLenToFixationDuration = new HashMap();
        HashMap wordLenToAttSaccreqDuration = new HashMap();
        HashMap wordLenToFixationDurations = new HashMap();
        HashMap wordLenToGazeDurations = new HashMap();
        
        HashMap wordLenToRefixations = new HashMap();
        HashMap wordLenToSkips = new HashMap();
        
        
        ArrayList fixationDurations = new ArrayList();
        double numFixated = 0;  double numAttended = 0;  double numSkipped = 0;
        ArrayList refixations = new ArrayList();
        HashMap preSacOFFReqFixTimeFromFirstFixation = new HashMap();
        HashMap preSacOFFReqFixTimeFromRefixation = new HashMap();
        ArrayList statesDump = new ArrayList();
        while (inputFile.ready())
        {
            count++;
            
            List<String> visitedStates = loadVisitedStates(inputFile);
            
            // System.out.println("For test #"+count+", found " + visitedStates.size() + " visited states.");
            List<Integer> attendedWordIDs = extractValues("attWid", visitedStates);
            HashSet<Integer> attWIDHash = new HashSet();
            attWIDHash.addAll(attendedWordIDs);
            lastWordID = attWIDHash.size() - 1;
            
            List<Integer> eyePositions = extractValues("eyepos", visitedStates);
            List<Integer> fixatedWordIDs = extractValues("fixWid", visitedStates);
            List<Integer> intendedSaccadeDistance = null;
            
            
            try
            {
                intendedSaccadeDistance = extractValues("sacDst", visitedStates);
            }
            catch (Exception e)
            {
                // System.out.println("sacDst could not be retrieved, trying sacReqDst");
                intendedSaccadeDistance = extractValues("sacReqDst", visitedStates);
            }
            
            if (!SKIP_INTERNAL_ANALYSIS)
            {
                
                HashSet fixWIDHash = new HashSet();
                fixWIDHash.addAll(fixatedWordIDs);
                System.out.println("LastWordID: " + lastWordID);
                
                appendWordLenToInitialFixationPos(wordLenToInitialFixationPos, visitedStates);
                appendWordLenToAllReFixationPos(wordLenToRefixationPos, visitedStates);
                appendWordLenToRefixationCount(wordLenToRefixations, visitedStates);
                appendWordLenToSkipCount(wordLenToSkips, visitedStates);
                
                appendLengthToGazeDurations(wordLenToGazeDurations, visitedStates);
                
                appendLengthToAttWidTimestepCounts(wordLenToAttIdDuration, "ID'd?=false", visitedStates);
                appendLengthToAttWidTimestepCounts(wordLenToAttIdDuration, "identified=false", visitedStates);
                appendLengthToAttWidTimestepCounts(wordLenToAttSaccreqDuration, "sacPrg=false", visitedStates);
                appendLengthToFixationDurations(wordLenToFixationDurations, visitedStates);
                
                appendFixationDurations(fixationDurations, visitedStates);
                appendRefixations(refixations, visitedStates);
                appendPresaccadeOFFRequestFixTime(preSacOFFReqFixTimeFromFirstFixation, preSacOFFReqFixTimeFromRefixation, visitedStates);
                numFixated += fixWIDHash.size();
                numAttended += attWIDHash.size();
                numSkipped += (attWIDHash.size() - fixWIDHash.size());
            }
            
            
            
            statesDump.add("T,Eye,IntendSacc,AttWord,FixWord");
            
            for (int v = 0; v < visitedStates.size(); v++)
            {
                // statesDump.add(v+","+eyePositions.get(v)+","+intendedSaccadeDistance.get(v)+","+attendedWordIDs.get(v)+","+fixatedWordsSpacePreceeding.get(v));
                statesDump.add(v+","+eyePositions.get(v)+","+intendedSaccadeDistance.get(v)+","+attendedWordIDs.get(v)+","+fixatedWordIDs.get(v));
            }
            
        }
        
        if (!SKIP_INTERNAL_ANALYSIS)
        {
            // PRINT OUT ALL INITIAL FIXATION POSITIONS
            System.out.println("*** Initial Fixation Landing Sites");
            {
                Iterator i = wordLenToInitialFixationPos.keySet().iterator();
                while (i.hasNext())
                {
                    Object k = i.next();
                    System.out.print("Initial fixation, len " + k + ": ");
                    List v = (List) wordLenToInitialFixationPos.get(k);
                    Iterator j = v.iterator();
                    while (j.hasNext())
                    {
                        System.out.print(j.next() + " ");
                    }
                    System.out.println("");
                }
            }
            System.out.println("");
            // PRINT OUT ALL REFIXATION POSITIONS
            System.out.println("*** Refixation Landing Sites");
            {
                Iterator i = wordLenToRefixationPos.keySet().iterator();
                while (i.hasNext())
                {
                    Object k = i.next();
                    System.out.print("Refixation, len " + k + ": ");
                    List v = (List) wordLenToRefixationPos.get(k);
                    Iterator j = v.iterator();
                    while (j.hasNext())
                    {
                        System.out.print(j.next() + " ");
                    }
                    System.out.println("");
                }
            }
            System.out.println("");
            
            
            
            System.out.print("Average fixation duration was: " + average(fixationDurations) + " ms");
            System.out.println(" (" + (average(fixationDurations).doubleValue()/MS_PER_TIMESTEP) + " time steps)");
            System.out.println("Average fixation time before SacReq OFF FIXATED WORD (initial fix)= "+ sortedPrint(averageForKeys(preSacOFFReqFixTimeFromFirstFixation)) + "");
            System.out.println("Average fixation time before SacReq OFF FIXATED WORD (refixation )= "+ sortedPrint(averageForKeys(preSacOFFReqFixTimeFromRefixation)) + "");
            System.out.println("Num words attended = " + numAttended);
            System.out.println("Num words fixated  = " + numFixated + " ("+ (100*numFixated/numAttended) +"%)");
            System.out.println("Num words skipped  = " + numSkipped + " ("+ (100*numSkipped/numAttended) +"%)");
            
            double numRefixated = refixations.size();
            System.out.println("Num of refixations = " + numRefixated + " ("+ (100*numRefixated/numFixated) +"%)");
            
            System.out.println("\n***Average Time spent Attending Words (by word length):" + sortedPrint(averageForKeys(wordLenToAttIdDuration)));
            System.out.println("***Average Time Attending Words before Saccade Programming Request (by word length):" + sortedPrint(averageForKeys(wordLenToAttSaccreqDuration)));
            System.out.println("***Average Time spent Fixating Words (by word length): " + sortedPrint(averageForKeys(wordLenToFixationDurations)));
            System.out.println("***Average total gaze durations (by word length): " + sortedPrint(averageForKeys(wordLenToGazeDurations)));
            System.out.println("***Skip counts (by word length): " + sortedPrint(wordLenToSkips));
            System.out.println("***Refixation counts (by word length): " + sortedPrint(wordLenToRefixations));
            System.out.println("\nBreak it down, yo!");
            System.out.println("***How long was each word attended? (by word length): "+sortedPrint(wordLenToAttIdDuration));
            System.out.println("***How long was each word attended *before* a saccade request?: " + sortedPrint(wordLenToAttSaccreqDuration));
            System.out.println("***Fixation durations for each word length: " + sortedPrint(wordLenToFixationDurations));
            System.out.println("***Timesteps from Initial Fixation before Off-word Saccade Request: " + sortedPrint(preSacOFFReqFixTimeFromFirstFixation));
            System.out.println("***Timesteps from Refixation before Off-word Saccade Request: " + sortedPrint(preSacOFFReqFixTimeFromRefixation));
            System.out.println("***Total Gaze durations for each word length: " + sortedPrint(wordLenToGazeDurations));
        }
        System.out.println("Dump of visited states\n");
        for (int v = 0; v < statesDump.size(); v++)
        {
            System.out.println(statesDump.get(v));
        }
    }
    
    private String sortedPrint(HashMap h)
    {
        String result = "";
        ArrayList keys = new ArrayList();
        keys.addAll(h.keySet());
        Collections.sort(keys);
        Iterator i = keys.iterator();
        while (i.hasNext())
        {
            Object key = i.next();
            result += "\n";
            result += key + ": ";
            result += h.get(key);
        }
        return result+"\n";
    }
    
    private HashMap averageForKeys(HashMap h)
    {
        HashMap result = new HashMap();
        Iterator i = h.keySet().iterator();
        while (i.hasNext())
        {
            Object key = i.next();
            List values = (List) h.get(key);
            Iterator j = values.iterator();
            double count = 0; double sum = 0;
            while (j.hasNext())
            {
                count = count + 1;
                double value = Double.parseDouble(j.next()+"");
                sum = sum + value;
            }
            result.put(key, new Double(sum/count));
        }
        return result;
    }
    
    private void appendRefixations(List refixations, List visitedStates)
    {
        List<Integer> fixatedWordIDs = extractValues("fixWid", visitedStates);
        List<Integer> saccadeDistances = extractValues("sacDst", visitedStates);
        // when sacPrg **becomes** 0, we have just saccaded
        // that is a fixation "action"
        Integer previous = null;
        HashSet<Integer> alreadyFixatedIDs = new HashSet();
        for (int i = 0; i < saccadeDistances.size(); i++)
        {
            Integer current = saccadeDistances.get(i);
            Integer fixatedWordID = fixatedWordIDs.get(i);
            if (previous != null)
            {
                if ((previous!=0) && (current==0))
                {
                    if (alreadyFixatedIDs.contains(fixatedWordID) && justLanded(visitedStates, i))
                    {
                        if (EXCLUDE_LAST_WORD_FROM_ANALYSIS && (fixatedWordID == lastWordID))
                        {
                        }
                        else
                            if (EXCLUDE_FIRST_WORD_FROM_ANALYSIS && (fixatedWordID == 0))
                            {
                            }
                            else
                            {
                            refixations.add(visitedStates.get(i));
                            }
                    }
                    if (EXCLUDE_LAST_WORD_FROM_ANALYSIS && (fixatedWordID == lastWordID))
                    {
                    }
                    else
                        if (EXCLUDE_FIRST_WORD_FROM_ANALYSIS && (fixatedWordID == 0))
                        {
                        }
                        else
                        {
                        alreadyFixatedIDs.add(fixatedWordID);
                        }
                }
            }
            previous = current;
        }
    }
    
    
    // when sacPrg **becomes** NONZERO, we have just issued a saccade request
    private void appendPresaccadeOFFRequestFixTime(HashMap resultFromFirstFixation, HashMap resultFromRefixation, List visitedStates)
    {
        HashMap wordIDToWordLength = getWordIDToWordLength();
        List<Integer> fixatedWordIDs = extractValues("fixWid", visitedStates);
        List<Integer> saccadeDistances = extractValues("sacDst", visitedStates);
        Integer previousDist = null; Integer previousWID = null; Integer currentWID = null;
        HashSet hasBeenRefixated = new HashSet(); HashSet hasBeenFixated = new HashSet();
        int fixationTimeBeforeSacReq = 0;
        for (int i = 0; i < saccadeDistances.size(); i++)
        {
            Integer currentDist = saccadeDistances.get(i);
            currentWID = fixatedWordIDs.get(i);
            if (previousDist != null)
            {
                if ((previousDist==0) && (currentDist!=0)
                && ifOffWordSaccadeRequest(i, visitedStates)) // interested in saccs to new words only
                {
                    fixationTimeBeforeSacReq += MS_PER_TIMESTEP;
                    System.out.println("\nSACREQOFF: " + visitedStates.get(i));
                    if (hasBeenRefixated.contains(currentWID))
                    {
                        if (EXCLUDE_LAST_WORD_FROM_ANALYSIS && (currentWID == lastWordID))
                        {
                        }
                        else
                            if (EXCLUDE_FIRST_WORD_FROM_ANALYSIS && (currentWID == 0))
                            {
                            }
                            else
                            {
                            mapOfListsAppend(resultFromRefixation, wordIDToWordLength.get(currentWID),
                                    new Double(fixationTimeBeforeSacReq/MS_PER_TIMESTEP));
                            }
                    }
                    else
                    {
                        if (EXCLUDE_LAST_WORD_FROM_ANALYSIS && (currentWID == lastWordID))
                        {
                        }
                        else
                            if (EXCLUDE_FIRST_WORD_FROM_ANALYSIS && (currentWID == 0))
                            {
                            }
                            else
                            {
                            mapOfListsAppend(resultFromFirstFixation, wordIDToWordLength.get(currentWID),
                                    new Double(fixationTimeBeforeSacReq/MS_PER_TIMESTEP));
                            }
                    }
                    System.out.println("So fix time for len "+wordIDToWordLength.get(currentWID)+" is  " + fixationTimeBeforeSacReq/MS_PER_TIMESTEP);
                    fixationTimeBeforeSacReq = 0;
                }
                else
                {
                    fixationTimeBeforeSacReq += MS_PER_TIMESTEP;
                }
                // Reset when we fixate or refixate
                if (justLanded(visitedStates, i))
                {
                    fixationTimeBeforeSacReq = 0;		// Refixation also resets the counter
                    if (EXCLUDE_LAST_WORD_FROM_ANALYSIS && (currentWID == lastWordID))
                    {
                    }
                    else
                        if (EXCLUDE_FIRST_WORD_FROM_ANALYSIS && (currentWID == 0))
                        {
                        }
                        else
                        {
                        if (hasBeenFixated.contains(currentWID)) hasBeenRefixated.add(currentWID);
                        hasBeenFixated.add(currentWID);
                        }
                }
            }
            previousDist = currentDist;
            previousWID = currentWID;
        }
    }
    
    private void appendWordLenToRefixationCount(HashMap result, List visitedStates)
    {
        HashMap <Integer,Integer> wordIDToWordLength = getWordIDToWordLength();
        List<Integer> fixatedWordIDs = extractValues("fixWid", visitedStates);
        List sacDst = extractValues("sacDst", visitedStates);
        
        Iterator <Integer> w = wordIDToWordLength.keySet().iterator();
        int fixationCount = 1;	// fixated first word
        if (EXCLUDE_FIRST_WORD_FROM_ANALYSIS)
        { fixationCount = 0; }
        while (w.hasNext())
        {
            Integer wid = w.next();
            if (EXCLUDE_LAST_WORD_FROM_ANALYSIS && (wid == lastWordID))
            {
            }
            else
                if (EXCLUDE_FIRST_WORD_FROM_ANALYSIS && (wid == 0))
                {
                }
                else
                {
                for (int i = 1; i < visitedStates.size(); i++)
                {
                    if (wid.equals(fixatedWordIDs.get(i))
                    && sacDst.get(i).equals(new Double(0))
                    && !sacDst.get(i-1).equals(new Double(0)))
                    {
                        System.out.println("Word ID "+wid+" was fixated:\n" + visitedStates.get(i-1) +"\n" + visitedStates.get(i));
                        fixationCount++;
                    }
                }
                if (fixationCount > 1)
                {
                    mapOfListsAppend(result, wordIDToWordLength.get(wid), new Double(fixationCount-1));
                }
                }
            fixationCount = 0;
        }
        
    }
    
    private void appendWordLenToSkipCount(HashMap result, List visitedStates)
    {
        HashMap <Integer,Integer> wordIDToWordLength = getWordIDToWordLength();
        List<Integer> fixatedWordIDs = extractValues("fixWid", visitedStates);
        Iterator <Integer> w = wordIDToWordLength.keySet().iterator();
        while (w.hasNext())
        {
            Integer wid = w.next();
            boolean found = false;
            for (int i = 0; i < visitedStates.size(); i++)
            {
                if (wid.equals(fixatedWordIDs.get(i)))
                {
                    found = true;
                }
            }
            if (found == false)
            {
                if (EXCLUDE_LAST_WORD_FROM_ANALYSIS && (wid == lastWordID))
                {
                }
                else
                    if (EXCLUDE_FIRST_WORD_FROM_ANALYSIS && (wid == 0))
                    {
                    }
                    else
                    {
                    mapOfListsAppend(result, wordIDToWordLength.get(wid), new Double(1));
                    }
            }
        }
    }
    
    
    private void appendLengthToGazeDurations(HashMap result, List visitedStates)
    {
        HashMap <Integer,Integer> wordIDToWordLength = getWordIDToWordLength();
        List<Integer> fixatedWordIDs = extractValues("fixWid", visitedStates);
        Iterator <Integer> w = wordIDToWordLength.keySet().iterator();
        while (w.hasNext())
        {
            Integer wid = w.next();
            int gaze = -1;
            for (int i = 0; i < visitedStates.size(); i++)
            {
                if (wid.equals(fixatedWordIDs.get(i)))
                {
                    gaze++;
                }
            }
            if (gaze > 0)
            {
                if (EXCLUDE_LAST_WORD_FROM_ANALYSIS && (wid == lastWordID))
                {
                }
                else
                    if (EXCLUDE_FIRST_WORD_FROM_ANALYSIS && (wid == 0))
                    {
                    }
                    else
                    {
                    mapOfListsAppend(result, wordIDToWordLength.get(wid), new Double(gaze));
                    }
            }
        }
    }
    
    private void appendLengthToFixationDurations(HashMap result, List visitedStates)
    {
        HashMap wordIDToWordLength = getWordIDToWordLength();
        List <Integer> fixatedWordIDs = extractValues("fixWid", visitedStates);
        int fixationDuration = 0;
        Integer previous = null;
        for (int i = 0; i < fixatedWordIDs.size(); i++)
        {
            Integer fixatedWordID = fixatedWordIDs.get(i);
            if (previous != null)
            {
                if (fixatedWordID.equals(previous) && !justLanded(visitedStates, i))
                {
                    fixationDuration += MS_PER_TIMESTEP;
                    System.out.println(i + " fix");
                }
                
                if (fixatedWordID.equals(previous) && justLanded(visitedStates, i))
                {
                    System.out.println(i + " REfix wid="+fixatedWordID);
                    if (EXCLUDE_LAST_WORD_FROM_ANALYSIS && (previous == lastWordID))
                    {
                    }
                    else
                        if (EXCLUDE_FIRST_WORD_FROM_ANALYSIS && (previous == 0))
                        {
                        }
                        else
                        {
                        mapOfListsAppend(result, wordIDToWordLength.get(previous), new Double(fixationDuration/MS_PER_TIMESTEP));
                        }
                    fixationDuration = 0;
                }
                if (!fixatedWordID.equals(previous))
                {
                    if (justLanded(visitedStates, i))
                    { System.out.println(i + " land wid="+fixatedWordID); }
                    
                    if (EXCLUDE_LAST_WORD_FROM_ANALYSIS && (previous == lastWordID))
                    {
                    }
                    else
                        if (EXCLUDE_FIRST_WORD_FROM_ANALYSIS && (previous == 0))
                        {
                        }
                        else
                        {
                        mapOfListsAppend(result, wordIDToWordLength.get(previous), new Double(fixationDuration/MS_PER_TIMESTEP));
                        }
                    fixationDuration = 0;
                }
            }
            previous = fixatedWordID;
        }
        if (result != null)
        {
            if (wordIDToWordLength.get(previous) != null)
            {
                if (EXCLUDE_LAST_WORD_FROM_ANALYSIS && (previous== lastWordID))
                {
                }
                else
                    if (EXCLUDE_FIRST_WORD_FROM_ANALYSIS && (previous == 0))
                    {
                    }
                    else
                    {
                    mapOfListsAppend(result, wordIDToWordLength.get(previous), new Double(fixationDuration/MS_PER_TIMESTEP));
                    }
            }
        }
    }
    
        /* We want each individual fixation.  That means all timestep from a landing.
         */
    private void appendFixationDurations(List result, List visitedStates)
    {
        List<Integer> fixatedWordIDs = extractValues("fixWid", visitedStates);
        int fixationDuration = 0;
        
        Integer previous = null;
        for (int i = 0; i < fixatedWordIDs.size(); i++)
        {
            Integer fixatedWordID = fixatedWordIDs.get(i);
            if (previous != null)
            {
                if (fixatedWordID.equals(previous) && !justLanded(visitedStates,i) )
                {
                    fixationDuration += MS_PER_TIMESTEP;
                }
                else
                {
                    if (EXCLUDE_LAST_WORD_FROM_ANALYSIS && (fixatedWordID == lastWordID))
                    {
                    }
                    else
                        if (EXCLUDE_FIRST_WORD_FROM_ANALYSIS && (fixatedWordID == 0))
                        {
                        }
                        else
                        {
                        result.add(new Double(fixationDuration));
                        }
                    fixationDuration = 0;
                }
            }
            previous = fixatedWordID;
        }
    }
    private boolean justLanded(List visitedStates, int current)
    {
        if (current > 0)
        {
            String past = (String) visitedStates.get(current-1);
            String present = (String) visitedStates.get(current);
            if (present.indexOf("sacPrg=false") > -1)
            {
                if (past.indexOf("sacPrg=true") > -1)
                {
                    return true;
                }
            }
        }
        return false;
    }
    private List removeIDTrue(List x)
    {
        ArrayList result = new ArrayList();
        for (int i = 0; i < x.size(); i++)
        {
            if (((String) x.get(i)).indexOf("ID'd?=true") == -1)
            {
                result.add(x.get(i));
            }
            if (((String) x.get(i)).indexOf("identified=true") == -1)
            {
                result.add(x.get(i));
            }
        }
        return result;
        
    }
    
    private void appendLengthToAttWidTimestepCounts(HashMap result, String key, List visitedStates)
    {
        List<Integer> attWID = extractValues("attWid", visitedStates);
        if (attWID.size() == 0) return;
        HashMap<Integer,Integer> wordIDToWordLength = getWordIDToWordLength();
        
        System.out.println("Searching for key " + key);
        int i = 1;          // skip attTim = 0
        while (i < attWID.size())
        {
            int wid = attWID.get(i);
            int previousWid = wid;
            int timesteps = 0;
            while (wid == previousWid)
            {
                System.out.print(".");
                if (((String)visitedStates.get(i)).indexOf(key) > -1) timesteps++;
                i++;
                if (i >= attWID.size()) break;
                previousWid = wid;
                wid = attWID.get(i);
            }
            
            if (EXCLUDE_LAST_WORD_FROM_ANALYSIS && (previousWid == lastWordID))
            {
            }
            else
                if (EXCLUDE_FIRST_WORD_FROM_ANALYSIS && (previousWid == 0))
                {
                }
                else
                {
                mapOfListsAppend(result, wordIDToWordLength.get(previousWid), new Double(timesteps));
                }
        }
    }
    
    private void appendWordLenToAllReFixationPos(HashMap result, List visitedStates)
    {
        List<Integer> eyePositions = extractValues("eyepos", visitedStates);
        List<Integer> fixatedWordID = extractValues("fixWid", visitedStates);
        HashSet<Integer> alreadyFixated = new HashSet();
        HashMap<Integer,Integer> wordIDToWordLength = getWordIDToWordLength();
        Iterator<Integer> w = wordIDToWordLength.keySet().iterator();
        while (w.hasNext())
        {
            Integer wordID = w.next();
            Integer refixationPos = null;
            for (int i = 0; i < fixatedWordID.size(); i++)
            {
                if (fixatedWordID.get(i).equals(wordID) && justLanded(visitedStates, i) && alreadyFixated.contains(wordID))
                {
                    System.out.print("Refixation: " + visitedStates.get(i) + " pos=");
                    refixationPos = eyePositions.get(i);
                    Object lengthOfThisWord = wordIDToWordLength.get(wordID);
                    int relativeRefixationPos = refixationPos - startOfWord(wordID, wordIDToWordLength);
                    
                    if (EXCLUDE_LAST_WORD_FROM_ANALYSIS && wordID == lastWordID)
                    {
                    }
                    else
                        if (EXCLUDE_FIRST_WORD_FROM_ANALYSIS && (wordID== 0))
                        {
                        }
                        else
                        {
                        mapOfListsAppend(result, lengthOfThisWord, relativeRefixationPos);
                        }
                    System.out.println(relativeRefixationPos);
                }
                if (fixatedWordID.get(i).equals(wordID) && justLanded(visitedStates,i))
                {
                    if (EXCLUDE_LAST_WORD_FROM_ANALYSIS && (wordID== lastWordID))
                    {
                    }
                    else
                        if (EXCLUDE_FIRST_WORD_FROM_ANALYSIS && (wordID == 0))
                        {
                        }
                        else
                        {
                        alreadyFixated.add(wordID);
                        }
                }
            }
        }
    }
    
    private void appendWordLenToInitialFixationPos(HashMap result, List visitedStates)
    {
        List<Integer> eyePositions = extractValues("eyepos", visitedStates);
        List<Integer> fixatedWordID = extractValues("fixWid", visitedStates);
        HashMap<Integer,Integer> wordIDToWordLength = getWordIDToWordLength();
        Iterator<Integer> w = wordIDToWordLength.keySet().iterator();
        while (w.hasNext())
        {
            Integer wordID = w.next();
            Integer firstFixationPos = null;
            for (int i = 0; i < fixatedWordID.size(); i++)
            {
                if (fixatedWordID.get(i).equals(wordID))
                {
                    firstFixationPos = eyePositions.get(i);
                    break;      // from for loop; Only interested in first one.
                }
            }
            Object lengthOfThisWord = wordIDToWordLength.get(wordID);
            if (firstFixationPos == null) continue;
            Integer firstRelativeFixationPos = firstFixationPos - startOfWord(wordID, wordIDToWordLength);
            if (EXCLUDE_LAST_WORD_FROM_ANALYSIS && (wordID == lastWordID))
            {
            }
            else
                if (EXCLUDE_FIRST_WORD_FROM_ANALYSIS && (wordID == 0))
                {
                }
                else
                {
                mapOfListsAppend(result, lengthOfThisWord, firstRelativeFixationPos);
                }
        }
    }
    
    private boolean ifOffWordSaccadeRequest(int currentState, List visitedStates)
    {
        List<Integer> eyePosList = extractValues("eyepos", visitedStates);
        List<Integer> sacDstList = extractValues("sacDst", visitedStates);
        List<Integer> fixWIDList = extractValues("fixWid", visitedStates);
        int eyePos = eyePosList.get(currentState);
        int sacDst = sacDstList.get(currentState);
        int fixWID = fixWIDList.get(currentState);
        
        List<Integer> eyePosToWID = getWordIDForAllEyePositions(visitedStates);
        
        int resultFixWID = eyePosToWID.get(eyePos + sacDst);
        if (resultFixWID != fixWID)
        {
            return true;
        }
        System.out.println("NOT OFFWORD: " + visitedStates.get(currentState));
        return false;
    }
    
    private List getWordIDForAllEyePositions(List visitedStates)
    {
        HashMap <Integer,Integer> m = getWordIDToWordLength();
        System.out.println("wordIDToWordLength = " + m);
        int [] wordLengths = new int[m.keySet().size()];
        Iterator <Integer> i = m.keySet().iterator();
        while (i.hasNext())
        {
            Integer key = i.next();
            int wordID = key;
            int length = m.get(key);
            wordLengths[wordID] = length;
        }
        
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int j = 0; j < wordLengths.length; j++)
        {
            for (int k = 0; k < wordLengths[j]; k++)
            {
                result.add(j);
            }
            result.add(j);          // space after the word
        }
        return result;
    }
    
    
    private int startOfWordTEXT(Integer targetWordID, HashMap <Integer,Integer> wordIDToWordLength)
    {
        int result = 0;

        Iterator <Integer> i = wordIDToWordLength.keySet().iterator();
        while (i.hasNext())
        {
            int wordID = i.next();
            int wordLen = wordIDToWordLength.get(wordID);

            if (wordID < targetWordID)
            {
                result = result + wordLen + 1;       // add 1 for space
            }
        }
        return result;
    }
    
    private int startOfWord(Integer targetWordID, HashMap <Integer,Integer> wordIDToWordLength)
    {
        int result = 0;
        Iterator <Integer> i = wordIDToWordLength.keySet().iterator();
        while (i.hasNext())
        {
            int wordID = i.next();
            int wordLen = wordIDToWordLength.get(wordID);
            if (wordID < targetWordID)
            {
                result = result + wordLen + 1;       // add 1 for space
            }
        }
        if (ENABLE_FIXATION_SPACE_BEFORE_WORD)
        {
            return (result-1);
        }
        else
        {
            return result;
        }
    }
    
    private void mapOfListsAppend(HashMap h, Object key, Object newValue)
    {
        List list = (List) h.get(key);
        if (list == null)
        {
            list = new ArrayList<Object>();
            h.put(key, list);
        }
        list.add(newValue);
    }
    
    
    // This is not sufficient because words may not be attended in parallel version.
//    private HashMap <Integer,Integer> getWordIDToWordLength(List visitedStates)
//    {
//        HashMap result = new HashMap();
//        List wordLengths = extractValues("attlen", visitedStates);
//        List wordNumbers = extractValues("attWid", visitedStates);
//        
//        for (int i = 0; i < wordNumbers.size(); i++)
//        {
//            result.put(wordNumbers.get(i), wordLengths.get(i));
//        }
//        return result;
//    }
    
    private HashMap<Integer,Integer> getWordIDToWordLength()
    {
        HashMap<Integer,Integer> result = new HashMap<Integer,Integer>();
        try
        {
            int wordID = 0;
            Scanner s = new Scanner(new File("sentence.txt"));
            while (s.hasNextLine())
            {
                String line = s.nextLine().trim();
                if (line.startsWith("sentence"))
                {
                    String sentence = line;
                    sentence = sentence.replaceAll("sentence", "").trim();
                    sentence = sentence.replaceAll("=", "").trim();
                    sentence = sentence.replaceAll("'", "").trim();
                    StringTokenizer token = new StringTokenizer(sentence, " ", false);
                    while (token.hasMoreTokens())
                    {
                        result.put(wordID, token.nextToken().length());
                        wordID++;
                    }
                    System.out.println("word lengths = " + result);
                    
                }
            }
        }
        catch (Exception e)
        {
            e.printStackTrace();
            throw new RuntimeException("Could not read lengths from sentence.txt");
        }
        return result;
        
    }
    
    
    private Double average(List x)
    {
        double sum = 0;
        for (int i = 0; i < x.size(); i++)
        {
            double value = ((Double) x.get(i)).doubleValue();
            sum = sum + value;
        }
        return new Double(sum / (double)x.size());
    }
    
    protected List<String> loadVisitedStates(BufferedReader inputFile) throws Exception
    {
        ArrayList <String> result = new ArrayList<String>();
        while (inputFile.ready() && !inputFile.readLine().startsWith("POLICY EXTRACTOR ENDED"))
        {
        }
        while (inputFile.ready() && !inputFile.readLine().startsWith("Visited States:"))
        {
        }
        while (inputFile.ready())
        {
            String s = inputFile.readLine();
            if (s.equals("")) break;                   // Needs \n?
            result.add(s);
        }
        return result;
    }
    
    
    public List<Integer> extractValues(String label, List rows)
    {
        try
        {
            return extractValuesActual(label, rows);
        }
        catch (RuntimeException e)
        {
            if (label.equals("sacDst"))
            {
                System.out.println("sacDst failed; Trying sacReqDst");
                return extractValuesActual("sacReqDst", rows);
            }
            if (label.equals("sacReqDst"))
            {
                System.out.println("sacReqDst failed; Trying sacDst");
                return extractValuesActual("sacDst",rows);
            }
            System.out.println("Could not be resolved");
            throw e;
            
        }
    }
    public List<Integer> extractValuesActual(String label, List rows)
    {
        ArrayList<Integer> result = new ArrayList<Integer>();
        Iterator rowIterator = rows.iterator();
        while (rowIterator.hasNext())
        {
            String row = (String) rowIterator.next();
            String target = label + "=";
            int targetStart = row.indexOf(target);
            int resultStart = targetStart + target.length();
            int resultCease = resultStart;
            while (row.charAt(resultCease)=='-' || Character.isDigit(row.charAt(resultCease)))
            {
                resultCease++;
            }
            if (resultCease > resultStart)
            {
                result.add(new Integer(row.substring(resultStart, resultCease)));
            }
            else
            {
                throw new RuntimeException("No value present for key " + target
                        + "\n in row "+row);
            }
        }
        
        if (ENABLE_FIXATION_SPACE_BEFORE_WORD)
        {
            if (label.equalsIgnoreCase("fixWid"))
            {
                // Let's adjust so that the space before the word is considered fixating the word
                // instead of the space after.
                
                List<Integer> eyePositions = extractValues("eyepos", rows);
                HashMap <Integer,Integer> wordIDToWordLength = getWordIDToWordLength();
                for (int i = 0; i < result.size(); i++)
                {
                    int fixWid = result.get(i);
                    int eyePos = eyePositions.get(i);
                    if (fixWid < lastWordID)  //  As long as we're not looking at the last word
                    {
                        System.out.println("Fixated word id = " + Integer.parseInt(""+fixWid));
                        int lengthOfWord = wordIDToWordLength.get(fixWid);
                        if (eyePos == (startOfWordTEXT(fixWid, wordIDToWordLength) + lengthOfWord))
                        {
                            // We really are fixating *next* word.
                            int actualFixWID = fixWid + 1;
                            result.set(i, actualFixWID);
                            // System.out.println("Adjustment: eye position " + eyePos + " is really part of word " + actualFixWID);
                        }
                    }
                    
                }
            }
        }
        return result;
    }
    public static void main(String args[]) throws Exception
    {
        new LogAnalyzer(args[0]);
    }
}
