package org.eyelanguage.rl.analysis;

import java.io.*;
import java.util.*;

public class Extractor
{
         
    int numReported = 0;
    ArrayList <String> globalAlreadyIdentified = new ArrayList<String>();
    ArrayList <String> globalAttending = new ArrayList<String>();  
    int numberOfWordsInSentence = 1;
    
    boolean ADD_PATRYK_FIELDS = true;
    
    public void process(String filename) throws Exception
    {
        BufferedReader inputFile = new BufferedReader(new FileReader(filename));
        String sentence = getSentenceString(inputFile);
        List<Integer> wordLengths = measureWordLengths(sentence);
        System.out.println("WordLengths: " + wordLengths);
        List<Integer> wordStarts = wordLengthsToWordStarts(wordLengths);
        int lines = 0;
        System.err.print("Scanning for agent tests: ");
        while (inputFile.ready() && !inputFile.readLine().startsWith("Testing Agent"))
        { lines++; if (lines % 10000 == 0) System.err.print("."); }
        System.err.println("\nProcessing agent tests.");
        while (inputFile.ready())
        {
            while (inputFile.ready() && !inputFile.readLine().startsWith("POLICY EXTRACTOR STARTED"))
            { }

            globalAlreadyIdentified.clear();
            globalAttending.clear();
            List<String> states = loadVisitedStates(inputFile);
            List<Integer> eyePositions = extractValues("eyepos", states);
            List<Integer> fixatedWordID = convertFixationLocationsToFixatedIDs(eyePositions, wordStarts);
            List<Integer> eccentricity = extractValues("ecc", states);
            List<Integer> saccadeRequests = extractValues("sacReqDst", states);
            List<Integer> relativeLandPositions = computeRelativeLandPositions(eyePositions, fixatedWordID, wordStarts);


            
            if (eyePositions.size() > 2)
            {
                numReported++;
                System.out.print("T,eye,intendSacc,"+attnWindowLabels(wordLengths.size())+"FixWord");

                if (ADD_PATRYK_FIELDS)
                {
                    System.out.println(",FixWordLen,RelativeLanding");
                }
                System.out.println("");
                String rowPreAttention = "";
                String rowPostAttention = "";
                
                for (int i = 0; i < eyePositions.size(); i++)
                {
                    rowPreAttention=
                            ","+eyePositions.get(i)
                            +","+saccadeRequests.get(i)
                            +",";
                    
                    System.out.print(i + rowPreAttention);
                    List<Integer> attendedStates = getAttendedIDColumns(states.get(i));

                    for (int j = 0; j < wordLengths.size(); j++)
                    {
                        if (attendedStates.contains(j)) { System.out.print("1,"); }
                        else { System.out.print("0,"); }
                    }
                    
                    rowPostAttention = "" + fixatedWordID.get(i);
                    System.out.print(rowPostAttention);
                    if (ADD_PATRYK_FIELDS)
                    {
                        String addition = ","+wordLengths.get(fixatedWordID.get(i)) + "," + relativeLandPositions.get(i);
                        System.out.print(addition);
                        rowPostAttention += addition;
                    }
                    System.out.println("");
                }
                // Print empty row where nothing is attended.
                System.out.print(eyePositions.size() + rowPreAttention);
                for (int j = 0; j < wordLengths.size(); j++)
                {
                    System.out.print("0,");
                }
                System.out.print(rowPostAttention);
                System.out.println("");
            }
            else
            {
                System.err.println("Skipped a simulation");
            
            }
            if (numReported == 50) System.exit(0);
//            System.out.println("time,absEyePosition,eccentricityFromTrueAttCenter,fixationID,fixatedWordLength,saccadeRequest,relativeLanding,becameIdentified");
//            for (int i = 0; i < eyePositions.size(); i++)
//            {
//                System.out.println(i
//                        +","+eyePositions.get(i)
//                        +","+eccentricity.get(i)
//                        +","+fixatedWordID.get(i)
//                        +","+wordLengths.get(fixatedWordID.get(i))
//                        +","+saccadeRequests.get(i)
//                        +","+relativeLandPositions.get(i)
//                        +","+getIdentifiedIDs(states.get(i))
//                        );
//            }
        }
    }
    
    public static void main(String args[]) throws Exception
    {
        if (args.length < 1)
        {
            System.out.println("Syntax: java Extractor logfile.txt");
            System.exit(-1);
        }
        
        Extractor e = new Extractor();
        if (args.length == 2)
        {
            if (args[1].equals("erik")) { e.ADD_PATRYK_FIELDS = false; } 
        }
        e.process(args[0]);
    }

    public String attnWindowLabels(int x)
    {
        String result = "";
        for (int i = 0; i < x; i++)
        {
            result += "Att"+(i+1)+",";
        }
        return result;
    }
    
    
    public List<Integer> getAttendedIDColumns(String row)
    {
        ArrayList<Integer> result = new ArrayList<Integer>();
        
        String IDs = getAttIDs(row);
        String Xs = getIdentifiedXs(row);
        StringTokenizer t = new StringTokenizer(IDs, "|");
        while (t.hasMoreTokens())
        { 
            result.add(new Integer(t.nextToken()));   // Are being attended
        }
        
        for (int i = 0; i < Xs.length(); i++)
        {
            if (Xs.charAt(i) == 'x')
            {
                Object toRemove = new Integer(i);
                result.remove(toRemove);
            }
        }
        return result;

    }
    
    public String getNewlyIdentifiedIDs(String row)
    {
        String result = "[";
        
        String IDs = getAttIDs(row);
        String Xs = getIdentifiedXs(row);
        StringTokenizer t = new StringTokenizer(IDs, "|");
        ArrayList<String> list = new ArrayList<String>();
        while (t.hasMoreTokens())
        { 
            list.add(t.nextToken()); 
        }
        
        for (int i = 0; i < Xs.length(); i++)
        {
            if (Xs.charAt(i) == 'x')
            {
                String identifiedID = list.get(i);
                if (!globalAlreadyIdentified.contains(identifiedID))
                {
                    result += list.get(i)+" "; 
                    globalAlreadyIdentified.add(identifiedID);
                }
            }
        }
        return result.trim()+"]";
    }

    
    protected List<Integer> convertFixationLocationsToFixatedIDs(List<Integer> eyePositions, List<Integer> wordStarts)
    {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Integer eyePosition : eyePositions)
        {
            for (int wordID = 0; wordID < wordStarts.size(); wordID++)
            {
                if (wordID == (wordStarts.size()-1))
                {
                    result.add(wordID-1);
                    break;
                }
                if (eyePosition < wordStarts.get(wordID+1))
                {
                    result.add(wordID);
                    break;
                }
            }
        }

        return result;
    }
    
    public String getAttIDs(String row)
    {
        int start = row.indexOf("attIDs=",0) + "attIDs=".length();
        int cease = row.indexOf(",", start)-1;
        return row.substring(start,cease);
    }
    
    public String getIdentifiedXs(String row)
    {
        int start = "identified=".length()+row.indexOf("identified", 0);
        int cease = row.indexOf("]", start);
        return row.substring(start,cease);
    }
    
    protected String getSentenceString(BufferedReader inputFile) throws Exception
    {
        String result = null;
        while (inputFile.ready())
        {
            String line = (inputFile.readLine()).trim();
            if (line.startsWith("sentence"))
            {
                int start = line.indexOf("'")+1;
                int cease = line.indexOf("'", start+1);
                result = line.substring(start, cease);
                return result;
            }
        }
        throw new RuntimeException("\nDid not find sentence string/visual representation");
    }
    
    protected List<String> loadVisitedStates(BufferedReader inputFile) throws Exception
    {
        ArrayList <String> result = new ArrayList<String>();
        while (inputFile.ready() && !inputFile.readLine().startsWith("Visited States:"))
        {
        }
        while (inputFile.ready())
        {
            String s = inputFile.readLine();
            if (s.equals("")) break;                   // Needs \n?
            result.add(s);
        }
        return result;
    }
    
    public List<Integer> wordLengthsToWordStarts(List<Integer> wordLengths)
    {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int start = 0;
        result.add(start);
        for (Integer eachLength : wordLengths)
        {
            start += eachLength+1;
            result.add(start-1);
        }
        return result;
    }
    
    public List<Integer> measureWordLengths(String sentence)
    {
        System.out.println("Sentence is "+ sentence);
        ArrayList<Integer> result = new ArrayList<Integer>();
        StringTokenizer t = new StringTokenizer(sentence, " ");
        while (t.hasMoreTokens())
        {   
            result.add(t.nextToken().length());
        }
        return result;
    }

    protected List<Integer> computeRelativeLandPositions(
            List<Integer> absoluteEyePositions, 
            List<Integer> fixatedWordID, 
            List<Integer> wordStarts)
    {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < absoluteEyePositions.size(); i++)
        {
            int relative = absoluteEyePositions.get(i) - wordStarts.get(fixatedWordID.get(i));
            result.add(relative);
        }
        return result;
    }
    
    public List<Integer> extractValues(String label, List rows)
    {
        ArrayList<Integer> result = new ArrayList<Integer>();
        Iterator rowIterator = rows.iterator();
        while (rowIterator.hasNext())
        {
            String row = (String) rowIterator.next();
            String target = label + "=";
            int targetStart = row.indexOf(target);
            int resultStart = targetStart + target.length();
            int resultCease = resultStart;
            while (row.charAt(resultCease)=='-' || Character.isDigit(row.charAt(resultCease)))
            {
                resultCease++;
            }
            if (resultCease > resultStart)
            {
                result.add(new Integer(row.substring(resultStart, resultCease)));
            }
            else
            {
                throw new RuntimeException("No value present for key " + target
                        + "\n in row "+row);
            }
        }
        
        return result;
    }
    
}
