
package org.eyelanguage.rl.analysis;
import java.util.*;
import java.io.*;
import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * Permits graphical visualization of an adaptive reading agents eye movements for demonstration
 * or presentation purposes.
 */
public class AgentTestVisualizer extends javax.swing.JFrame implements ActionListener, Runnable
{
    
    LogAnalyzer logAnalyzer = new LogAnalyzer();
    
    private JLabel agent;
    private JLabel attentionIndicator;
    private JLabel saccadeTarget;
    
    ArrayList <Integer> fixations = new ArrayList<Integer>();
    ArrayList <Integer> attendeds = new ArrayList<Integer>();
    ArrayList <Integer> targets = new ArrayList<Integer>();
    ArrayList <Integer> wordLengths = new ArrayList<Integer>();
    
    public AgentTestVisualizer()
    {
        agent = new JLabel(new ImageIcon(getClass().getResource("/images/eye1.gif")));
        attentionIndicator = new JLabel(new ImageIcon(getClass().getResource("/images/lillipad.gif")));
        saccadeTarget = new JLabel(new ImageIcon(getClass().getResource("/images/downarrow.gif")));
        resetAgentToBeginning();
        saccadeTarget.setVisible(false);
        getContentPane().add(attentionIndicator);
        getContentPane().add(agent);
        getContentPane().add(saccadeTarget);
        
        
        this.setSize(820,200);
    }
    
    public void resetAgentToBeginning()
    {
        agent.setBounds(0, 40, 40, 40);
        attentionIndicator.setBounds(10, 90, 20, 20); // getAttentionCenterXCoordinate
        saccadeTarget.setBounds(10, 20, 20,20);
        saccadeTarget.setVisible(false);
        agent.setVisible(true);
        currentFixation = 0; nextFixation = 0;
        System.out.println("Agent reset to beginning");
    }

    
    public static javax.swing.Timer timer;
    
    public void run()
    {
        System.out.println("run() has been called");
        resetAgentToBeginning();
        this.getContentPane().setBackground(new Color(1.0f, 1.0f, 1.0f));
        setVisible(true);
        if (timer == null)
        {
            timer = new javax.swing.Timer(10, this);
        }
        timer.start();
        System.out.println("Timer started");
    }
    
    public static void main(String args[]) throws Exception
    {
        String filename = args[0];
        AgentTestVisualizer a = new AgentTestVisualizer();
        a.process(filename);
        
        // animate
    }
    
    protected String getSentenceFromFile(String filename) throws Exception
    {
        String sentence = "blank";
        BufferedReader inputFile = new BufferedReader(new FileReader(filename));
        while (inputFile.ready())
        {
            String line = inputFile.readLine();
            if (line.contains("sentence ="))
            {
                sentence = line;
                System.out.println("1 sentence = '"+sentence+"'");
                sentence = sentence.replaceAll("sentence", "");
                sentence = sentence.replaceAll("=", "");
                System.out.println("2 sentence = '"+sentence+"'");
                sentence = sentence.replaceAll("' ", "");
                System.out.println("3 sentence = '"+sentence+"'");
                sentence = sentence.replaceAll("'", "");
                System.out.println("4 sentence = '"+sentence+"'");
                sentence = sentence.replaceAll("  ", "");
                System.out.println("5 sentence = '"+sentence+"'");
                sentence = sentence.replaceAll("  ", "");
                System.out.println("6 sentence = '"+sentence+"'");
                sentence = sentence.replaceAll("  ", "");
                sentence = sentence.replaceAll("  ", "");
                sentence = sentence.replaceAll("  ", "");
                sentence = sentence.trim();
                sentence = sentence + " ";  // WHY IS THIS NEEDED? WHY IS THE LAST LABEL IN THE WRONG PLACE?
                System.out.println("sentence = '"+sentence+"'");
            }
        }
        if (sentence.equals("blank")) { throw new RuntimeException("Could not find sentence in file '"+filename+"'."); }
        StringTokenizer token = new StringTokenizer(sentence, " ", false);
        while (token.hasMoreTokens())
        {
            this.wordLengths.add(1 + token.nextToken().length());
        }
        System.out.println("word lengths = " + wordLengths);
        return sentence;
    }
 
    boolean animationComplete = false;
    
    protected void process(String filename) throws Exception
    {

        String sentence = getSentenceFromFile("sentence.txt");
        drawWorld(sentence);
        
        
        BufferedReader inputFile = new BufferedReader(new FileReader(filename));
        while (inputFile.ready())
        {
            
            java.util.List<String> visitedStates = logAnalyzer.loadVisitedStates(inputFile);
            java.util.List<Integer> eyePositions = logAnalyzer.extractValues("eyepos", visitedStates);
            java.util.List<Integer> attendedWord = logAnalyzer.extractValues("attWid", visitedStates);
            java.util.List<Integer> saccadeTargets = null;
            fixations.clear();
            attendeds.clear();
            targets.clear();
            try
            {
                saccadeTargets = logAnalyzer.extractValues("sacReqDst", visitedStates);
            }
            catch (Exception e)
            {
                System.out.println("sacReqDst could not be retrieved, trying sacDst");
                saccadeTargets = logAnalyzer.extractValues("sacDst", visitedStates);
            }

            Iterator<Integer> i = eyePositions.iterator();
            Iterator<Integer> j = attendedWord.iterator();
            Iterator<Integer> k = saccadeTargets.iterator();

            while (i.hasNext())
            {
                fixations.add(i.next());
                attendeds.add(j.next());
                targets.add(k.next());
            }
            animationComplete = false;

            startedAnimating = false;
            stillAnimating = false;
            EventQueue.invokeAndWait(this);  // calls run() eventually, thru different thread.
//            EventQueue.invokeLater(this);  // calls run() eventually, thru different thread.
            while (!animationComplete)
            {
                try { Thread.sleep(1000L); } catch (InterruptedException ie) {ie.printStackTrace();} 
            }
        }
        inputFile.close();

        
    }
    
    
    int currentFixation = 0;
    int nextFixation = 0;
    int currentAttention = 0;
    int nextAttention = 0;
    int distance = 1;
    
    int currentTarget = 0;
    int nextTarget = 0;
    
    int singleBlockWidth = 20;
    int incrementWidth = 10;
    int counter = 0;
    boolean goingUp, goingDown, startedAnimating, stillAnimating;
    
    Iterator <Integer> fixation;
    Iterator <Integer> attention;
    Iterator <Integer> target;
    
    public void actionPerformed(ActionEvent e)
    {
        currentTarget = 0;
        
        if (!startedAnimating)
        {
            fixation = fixations.iterator();
            attention = attendeds.iterator();
            target = targets.iterator();
            
            if (!fixation.hasNext())
            {
                System.out.println("No fixations were found.\n");
                System.exit(-1);
            }
            nextFixation = fixation.next();
            nextAttention = attention.next();
            nextTarget = target.next();
            
            System.out.println("next fixation: "+nextFixation+" next attention = " + nextAttention + " next target = " + nextTarget);
            distance = nextFixation - currentFixation;
            startedAnimating = true;
            goingUp = true;
            stillAnimating = true;
        }
        
        
        if (stillAnimating)
        {
            int dY=0, dX=0;
            if (goingUp)
            {
                if (counter == 10)
                {
                    goingDown = true; goingUp = false; counter = 0;
                }
                dY = -1;
                dX = distance * singleBlockWidth / (incrementWidth * 2);
            }
            else
            {
                if (goingDown)
                {
                    dY = +1;
                    dX = distance * singleBlockWidth / (incrementWidth * 2);
                    if (counter == 10)
                    {
                        goingUp = true;  goingDown = false; counter = 0;
                        
                        if (fixation.hasNext())
                        {

                            
                            currentFixation = nextFixation;
                            nextFixation = fixation.next();
                            currentAttention = nextAttention;
                            nextAttention = attention.next();
                            currentTarget = nextTarget;
                            nextTarget = target.next();
                            System.out.println("curFix " + currentFixation + " next fixation: "+nextFixation+ " curAtt " + currentAttention + " next attention = " + nextAttention + " current target = "+ currentTarget+"next target = " + nextTarget);
                            
                            distance = nextFixation - currentFixation;
                            
                            
                            // -------------------------------------------------------------------
                            // MOVE SACCADE TARGET MARKER
                            // -------------------------------------------------------------------
                            if (currentTarget != nextTarget)
                            {
                                    if (nextTarget == 0)
                                    {
                                        if (currentTarget == 0)
                                        saccadeTarget.setVisible(false);
                                    }                            
                                    else
                                    {
                                        saccadeTarget.setVisible(true);
                                        int difference = nextTarget - currentTarget;
                                        int eyeCenter = agent.getX() + Math.round((float)agent.getWidth() / 2.0f);
                                        Rectangle r = saccadeTarget.getBounds();
                                        r.setBounds(eyeCenter+(20 * difference)-8, (int) r.getY(), (int) r.getWidth(), (int) r.getHeight());
                                        saccadeTarget.setBounds(r);
                                    }
                            }
                            if ((currentTarget == 0) && (nextTarget==0))
                            {
                                saccadeTarget.setVisible(false);
                            }


                        }
                        else
                        {
                            System.out.println("Animation Complete");
                            stillAnimating = false;
                            animationComplete = true;
                            timer.stop();
                        }
                    }
                }
            }
            
            counter++;
            
            Rectangle r = agent.getBounds();
            // System.out.println("agent X = " + r.getX() + " agent Y = " + r.getY());
            r.setBounds((int) r.getX()+dX, (int) r.getY()+dY, (int) r.getWidth(), (int) r.getHeight());
            agent.setBounds(r);
            
            attentionIndicator.setBounds(10 + getAttentionCenterXCoordinate(currentAttention), 90, 20, 20);
            
            
            repaint();
        }

    }
    
    
    
    public void drawWorld(String sentenceString)
    {
        int numDrawn = 0;
        for (int i = 0; i < sentenceString.length(); i++)
        {
            JLabel jLabel1;
            
            if (sentenceString.charAt(i) == ' ')
            {
                // jLabel1 = new JLabel(new ImageIcon(getClass().getResource("/images/lillipad.gif")));
                jLabel1 = new JLabel();
            }
            else
            {
                jLabel1 = new JLabel(new ImageIcon(getClass().getResource("/images/water.gif")));
            }
            getContentPane().add(jLabel1);
            jLabel1.setBounds(10 + (20 * numDrawn), 70, 20, 20);
            //System.out.println("At "+ 20*numDrawn);
            numDrawn++;
        }
    }
    
    private int getAttentionCenterXCoordinate(int wordID)
    {
        int sum = 0;
        for (int i = 0; i < wordID; i++)
        {
            sum = sum + wordLengths.get(i);                 // move to beginning of word i.
        }
        if (wordID > 0)
        {
            sum = sum + wordLengths.get(wordID)/2 - 1;      // adjust to center of word.
        }
        return 20 * sum;
    }
    
}
