package net.pakl.rl.maze;

import java.util.*;
import net.pakl.rl.*;

/**
  * The Toolbox is a collection of miscellanious functions to
  * help with initialization of various objects at the beginning
  * of a simulation.
  */ 
public class Toolbox
{
    public boolean allowDiagonals = false;
    public ActionSet makeSimpleMazePolicy(MazeWorld mWorld)
    {
        ActionSet p = new ActionSet();
        Iterator i = mWorld.stateIterator();
        while (i.hasNext())
        {
            State2D s = (State2D) i.next();
            
            State2D newState = null;
            Action2D action = null;
            
            if (mWorld.isTerminalState(s)) 
            {
                p.allowAction(s, new Action2D(0,0));
            }
            else
            {
                action = new Action2D(+1, 0);
                newState = new State2D(s.getX() + action.getDeltaX(), s.getY() + action.getDeltaY());
                if (mWorld.getStateList().contains(newState) && !mWorld.isObstacle(newState)) 
                    p.allowAction(s, action);
    
                action = new Action2D(-1, 0);
                newState = new State2D(s.getX() + action.getDeltaX(), s.getY() + action.getDeltaY());
                if (mWorld.getStateList().contains(newState) && !mWorld.isObstacle(newState))
                    p.allowAction(s, action);
    
                action = new Action2D(0, +1);
                newState = new State2D(s.getX() + action.getDeltaX(), s.getY() + action.getDeltaY());
                if (mWorld.getStateList().contains(newState) && !mWorld.isObstacle(newState)) 
                    p.allowAction(s, action);
    
                action = new Action2D(0, -1);
                newState = new State2D(s.getX() + action.getDeltaX(), s.getY() + action.getDeltaY());
                if (mWorld.getStateList().contains(newState) && !mWorld.isObstacle(newState)) 
                    p.allowAction(s, action);
                    
                if (allowDiagonals)
                {
                
                        action = new Action2D(-1, -1);
                        newState = new State2D(s.getX() + action.getDeltaX(), s.getY() + action.getDeltaY());
                        if (mWorld.getStateList().contains(newState) && !mWorld.isObstacle(newState)) 
                            p.allowAction(s, action);
                        action = new Action2D(+1, -1);
                        newState = new State2D(s.getX() + action.getDeltaX(), s.getY() + action.getDeltaY());
                        if (mWorld.getStateList().contains(newState) && !mWorld.isObstacle(newState)) 
                            p.allowAction(s, action);
                        action = new Action2D(+1, +1);
                        newState = new State2D(s.getX() + action.getDeltaX(), s.getY() + action.getDeltaY());
                        if (mWorld.getStateList().contains(newState) && !mWorld.isObstacle(newState)) 
                            p.allowAction(s, action);
                        action = new Action2D(-1, +1);
                        newState = new State2D(s.getX() + action.getDeltaX(), s.getY() + action.getDeltaY());
                        if (mWorld.getStateList().contains(newState) && !mWorld.isObstacle(newState)) 
                            p.allowAction(s, action);
                }
                
            }                        
        }
        System.err.println(p.toText());
        return p;
    }
}
