package net.pakl.rl.maze;


import net.pakl.rl.*;

/**
 * This class represents a state which
 * corresponds to a position in a two-dimensional {@link World}
 */
public class State2D extends State implements HasVectorRepresentation
{
    public int MAX_X = 20;
    public int MAX_Y = 20;
    private int X;
    private int Y;
    
    public State2D(int X, int Y)
    {
        this.X = X;
        this.Y = Y;
    }
    public State2D(String xCommaY)
    {
        java.util.StringTokenizer t = new java.util.StringTokenizer(xCommaY, ",", false);
        this.X = new Integer(t.nextToken()).intValue();
        this.Y = new Integer(t.nextToken()).intValue();
    }
    
    public int [] handCraftedRepresentation()
    {
        return binaryRepresentation();
    }
    
    
    public State2D()
    {
    }
    
    public static double scaleBy = 1.0;
    public double [] doubleRepresentation()
    {
        double [] result = new double[2];
        result[0] = (double) (X) / scaleBy;
        result[1] = (double) (Y) / scaleBy;
        return result;
    }
    public int [] integerRepresentation()
    {
        int [] result = new int[2];
        result[0] = X;
        result[1] = Y;
        return result;
    }
    
    public int [] binaryRepresentation()
    {
        throw new RuntimeException("Not implemented.");
    }
    
    public int [] complementRepresentation()
    {
        int [] result = binaryRepresentation();
        for (int i = 0; i < result.length; i++)
        {
            if (result[i] == 0)
            { result[i] = -1; }
        }
        return result;
    }
    
    public int getX()
    {
        return X;
    }
    
    public int getY()
    {
        return Y;
    }
    
    public void setX(int X)
    {
        this.X = X;
    }
    
    public void setY(int Y)
    {
        this.Y = Y;
    }
    
    
    public String toString()
    {
        return "[state "+getX()+","+getY()+"]";
    }
    
    public int hashCode()
    {
        return 1000 * getX() + getY();
    }
    
    public boolean equals(Object otherObject)
    {
        if (otherObject instanceof State2D)
        {
            State2D otherState = (State2D) otherObject;
            if (otherState.getX() == this.getX())
            {
                if (otherState.getY() == this.getY())
                {
                    return true;
                }
            }
        }
        return false;
    }
}
