package net.pakl.rl.maze;

import java.util.*;
import net.pakl.rl.*;

/** 
  * This is a model of a 2D gridworld and supports 
  * all the functions specified in the {@link World} interface. 
  * Requires {@link #setLength(int)} and
  * {@link #setLillipadFrequency(double)} to be called before
  * {@link #build()} is called. 
  */
public class MazeWorld implements World
{
    java.util.Random randomNumberGenerator;

	ArrayList states = new ArrayList();
	HashSet terminalStates = new HashSet();
    ArrayList obstacles = new ArrayList();
    
    private int lengthX;
    private int lengthY;
    private double pObstacle;
    boolean isBuilt = false;
    
    private String name = "namelessWorld";


    public int getNumberOfStates()
    {
        return states.size();
    }
    
    public int getSizeX()
    {
        return lengthX;
    }
    public int getSizeY()
    {
        return lengthY;
    }
        
	/**
	  * Pretty-printing -- Returns a text representation of the 
          * world, attempting to justify text for display. 
	  */
	public String toText()
	{
        StringBuffer result=new StringBuffer("");
        for (int i = 0; i < lengthX; i++)
        {
            for (int j = 0; j < lengthY; j++)
            {
                if (teleporters.containsKey(new State2D(j,i)))
                {
                    result.append("T ");
                }
                else
                if (teleporters.containsValue(new State2D(j,i)))
                {
                    result.append("! ");
                }
                else
                if (isObstacle(new State2D(j,i))) 
                { 
                    result.append("X ");
                } 
                else result.append("_ "); 
            }
            result.append("\n");
        }
        return result.toString();
    }

	public MazeWorld(String newName, long randomSeed)
	{
            this.name = newName;
            this.randomNumberGenerator = new java.util.Random(randomSeed);
            System.err.println("! World " + getName() + " has been created.");
	}
	public MazeWorld(String newName)
	{
            this.name = newName;
            this.randomNumberGenerator = new java.util.Random(1111);
            System.err.println("! World " + getName() + " has been created.");
	}

	public String getName()
	{
		return this.name;
	}

    public boolean getIsBuilt()
	{
		return isBuilt;
	}

    HashMap teleporters = new HashMap();
    
    public void addTeleporter(State location, State destination)
    {
        removeAnyObstacle((State2D) location);
        removeAnyObstacle((State2D) destination);
        teleporters.put(location, destination);
    }
    
	/**
	  * This critical method returns the new state given an action
	  * from an old state, and in this case, simply adds state to
	  * position to simulate movement.  <B>Note that there are no boundary
	  * conditions set up here.</B>
	  */
	public State getNewState(State oldState, Action action)
	{
            State2D old = (State2D) oldState;
            Action2D action2D = (Action2D) action;
            
            State2D newState = new State2D(old.getX() + action2D.getDeltaX(), old.getY() + action2D.getDeltaY());
            if (teleporters.keySet().contains(newState))
            {
                newState = (State2D) teleporters.get(newState);
            }
            if (teleporters.keySet().contains(oldState))
            {
                newState = (State2D) teleporters.get(oldState);
            }
            
            if (!states.contains(newState))
            {
                throw new RuntimeException("State transititioned to by Policy, " + action2D +" -> "+newState+", does not exist");
            }
            return newState;
	}

	public int distance(State state1, State state2)
	{
            State2D a = (State2D) state1;
            State2D b = (State2D) state2;
            return (b.getX() - a.getX()) + (b.getY() - a.getY());
        }


	/** Allows you to specify the dimension of the FrogWorld and 
	  * should be called before the call to build() 
	  * (Note: in the future, an exception will be thrown 
	  * if this function was not called first)
	  */
	public void setLengths(int x, int y)
	{
            this.lengthX = x;
            this.lengthY = y;
            if (isBuilt) build();
	}


	public boolean isTerminalState(State state)
	{
            if (terminalStates.contains(state))
            {
                    return true;
            }
            return false;
	}

	public void makeIntoTerminalState(State2D state)
	{
            if (!terminalStates.contains(state))
            {
                    terminalStates.add(state);
            }
	}
        
        
        public void makeIntoObstacle(State2D state)
        {
            obstacles.add(state);
        }
        
        public void removeAnyObstacle(State2D state)
        {
            if (isObstacle(state))
            {
                obstacles.remove(obstacles.indexOf(state));
            }
        }

        
        public boolean isObstacle(State2D state)
        {
            if (obstacles.contains(state)) return true;
            return false;
        }
        
        public HashSet getTerminalStates()
        {
            return terminalStates;
        }

        public void build()
    	{
            this.isBuilt = true;
            for (int x = 0; x < getSizeX(); x++)
            {
                for (int y = 0; y < getSizeY(); y++)
                {
                    State2D s = new State2D(x,y);
                    states.add(s);
                    if (Math.random() < pObstacle)
                    {
                     makeIntoObstacle(s);   
                    }
                }
            }
            System.err.println(states.size() + " build complete\n");
	}

        public Iterator stateIterator() { return states.iterator(); }
        public List getStateList() { return states; }
        public State getStartingState()
        {
            return new State2D(0, 0);
        }
        
        /** Getter for property pObstacle.
         * @return Value of property pObstacle.
         *
         */
        public double getPObstacle()
        {
            return pObstacle;
        }
        
        /** Setter for property pObstacle.
         * @param pObstacle New value of property pObstacle.
         *
         */
        public void setPObstacle(double pObstacle)
        {
            this.pObstacle = pObstacle;
        }
        
    
    public State getRandomState()
    {
        int i = (int) (randomNumberGenerator.nextDouble() * (double) (getStateList().size()));
        return (State) getStateList().get(i);
    }
        
}
