/*
 * MazeWizardFrame.java
 *
 * Created on July 8, 2007, 4:08 PM
 */

package net.pakl.rl.maze;
import java.util.*;

/**
 *
 * @author  patryk
 */
public class MazeWizardFrame extends javax.swing.JFrame implements tools.IsAMonitor
{
    
    /** Creates new form MazeWizardFrame */
    public MazeWizardFrame()
    {
        initComponents();
        if (wizard.getSelectedIndex() == 0)
        {
            previousButton.setEnabled(false);
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents()
    {
        wizard = new javax.swing.JTabbedPane();
        PanelInstructions = new javax.swing.JPanel();
        jLabel18 = new javax.swing.JLabel();
        jLabel27 = new javax.swing.JLabel();
        PanelDimensions = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        mazeX = new javax.swing.JTextField();
        mazeY = new javax.swing.JTextField();
        jLabel8 = new javax.swing.JLabel();
        jLabel28 = new javax.swing.JLabel();
        PanelTerrain = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        jLabel11 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        obstacles = new javax.swing.JTextArea();
        jScrollPane2 = new javax.swing.JScrollPane();
        teleporters = new javax.swing.JTextArea();
        jLabel13 = new javax.swing.JLabel();
        jLabel21 = new javax.swing.JLabel();
        pObstacle = new javax.swing.JTextField();
        jLabel22 = new javax.swing.JLabel();
        jLabel23 = new javax.swing.JLabel();
        jLabel24 = new javax.swing.JLabel();
        jScrollPane4 = new javax.swing.JScrollPane();
        destinations = new javax.swing.JTextArea();
        jLabel25 = new javax.swing.JLabel();
        jLabel26 = new javax.swing.JLabel();
        jLabel29 = new javax.swing.JLabel();
        PanelAgent = new javax.swing.JPanel();
        jLabel9 = new javax.swing.JLabel();
        jLabel10 = new javax.swing.JLabel();
        discountFactor = new javax.swing.JTextField();
        epsilon = new javax.swing.JTextField();
        jLabel14 = new javax.swing.JLabel();
        jLabel19 = new javax.swing.JLabel();
        jLabel20 = new javax.swing.JLabel();
        numIterations = new javax.swing.JTextField();
        valueFunctionType = new javax.swing.JComboBox();
        jLabel30 = new javax.swing.JLabel();
        PanelNeuralNetwork = new javax.swing.JPanel();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        synapticModificationRate = new javax.swing.JTextField();
        numHiddenUnits = new javax.swing.JTextField();
        residualWeighting = new javax.swing.JTextField();
        jLabel15 = new javax.swing.JLabel();
        jLabel31 = new javax.swing.JLabel();
        jLabel34 = new javax.swing.JLabel();
        maxMin = new javax.swing.JTextField();
        PanelSaveLoad = new javax.swing.JPanel();
        filename = new javax.swing.JTextField();
        jButton2 = new javax.swing.JButton();
        jButton3 = new javax.swing.JButton();
        jLabel12 = new javax.swing.JLabel();
        jLabel32 = new javax.swing.JLabel();
        PanelRunFile = new javax.swing.JPanel();
        runButton = new javax.swing.JButton();
        progressBar = new javax.swing.JProgressBar();
        jLabel4 = new javax.swing.JLabel();
        jScrollPane3 = new javax.swing.JScrollPane();
        generatedFile = new javax.swing.JTextArea();
        generateButton = new javax.swing.JButton();
        jLabel33 = new javax.swing.JLabel();
        jLabel16 = new javax.swing.JLabel();
        jLabel17 = new javax.swing.JLabel();
        nextButton = new javax.swing.JButton();
        previousButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        jLabel18.setText("<html>This program lets you generate a simulation properties for the Reinforcement Learning Java framework.  Once you have the generated file you can run a simulation using it.</html>");

        jLabel27.setFont(new java.awt.Font("Lucida Grande", 0, 18));
        jLabel27.setText("Start");

        org.jdesktop.layout.GroupLayout PanelInstructionsLayout = new org.jdesktop.layout.GroupLayout(PanelInstructions);
        PanelInstructions.setLayout(PanelInstructionsLayout);
        PanelInstructionsLayout.setHorizontalGroup(
            PanelInstructionsLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, PanelInstructionsLayout.createSequentialGroup()
                .addContainerGap(23, Short.MAX_VALUE)
                .add(jLabel27)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel18, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 477, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(124, 124, 124))
        );
        PanelInstructionsLayout.setVerticalGroup(
            PanelInstructionsLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(PanelInstructionsLayout.createSequentialGroup()
                .add(29, 29, 29)
                .add(PanelInstructionsLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel27)
                    .add(jLabel18, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 261, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(147, Short.MAX_VALUE))
        );
        wizard.addTab("Start", PanelInstructions);

        jLabel1.setText("X Width");

        jLabel2.setText("Y Height");

        mazeX.setText("5");

        mazeY.setText("5");
        mazeY.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                mazeYActionPerformed(evt);
            }
        });

        jLabel8.setText("<html>Please enter the  dimensions of the maze that the agent will learn to navigate</html>");

        jLabel28.setFont(new java.awt.Font("Lucida Grande", 0, 18));
        jLabel28.setText("Dimensions");

        org.jdesktop.layout.GroupLayout PanelDimensionsLayout = new org.jdesktop.layout.GroupLayout(PanelDimensions);
        PanelDimensions.setLayout(PanelDimensionsLayout);
        PanelDimensionsLayout.setHorizontalGroup(
            PanelDimensionsLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(PanelDimensionsLayout.createSequentialGroup()
                .add(PanelDimensionsLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(PanelDimensionsLayout.createSequentialGroup()
                        .add(79, 79, 79)
                        .add(PanelDimensionsLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jLabel1)
                            .add(jLabel2))
                        .add(21, 21, 21)
                        .add(PanelDimensionsLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                            .add(mazeY)
                            .add(mazeX, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 70, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                    .add(PanelDimensionsLayout.createSequentialGroup()
                        .add(28, 28, 28)
                        .add(PanelDimensionsLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jLabel28)
                            .add(jLabel8, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 451, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))))
                .addContainerGap(194, Short.MAX_VALUE))
        );
        PanelDimensionsLayout.setVerticalGroup(
            PanelDimensionsLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(PanelDimensionsLayout.createSequentialGroup()
                .add(jLabel28)
                .add(31, 31, 31)
                .add(jLabel8, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 40, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(24, 24, 24)
                .add(PanelDimensionsLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(PanelDimensionsLayout.createSequentialGroup()
                        .add(mazeX, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(PanelDimensionsLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(mazeY, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(jLabel2)))
                    .add(jLabel1))
                .addContainerGap(268, Short.MAX_VALUE))
        );
        wizard.addTab("Dimensions", PanelDimensions);

        jLabel3.setText("Obstacles");

        jLabel11.setText("Teleporters");

        obstacles.setColumns(20);
        obstacles.setRows(5);
        jScrollPane1.setViewportView(obstacles);

        teleporters.setColumns(20);
        teleporters.setRows(5);
        jScrollPane2.setViewportView(teleporters);

        jLabel13.setText("<html>You may optionally specify obstacles and teleporters to add nonlinearities to the maze.</html>");

        jLabel21.setText("P(Obstacle)");

        pObstacle.setText("0");

        jLabel22.setText("e.g.,  5,5 6,6 7,7");

        jLabel23.setText("e.g., 0.2");

        jLabel24.setText("e.g., 2,2 2,3");

        destinations.setColumns(20);
        destinations.setRows(5);
        jScrollPane4.setViewportView(destinations);

        jLabel25.setText("Destinations");

        jLabel26.setText("e.g., 8,8 8,9");

        jLabel29.setFont(new java.awt.Font("Lucida Grande", 0, 18));
        jLabel29.setText("Terrain");

        org.jdesktop.layout.GroupLayout PanelTerrainLayout = new org.jdesktop.layout.GroupLayout(PanelTerrain);
        PanelTerrain.setLayout(PanelTerrainLayout);
        PanelTerrainLayout.setHorizontalGroup(
            PanelTerrainLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(PanelTerrainLayout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel13, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 422, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(231, Short.MAX_VALUE))
            .add(PanelTerrainLayout.createSequentialGroup()
                .add(49, 49, 49)
                .add(PanelTerrainLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel25)
                    .add(jLabel11)
                    .add(jLabel21)
                    .add(jLabel3))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 22, Short.MAX_VALUE)
                .add(PanelTerrainLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jScrollPane4, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jScrollPane2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 256, Short.MAX_VALUE)
                    .add(pObstacle, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 256, Short.MAX_VALUE)
                    .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 256, Short.MAX_VALUE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(PanelTerrainLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel22)
                    .add(jLabel23)
                    .add(jLabel24)
                    .add(jLabel26))
                .add(153, 153, 153))
            .add(PanelTerrainLayout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel29)
                .addContainerGap(592, Short.MAX_VALUE))
        );
        PanelTerrainLayout.setVerticalGroup(
            PanelTerrainLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(PanelTerrainLayout.createSequentialGroup()
                .add(jLabel29)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(PanelTerrainLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(PanelTerrainLayout.createSequentialGroup()
                        .add(PanelTerrainLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                            .add(PanelTerrainLayout.createSequentialGroup()
                                .add(jLabel13, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 52, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .add(PanelTerrainLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                    .add(PanelTerrainLayout.createSequentialGroup()
                                        .add(20, 20, 20)
                                        .add(PanelTerrainLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                            .add(jLabel3)
                                            .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                        .add(PanelTerrainLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                                            .add(jLabel21)
                                            .add(jLabel23)
                                            .add(pObstacle, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                                    .add(PanelTerrainLayout.createSequentialGroup()
                                        .add(28, 28, 28)
                                        .add(jLabel22)))
                                .add(93, 93, 93))
                            .add(PanelTerrainLayout.createSequentialGroup()
                                .add(jLabel24)
                                .add(68, 68, 68)))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 44, Short.MAX_VALUE)
                        .add(PanelTerrainLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jLabel26)
                            .add(jLabel25)
                            .add(jScrollPane4, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, PanelTerrainLayout.createSequentialGroup()
                        .add(PanelTerrainLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jLabel11)
                            .add(jScrollPane2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 84, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .add(92, 92, 92))))
        );
        wizard.addTab("Terrain", PanelTerrain);

        jLabel9.setText("Discount Factor");

        jLabel10.setText("Epsilon (amount of updating)");

        discountFactor.setText("1.0");

        epsilon.setText("0.1");

        jLabel14.setText("<html>Set agent properties.  Discount Factor reflects how to weight future rewards compared to immediate ones.  Epsilon specifies how much of the new learned value should replace the old learned value for each state.</html>");

        jLabel19.setText("Number of Iterations");

        jLabel20.setText("Value Function Type");

        numIterations.setText("1000");

        valueFunctionType.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "LookupTable", "BairdPerceptronResidualAlgorithm" }));
        valueFunctionType.setSelectedIndex(0);

        jLabel30.setFont(new java.awt.Font("Lucida Grande", 0, 18));
        jLabel30.setText("Agent");

        org.jdesktop.layout.GroupLayout PanelAgentLayout = new org.jdesktop.layout.GroupLayout(PanelAgent);
        PanelAgent.setLayout(PanelAgentLayout);
        PanelAgentLayout.setHorizontalGroup(
            PanelAgentLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(PanelAgentLayout.createSequentialGroup()
                .add(61, 61, 61)
                .add(PanelAgentLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel19)
                    .add(jLabel20)
                    .add(jLabel9)
                    .add(jLabel10))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(PanelAgentLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(PanelAgentLayout.createSequentialGroup()
                        .add(PanelAgentLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(valueFunctionType, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 191, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(discountFactor, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 399, Short.MAX_VALUE)
                            .add(epsilon, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 399, Short.MAX_VALUE))
                        .add(20, 20, 20))
                    .add(PanelAgentLayout.createSequentialGroup()
                        .add(numIterations, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 399, Short.MAX_VALUE)
                        .addContainerGap())))
            .add(PanelAgentLayout.createSequentialGroup()
                .add(30, 30, 30)
                .add(PanelAgentLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel30)
                    .add(jLabel14, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 540, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(103, Short.MAX_VALUE))
        );
        PanelAgentLayout.setVerticalGroup(
            PanelAgentLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, PanelAgentLayout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel30)
                .add(35, 35, 35)
                .add(jLabel14, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 53, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 125, Short.MAX_VALUE)
                .add(PanelAgentLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel19)
                    .add(numIterations, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(PanelAgentLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(jLabel20)
                    .add(valueFunctionType, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(17, 17, 17)
                .add(PanelAgentLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel9)
                    .add(discountFactor, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(11, 11, 11)
                .add(PanelAgentLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(jLabel10)
                    .add(epsilon, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(57, 57, 57))
        );
        wizard.addTab("Agent", PanelAgent);

        jLabel5.setText("Number of Hidden Units");

        jLabel6.setText("Synaptic Modification Rate");

        jLabel7.setText("Residual Gradient");

        synapticModificationRate.setText("0.1");

        numHiddenUnits.setText("10");
        numHiddenUnits.setMaximumSize(new java.awt.Dimension(10, 10));
        numHiddenUnits.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                numHiddenUnitsActionPerformed(evt);
            }
        });

        residualWeighting.setText("0.8");

        jLabel15.setText("<HTML>If the agent's Value Function is represented as a neural network, here you can specify properties of the neural network.</HTML>");

        jLabel31.setFont(new java.awt.Font("Lucida Grande", 0, 18));
        jLabel31.setText("Neural Network");

        jLabel34.setText("maxMin");

        maxMin.setText("100");

        org.jdesktop.layout.GroupLayout PanelNeuralNetworkLayout = new org.jdesktop.layout.GroupLayout(PanelNeuralNetwork);
        PanelNeuralNetwork.setLayout(PanelNeuralNetworkLayout);
        PanelNeuralNetworkLayout.setHorizontalGroup(
            PanelNeuralNetworkLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(PanelNeuralNetworkLayout.createSequentialGroup()
                .addContainerGap()
                .add(PanelNeuralNetworkLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel15, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 459, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel31)
                    .add(PanelNeuralNetworkLayout.createSequentialGroup()
                        .add(PanelNeuralNetworkLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jLabel5)
                            .add(jLabel7)
                            .add(jLabel6)
                            .add(jLabel34))
                        .add(20, 20, 20)
                        .add(PanelNeuralNetworkLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(numHiddenUnits, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 160, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(synapticModificationRate, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 172, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(PanelNeuralNetworkLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                                .add(org.jdesktop.layout.GroupLayout.LEADING, maxMin)
                                .add(org.jdesktop.layout.GroupLayout.LEADING, residualWeighting, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 169, Short.MAX_VALUE)))))
                .addContainerGap(194, Short.MAX_VALUE))
        );
        PanelNeuralNetworkLayout.setVerticalGroup(
            PanelNeuralNetworkLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(PanelNeuralNetworkLayout.createSequentialGroup()
                .add(9, 9, 9)
                .add(jLabel31)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel15, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 53, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(28, 28, 28)
                .add(PanelNeuralNetworkLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel5)
                    .add(numHiddenUnits, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 22, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(8, 8, 8)
                .add(PanelNeuralNetworkLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel6)
                    .add(synapticModificationRate, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(PanelNeuralNetworkLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel7)
                    .add(residualWeighting, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 22, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(34, 34, 34)
                .add(PanelNeuralNetworkLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel34)
                    .add(maxMin, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(179, Short.MAX_VALUE))
        );
        wizard.addTab("Neural Network", PanelNeuralNetwork);

        jButton2.setText("Save");

        jButton3.setText("Load");

        jLabel12.setText("<html>If you would like to save your current settings (or load them)<br>enter a file name and click the appropriate button.</html>");
        jLabel12.getAccessibleContext().setAccessibleName("name1");

        jLabel32.setFont(new java.awt.Font("Lucida Grande", 0, 18));
        jLabel32.setText("Save / Load Settings");

        org.jdesktop.layout.GroupLayout PanelSaveLoadLayout = new org.jdesktop.layout.GroupLayout(PanelSaveLoad);
        PanelSaveLoad.setLayout(PanelSaveLoadLayout);
        PanelSaveLoadLayout.setHorizontalGroup(
            PanelSaveLoadLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(PanelSaveLoadLayout.createSequentialGroup()
                .add(59, 59, 59)
                .add(PanelSaveLoadLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel32)
                    .add(jLabel12)
                    .add(PanelSaveLoadLayout.createSequentialGroup()
                        .add(filename, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 195, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .add(22, 22, 22)
                        .add(jButton2)
                        .add(24, 24, 24)
                        .add(jButton3)))
                .addContainerGap(223, Short.MAX_VALUE))
        );
        PanelSaveLoadLayout.setVerticalGroup(
            PanelSaveLoadLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(PanelSaveLoadLayout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel32)
                .add(19, 19, 19)
                .add(jLabel12)
                .add(40, 40, 40)
                .add(PanelSaveLoadLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jButton2)
                    .add(jButton3)
                    .add(filename, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(281, Short.MAX_VALUE))
        );
        wizard.addTab("Save/Load Settings", PanelSaveLoad);

        runButton.setText("Run Simulation");
        runButton.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                runButtonActionPerformed(evt);
            }
        });

        jLabel4.setText("Simulation Progress:");

        generatedFile.setColumns(20);
        generatedFile.setRows(5);
        jScrollPane3.setViewportView(generatedFile);

        generateButton.setText("Generate simulation file");
        generateButton.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                generateButtonActionPerformed(evt);
            }
        });

        jLabel33.setFont(new java.awt.Font("Lucida Grande", 0, 18));
        jLabel33.setText("Run");

        org.jdesktop.layout.GroupLayout PanelRunFileLayout = new org.jdesktop.layout.GroupLayout(PanelRunFile);
        PanelRunFile.setLayout(PanelRunFileLayout);
        PanelRunFileLayout.setHorizontalGroup(
            PanelRunFileLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(PanelRunFileLayout.createSequentialGroup()
                .add(PanelRunFileLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(PanelRunFileLayout.createSequentialGroup()
                        .addContainerGap()
                        .add(PanelRunFileLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(PanelRunFileLayout.createSequentialGroup()
                                .add(generateButton)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(jScrollPane3, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 332, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                            .add(PanelRunFileLayout.createSequentialGroup()
                                .add(8, 8, 8)
                                .add(jLabel4)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(progressBar, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 161, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .add(26, 26, 26)
                                .add(runButton))))
                    .add(PanelRunFileLayout.createSequentialGroup()
                        .add(39, 39, 39)
                        .add(jLabel33)))
                .addContainerGap(137, Short.MAX_VALUE))
        );
        PanelRunFileLayout.setVerticalGroup(
            PanelRunFileLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, PanelRunFileLayout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel33)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 65, Short.MAX_VALUE)
                .add(PanelRunFileLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jScrollPane3, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 204, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(PanelRunFileLayout.createSequentialGroup()
                        .add(74, 74, 74)
                        .add(generateButton)))
                .add(54, 54, 54)
                .add(PanelRunFileLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(PanelRunFileLayout.createSequentialGroup()
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 5, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .add(PanelRunFileLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, jLabel4)
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, progressBar, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                    .add(runButton))
                .add(49, 49, 49))
        );
        wizard.addTab("Run!", PanelRunFile);

        jLabel16.setText("Simulation Properties File Generator: RL Agent for Maze Version 1.00");

        jLabel17.setText("Eye-Language Lab (http://eyelanguage.org)");

        nextButton.setText("Next");
        nextButton.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                nextButtonActionPerformed(evt);
            }
        });

        previousButton.setText("Previous");
        previousButton.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                previousButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel16)
                    .add(jLabel17)
                    .add(wizard, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 694, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(26, Short.MAX_VALUE))
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap(493, Short.MAX_VALUE)
                .add(previousButton)
                .add(14, 14, 14)
                .add(nextButton)
                .add(77, 77, 77))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel16)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel17)
                .add(33, 33, 33)
                .add(wizard, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(nextButton)
                    .add(previousButton))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void runButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_runButtonActionPerformed
    {//GEN-HEADEREND:event_runButtonActionPerformed
        final MazeWizardFrame me = this;
        Thread t = new Thread(new Runnable()
        {
           public void run()
           {

                try
                {
                    Properties p = getProperties();
                    MazeMain.loadParametersFromProperties(p);
                    progressBar.setMaximum(new Integer(p.getProperty("iterationCount")));
                    progressBar.setValue(0);
                    MazeMain.monitor = me;
                    
                    runButton.setEnabled(false);
                    MazeMain.run();
                    System.out.println("Run complete");
                    runButton.setEnabled(true);
                    progressBar.setValue(0);
                }
                catch (Exception e)
                {
                    tools.Alert.showMessage(
                            e.getClass() 
                            + " " 
                            + e.getMessage()
                            + "\n\n"
                            + tools.Exceptions.exceptionToString(e));
                    
                    e.printStackTrace();
                    runButton.setEnabled(true);
                    progressBar.setValue(0);                    
                }
           }
        });            
        t.start();
        
        
        
    }//GEN-LAST:event_runButtonActionPerformed

    public void notifyFinished(String result)
    {
        tools.Alert.showMessage(result);
    }
    
    public boolean stopRequested()
    {
        return false;
    }
    
    public boolean pauseRequested()
    {
        return false;
    }
    
    
    private Properties getProperties()
    {
        Properties p = new Properties();
        p.setProperty("iterationCount", numIterations.getText());
        p.setProperty("obstacles", obstacles.getText());
        p.setProperty("mazeX", mazeX.getText());
        p.setProperty("mazeY", mazeY.getText());
        p.setProperty("pObstacle", pObstacle.getText());
        p.setProperty("teleporters", teleporters.getText());
        p.setProperty("destinations", destinations.getText());
        p.setProperty("discountFactor", discountFactor.getText());
        p.setProperty("epsilon", epsilon.getText()); 
        p.setProperty("maxMin", maxMin.getText()); 
        p.setProperty("residualWeighting", residualWeighting.getText()); 
        
        p.setProperty("learningRate", synapticModificationRate.getText());
        p.setProperty("valueFunctionType", (String) valueFunctionType.getSelectedItem());
        return p;
    }

    public void updateProgress(final int newValue)
    {
        java.awt.EventQueue.invokeLater(new Runnable()
        {
           public void run()
           {
               progressBar.setValue(newValue);
           }
        });        
    }
    
    
    private void generateButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_generateButtonActionPerformed
    {//GEN-HEADEREND:event_generateButtonActionPerformed
        Properties p = getProperties();                     
        String result = "";
                
        Enumeration e = p.propertyNames();
        while (e.hasMoreElements())
        {
            String key = (String) e.nextElement();
            result = result + key + " = " + p.get(key) + "\n";
        }
        
        this.generatedFile.setText(result);
    }//GEN-LAST:event_generateButtonActionPerformed

    private void mazeYActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_mazeYActionPerformed
    {//GEN-HEADEREND:event_mazeYActionPerformed
// TODO add your handling code here:
    }//GEN-LAST:event_mazeYActionPerformed

    private void previousButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_previousButtonActionPerformed
    {//GEN-HEADEREND:event_previousButtonActionPerformed
        java.awt.EventQueue.invokeLater(new Runnable()
        {
           public void run()
           {

                if (wizard.getSelectedIndex()>0) wizard.setSelectedIndex(wizard.getSelectedIndex()-1);
                checkButtonStates();
           }
        });
        
    }//GEN-LAST:event_previousButtonActionPerformed

    private void nextButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_nextButtonActionPerformed
    {//GEN-HEADEREND:event_nextButtonActionPerformed
        java.awt.EventQueue.invokeLater(new Runnable()
        {
           public void run()
           {
                if (wizard.getSelectedIndex()<wizard.getTabCount()-1) wizard.setSelectedIndex(wizard.getSelectedIndex()+1);
                checkButtonStates();
           }
        });
        
    }//GEN-LAST:event_nextButtonActionPerformed

    private void checkButtonStates()
    {

                if (previousButton.isEnabled())
                {
                    if (wizard.getSelectedIndex() == 0)
                    {
                        previousButton.setEnabled(false);
                    }
                }
                if (!previousButton.isEnabled())
                {
                    if (wizard.getSelectedIndex() > 0)
                    {
                        previousButton.setEnabled(true);
                    }
                }        

                if (nextButton.isEnabled())
                {
                    if (wizard.getSelectedIndex() == wizard.getTabCount()-1)
                    {
                        nextButton.setEnabled(false);
                    }
                }
                if (!nextButton.isEnabled())
                {
                    if (wizard.getSelectedIndex() < wizard.getTabCount()-1)
                    {
                        nextButton.setEnabled(true);
                    }
                }
    }
    
    private void numHiddenUnitsActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_numHiddenUnitsActionPerformed
    {//GEN-HEADEREND:event_numHiddenUnitsActionPerformed
// TODO add your handling code here:
    }//GEN-LAST:event_numHiddenUnitsActionPerformed
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[])
    {
        java.awt.EventQueue.invokeLater(new Runnable()
        {
            public void run()
            {
                new MazeWizardFrame().setVisible(true);
            }
        });
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel PanelAgent;
    private javax.swing.JPanel PanelDimensions;
    private javax.swing.JPanel PanelInstructions;
    private javax.swing.JPanel PanelNeuralNetwork;
    private javax.swing.JPanel PanelRunFile;
    private javax.swing.JPanel PanelSaveLoad;
    private javax.swing.JPanel PanelTerrain;
    private javax.swing.JTextArea destinations;
    private javax.swing.JTextField discountFactor;
    private javax.swing.JTextField epsilon;
    private javax.swing.JTextField filename;
    private javax.swing.JButton generateButton;
    private javax.swing.JTextArea generatedFile;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButton3;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JLabel jLabel17;
    private javax.swing.JLabel jLabel18;
    private javax.swing.JLabel jLabel19;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel20;
    private javax.swing.JLabel jLabel21;
    private javax.swing.JLabel jLabel22;
    private javax.swing.JLabel jLabel23;
    private javax.swing.JLabel jLabel24;
    private javax.swing.JLabel jLabel25;
    private javax.swing.JLabel jLabel26;
    private javax.swing.JLabel jLabel27;
    private javax.swing.JLabel jLabel28;
    private javax.swing.JLabel jLabel29;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel30;
    private javax.swing.JLabel jLabel31;
    private javax.swing.JLabel jLabel32;
    private javax.swing.JLabel jLabel33;
    private javax.swing.JLabel jLabel34;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JScrollPane jScrollPane4;
    private javax.swing.JTextField maxMin;
    private javax.swing.JTextField mazeX;
    private javax.swing.JTextField mazeY;
    private javax.swing.JButton nextButton;
    private javax.swing.JTextField numHiddenUnits;
    private javax.swing.JTextField numIterations;
    private javax.swing.JTextArea obstacles;
    private javax.swing.JTextField pObstacle;
    private javax.swing.JButton previousButton;
    private javax.swing.JProgressBar progressBar;
    private javax.swing.JTextField residualWeighting;
    private javax.swing.JButton runButton;
    private javax.swing.JTextField synapticModificationRate;
    private javax.swing.JTextArea teleporters;
    private javax.swing.JComboBox valueFunctionType;
    private javax.swing.JTabbedPane wizard;
    // End of variables declaration//GEN-END:variables
    
}
