package net.pakl.rl.maze;

import net.pakl.rl.*;

/** 
  * This class represents a one-dimensional action, which could correspond to a movement vector in a 2D {@link World}
  * such as {@link MazeWorld} 
  */
public class Action2D implements Action
{
        private int deltaX;
        private int deltaY;
        
	public Action2D(int deltaX, int deltaY)
	{
            this.deltaX = deltaX;
            this.deltaY = deltaY;
	}

	/**
	  * This constructor allows you to create an action based on
	  * the difference between two states -- moving from state1 to state2
	  */
	public Action2D(State2D state1, State2D state2)
	{
            this.deltaX = state2.getX() - state1.getX();
            this.deltaY = state2.getY() - state1.getY();
        }
        public boolean equals(Object o)
        {
            if (o instanceof Action2D)
            {
                Action2D otherAction = (Action2D) o;
                if (otherAction.getDeltaX() == this.getDeltaX())
                {
                    if (otherAction.getDeltaY() == this.getDeltaY())
                    {
                        return true;
                    }
                }
            }
            return false;
        }

	public int getDeltaX()
	{
            return deltaX;
	}
        
	public int getDeltaY()
	{
            return deltaY;
	}

        public void setDeltaX()
	{
            this.deltaX = deltaX;
	}
        
	public void setDeltaY()
	{
            this.deltaY = deltaY;
	}

	public String toString()
	{
            return "[action2D "+getDeltaX()+","+getDeltaY()+"]";
	}
        
        public int hashCode()
        {
                return 1000 * getDeltaX() + getDeltaY();
        }



}
