package net.pakl.rl;

import java.util.*;
import java.util.zip.*;
import java.io.*;

/** A custom HashMap class that zips all objects that fall into a particular
 * row of the HashMap (Hash together, get zipped together.)  The hope was that
 * this would save a significant amount of memory and allow larger simulations
 * to be run... but it wasn't enough. */
public class ZippedHashMap extends HashMap
{
	HashMap entries = new HashMap();
	
    public ZippedHashMap(int numStates)
    {
    }        
    
    public ZippedHashMap()
    {
    }
    
	public Object put(Object key, Object value)
	{
		Object zipEntryKey = new Integer(key.hashCode());
		try
		{
			// --------------------------------------------------------------
			// Retrieve mini HashMap from memory; create one if none exists.
			// --------------------------------------------------------------
			HashMap map = null;
			try
			{	
				byte [] data = (byte[]) entries.get(new Integer(key.hashCode()));
				ByteArrayInputStream bi = new ByteArrayInputStream(data);
				ObjectInputStream oi = new ObjectInputStream(new GZIPInputStream(bi));
				map = (HashMap) oi.readObject();
			}
			catch (Exception e) 
			{ 
                map = new HashMap();
            }

			map.put(key, value);

			// --------------------------------------------------------------
			// Write mini HashMap back to memory
			// --------------------------------------------------------------
			ByteArrayOutputStream bo = new ByteArrayOutputStream();
			ObjectOutputStream oo = new ObjectOutputStream(new GZIPOutputStream(bo));
			oo.writeObject(map);
			oo.close();
			entries.put(zipEntryKey, bo.toByteArray());
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		return null;
	}	

	public Object get(Object key) 
	{
		try
		{
            Object result = null;
            Object zipEntryKey = new Integer(key.hashCode());
            ByteArrayInputStream bi = new ByteArrayInputStream((byte[]) entries.get(zipEntryKey));
            if (bi != null)
            {
                    HashMap map = (HashMap) (new ObjectInputStream(new GZIPInputStream(bi))).readObject();
                    if (map == null)
                    {
                        return null;
                    }
                    Object valueAssociatedWithKey = map.get(key);
                    return valueAssociatedWithKey;
            }
		}
		catch (Exception e)
		{
			//throw new NullPointerException("Key "+key+" ("+key.hashCode()+") was not found in ZippedHashMap.");
		}	
		return null;
	}
		
    class SimpleObject implements Serializable
    {
        private Integer data;
        private int hashCode;
        public SimpleObject(int n)
        {
            data = new Integer(n);
        }
        public void setHashCode(int n)
        {
            hashCode = n;
        }
        public int hashCode()
        {
            return hashCode;
        }
        public boolean equals(Object otherObject)
        {
            if (otherObject instanceof SimpleObject)
            {
                return ((SimpleObject)otherObject).getValue() == this.getValue();
            }
            return false;
        }
        public int getValue()
        {
            return data.intValue();
        }
    }

        
    public void test()
    {
        ZippedHashMap z = this;
        z.put("Hi", "Hello");
        z.put("Bye", "Goodbye");
        System.out.println(z.get("Hi") + " " + z.get("Bye"));
        System.out.println(z.get("Hi2") + " " + z.get("Bye2"));
        
        SimpleObject o1 = new SimpleObject(100);
        SimpleObject o2 = new SimpleObject(101);
        SimpleObject o3 = new SimpleObject(102);
        o1.setHashCode(1);
        o2.setHashCode(1);
        o3.setHashCode(1);
        z.put(o1, "one");
        z.put(o2, "two");
        z.put(o3, "three, compressed in same entry.");
        System.out.println(z.get(o1) + " " + z.get(o2) + " " + z.get(o3));
    }
        
	public static void main(String args[]) throws Exception 
	{
		ZippedHashMap z = new ZippedHashMap();
        z.test();
	}
}
