package net.pakl.rl;

import java.util.*;
/**
 * Basic specification of a world, which ensures that all
 * worlds have certain methods (functions) and
 * can be built, traversed and can have a physical distance measure defined.
 */
public interface World
{
    /** Allows a world to be built once all necessary aspects of it have been specified. */
    public void build();
    /** Allows you to determine if the world has been built yet or not. */
    public boolean getIsBuilt();
    /** Returns a text representation of the world, if possible. */
    public String toText();
    
    /** Returns an object which lets you iterate over all states (positions) in the world. */
    public Iterator stateIterator();
    
    /** Returns a list of all the states (i.e. positions) in the world. */
    public List getStateList();
    public State getStartingState();
    public int getNumberOfStates();
    
    /** Given a state and an action, returns the resulting state. */
    public State getNewState(State oldState, Action action);
    /** Reports whether this particular state is a terminal state.*/
    public boolean isTerminalState(State state);
}
