package net.pakl.rl;
import net.pakl.neuralnet.*;

public class ValueFunctionResidualAlgorithmPatrykNetwork extends ValueFunctionResidualAlgorithmPerceptron implements ValueFunction
{

    public ValueFunctionResidualAlgorithmPatrykNetwork()
    {
        super();
    }
    public ValueFunctionResidualAlgorithmPatrykNetwork(World w)
    {
        super(w);
    }

    protected int numContextUnits;
    public int timestepsToReflect = 4;
    public boolean clearBeforeTrajectories = true;
    public boolean clearBeforeEachState = true;           // no sequential memory at all, tick to tick
    
    protected void initializeNetworkForStatesOfType(HasVectorRepresentation thisStateObject)
    {
            System.out.println("Initialize network for ValueFunctionResidualAlgorithmPatrykNetwork");

            double [] thisState = thisStateObject.doubleRepresentation();
            
            int inputSize = thisState.length;
            this.numContextUnits = hiddenUnits;
            int [] layerBreaks = {inputSize, inputSize+hiddenUnits, inputSize+hiddenUnits+1};
            System.out.println("Input size: " + inputSize);
            System.out.println("Context units: " + numContextUnits);
            System.out.println("Hidden units:" + hiddenUnits);
            
            
            System.out.println("Parameters affecting Recurrent Computation:");
            System.out.println("  timestepsToReflect = " + timestepsToReflect);
            System.out.println("  clearBeforeTrajectories = " + clearBeforeTrajectories);
            System.out.println("  clearBeforeEachState = " + clearBeforeEachState);

            net = new PerceptronPatrykThesis(randomSeed, inputSize, numContextUnits, hiddenUnits, learningRate, 0);
            // net.reinitializeRandomWeightsWith(0.1);
            System.out.println("We specified " + (inputSize+hiddenUnits+1) + " neurons and learn rate is " + learningRate);

            double [][] currentWeights = net.getWeights();
            numPresynaptics = currentWeights.length;
            System.out.println("Perceptron really has (because of BIAS neurons) presynaptics with weights " +numPresynaptics);
            outputNeuron = inputSize+hiddenUnits+numContextUnits;
            System.out.println("outputNeuron is neuron #" + outputNeuron);
            double [][] zeroes = new double[numPresynaptics][numPresynaptics];
            // net.setWeights(zeroes);
            totalWeightChangeForEpoch = new double[numPresynaptics][numPresynaptics];

            System.out.println("residualWeighting = " + residualWeighting);
            System.out.println("[NOT USED] multiplyAndAdd = " +multiplyAndAdd);
    }    
    
    protected void setValue(HasVectorRepresentation thisStateObject, HasVectorRepresentation nextStateObject, double newValue, double discountFactor)
    {        
        if (net == null)
        {
            initializeNetworkForStatesOfType(thisStateObject);
        }
        
        double [] thisState = thisStateObject.doubleRepresentation();
        double [] nextState = nextStateObject.doubleRepresentation();
                
        double multiplyBy = -1.0d * learningRate * (newValue - getValue(thisStateObject));
        double [][] partialDerivVx = null;
        double [][] partialDerivVx2 = null;

        double [][] currentWeights = null;
        
        if (clearBeforeEachState) ((PerceptronPatrykThesis)net).clearContextUnits();
        for (int i = 0; i < timestepsToReflect; i++)
        {
            currentWeights = net.getWeights();

            net.feedforward(thisState);
            partialDerivVx = net.getOutputDerivativeAgainstWeights();
            net.feedforward(nextState);
            partialDerivVx2 = net.getOutputDerivativeAgainstWeights();

            double [][]weightChange = null;
            if (RESIDUAL_ALGORITHM)
            {
                weightChange = vmul(multiplyBy, vsub(vmul(residualWeighting*discountFactor, partialDerivVx2), partialDerivVx));
            }
            else
            {
                weightChange = vmul(multiplyBy, vsub(vmul(discountFactor, partialDerivVx2), partialDerivVx));
            }

            // To get incremental to work, do you need to randomly visit all the states? (not in sequence)
            if (INCREMENTAL_UPDATE)  
            {
                net.setWeights(vadd(currentWeights, weightChange));
            }
            else
            {
                totalWeightChangeForEpoch = vadd(totalWeightChangeForEpoch, weightChange);
            }
            ((PerceptronPatrykThesis)net).copyHiddenExcitationToContextUnits();
        }
        
        // Assume that if you train on a terminal state, you have reached end of trajectory. 
        if (clearBeforeTrajectories)
        {
            if (world.isTerminalState((State)thisStateObject))
            {
                ((PerceptronPatrykThesis)net).clearContextUnits();
            }
        }

    }
    
    protected double getValue(HasVectorRepresentation state)
    {        
        if (world.isTerminalState((State)state))
        {
            return valueOfTerminalStates;
        }
        if (net == null)
        {
            return 0;
        }

        double [] thisState = state.doubleRepresentation();

        if (clearBeforeEachState) ((PerceptronPatrykThesis)net).clearContextUnits();
        for (int i = 0; i < timestepsToReflect; i++)
        {
            net.feedforward(thisState);
            ((PerceptronPatrykThesis)net).copyHiddenExcitationToContextUnits();
        }
        return net.getNetInput(outputNeuron);      // Instead of getActivity, we're only interested in the linear combination of inputs.
    }
    
    
}
