package net.pakl.rl;

import java.util.*;
import java.io.*;

/** 
  * A ValueFunction maps states from a {@link World}, to values, and may be implemented 
  * with a neural network or a HashMap.
  * For an example hashmap implementation see {@link ValueFunctionHashMap}.   
  * When the value function
  * is optimal then the optimal policy can be extracted
  * from it in realtime, see {@link PolicyExtractor}.
  */
public interface ValueFunction extends Serializable
{
    /** Retrieve the value associated with a state (which may be different for non-stored states depending on the actual class
     * implementing this value function). */
    public double getValue(State state);
    public void setValue(State state, double newValue);
    /** Many problems define a value of 0 for their terminal states, where the agent can remain. */
    public void setValueOfTerminalStates(double newValueOfTerminalStates);
    /** It is important for value functions to have names for the patchwork approach, so that states can identify to which
     * value function patch they belong by the {@link PolicyExtractor}. */
    public String getName();
    public void setName(String name);
    public void setWorld(World w);
}
