package net.pakl.rl;

/** Can be used to convert a ValueFunction into a Q-function. */
public class StateActionPair extends State
{
    
    State state;
    Action action;

    public StateActionPair(State s, Action a) 
    {
        // Should these be cloned/duplicated?  Here we're just keeping a reference to the original objects.
        state = s;
        action = a;
    }

    public boolean equals(Object o)
    {
        if (!(o instanceof StateActionPair)) return false;
        StateActionPair sap = (StateActionPair) o;
        return state.equals(sap.state) && action.equals(sap.action);
    }

    public int hashCode()
    {
        return state.hashCode() + action.hashCode();
    }
    
    public String toString()
    {
        return state.toString() + " & " + action.toString();
    }
    
}
