package net.pakl.rl;

/** A State represents a position or attitude in a {@link World} (that is, physical and/or
 * mental attitudes); from any {@link State}, some
 * {@link Action} is possible.
 */
public abstract class State implements java.io.Serializable
{
    public abstract String toString();
    public abstract int hashCode();
    public abstract boolean equals(Object otherObject);
    
    
    public static int [] representAsVector(int value, int min, int max, int granularity)
    {
        int numSlots =  ((max - min) / granularity) + 1;
        int [] result = new int[numSlots];
        
        result[(value - min)/granularity] = 1;
        return result;
    }
    
    public static int [] concatenateArrays(Object... arrays)
    {
        int finalSize = 0;
        for (Object eachArray : arrays)
        {
            finalSize += ((int[])eachArray).length;
        }
        
        int [] result = new int[finalSize];
        int destination = 0;
        for (Object eachArray : arrays)
        {
            int [] currentArray = (int []) eachArray;
            for (int i = 0; i < currentArray.length; i++)
            {
                result[destination] = currentArray[i];
                destination++;
            }
        }
        return result;
    }
    
    public String getPatchName()
    {
        return "";
    }
    
    
    
}
