package net.pakl.rl;

import java.util.*;			// To bring in the HashMap class

/** 
  * This class contains all of the required 
  * functionality for a reward function
  * and should be applicable to all worlds.  But, it must
  * be initialized by something that knows what the
  * appropriate reinforcement is for the world such as by
  * a function in a Toolbox. 
  */
public class ReinforcementFunction
{

	//HashMap stateActionToRewardMap = new HashMap();
        HashMap stateToActionRewardMaps = new HashMap();

        double defaultReinforcement = 0;

	/**
	  * This function allows you to set the default reinforcement for any action from a state where
	  * reinforcement has not been specified.  For example, if you have a pond with sparse landing 
	  * surfaces, it may be easier to use this function to set the value of the water than to specify
	  * the reinforcement value for each possible action leading to water.
	  */	
	public void setDefaultReinforcement(double newDefault)
	{
		this.defaultReinforcement = newDefault;
	}
        
        public double getDefaultReinforcement()
        {
            return defaultReinforcement;
        }

        public String toText()
        {
            Iterator i = stateToActionRewardMaps.keySet().iterator();
            while (i.hasNext())
            {
                Object state = i.next();
                System.out.println(state);
                HashMap actionRewardsMap = (HashMap) stateToActionRewardMaps.get(state);
                Iterator j = actionRewardsMap.keySet().iterator();
                while (j.hasNext())
                {
                    Object action = j.next();
                    System.out.println("\t" + action);
                    Double reward = (Double) actionRewardsMap.get(action);
                    System.out.println("\t\t" + state + " + " + action+ " = " + reward);
                }
            }
            return "reinffunc";
        }
        
	/**
	  * Return the reward given an action from a particular state.
	  */
	public double getReward(State state, Action action)
	{
            HashMap actionToRewardMap = (HashMap) stateToActionRewardMaps.get(state);
            if (actionToRewardMap == null) 
            {
                    return this.defaultReinforcement;
            }

            Double reward = (Double) actionToRewardMap.get(action);
            if (reward == null) return this.defaultReinforcement;
            return reward.doubleValue();        
        }
        /**
         * Sometimes a reward is also based on the resulting state.  Rather than
         * re-computing the resulting state of the action (and if the results of
         * actions are stochastic rather than deterministic, that could be the
         * wrong thing to do), this function lets you pass in the state that
         * actually resulted.
         */
	public double getReward(State state, Action action, State newState)
	{
            return getReward(state, action);
        }

	public void setReward(State state, Action action, double newReward)
	{
            HashMap actionToRewardMap = (HashMap) stateToActionRewardMaps.get(state);
            if (actionToRewardMap == null) 
            {
                actionToRewardMap = new HashMap();
            }
            actionToRewardMap.put(action, new Double(newReward));
            stateToActionRewardMaps.put(state, actionToRewardMap);
        }


	private Object createUniqueKeyFrom(State state, Action action)
	{
            String uniqueKey = state.toString() + action.toString();
            return uniqueKey;
	}
}

