package net.pakl.rl;

import java.util.Random;
import java.io.*;

/** This class ensures that each thread that invokes it will get a unique random number generator. 
 * I believe this was done so that different runs would result in the same exact values (replicate). */
public class RandomPerThread extends ThreadLocal implements Serializable
{
	long randomSeed = 0;

	public void setRandomSeed(long x)
	{
		randomSeed = x;
	}

	public Object initialValue()
	{
		if (randomSeed != 0)
		{
			Random result = new Random(randomSeed);
			randomSeed = 0;
			return result;
		}
		else
		{
			return new Random(System.currentTimeMillis());
		}
	}

	//public Object initialValue()
	//{
	//	// To test, try calling this.source() from multiple threads, and
	//	// verify you obtain the same sequences
	//	return new Random(123);
	//}
}
