package net.pakl.rl;
import java.util.*;
import java.io.Serializable;

// public remote class HashMapRemote extends jp.lang.RemoteObject implements Serializable
/** Instances of HashMaps that are actually distributed to the different machines -- to use,
 * recompile with the JavaParty front-end to generate class and stubs (and place their keyword
 * 'remote' to obtain <b>public remote class</b>).
 */
public class HashMapRemote // extends jp.lang.RemoteObject implements Serializable
{
	private HashMap h;
	public HashMapRemote()
	{
		h = new HashMap();
		System.out.println("[" + getClass() + ", 0] on " + getHost()
                + " (" +Runtime.getRuntime().freeMemory() + " free memory)");
	}
	public HashMapRemote(int keys)
	{
		h = new HashMap(keys);
		System.out.println("[" + getClass() + ", "+keys+"] on " + getHost()
                + " (" + Runtime.getRuntime().freeMemory() + " free memory)");
	}
	public Object get(Object key)
	{
		return h.get(key);
	}
	public Object put(Object key, Object value)
	{
		h.put(key,value);
		return null;
	}
        public String getHost()
        {
                try
                {
                        java.net.InetAddress localMachine = java.net.InetAddress.getLocalHost();
                        return(localMachine.getHostName());
                }
                catch(java.net.UnknownHostException uhe)
                {
                        return("unknown hostname");
                }
        }

}
