package net.pakl.rl;
import java.util.*;
import java.io.*;

/** A custom HashMap class that distributes itself over many machines, thereby
 * pooling their RAM together.  Creates instances of HashMapRemote. */
public class HashMapDistributed extends HashMap implements Externalizable
{
	int machines = 10;
    int keys = 50000;
	ArrayList hashmaps = new ArrayList();

	public HashMapDistributed(int numKeys)
	{
            keys = numKeys;
            initialize();
	}
	public HashMapDistributed(int numKeys, int numMachines)
	{
            machines = numMachines;
            keys = numKeys;
            initialize();
	}
	public HashMapDistributed()
	{
            initialize();
    }
    
        public void writeExternal(ObjectOutput out) throws IOException 
        {
            System.out.println("HashMapDistributed.writeExternal");
            // You must do this:
            out.writeInt(machines);
            out.writeInt(keys);
            for (int i = 0; i < machines; i++)
            {
                out.writeObject(hashmaps.get(i));
            }
        }
        
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException 
        {
            System.out.println("HashMapDistributed.readExternal");
            throw new RuntimeException("This is commented out to prevent dependencies.  To use javaparty please uncomment this function.");
//            machines = in.readInt();
//            keys = in.readInt();
//                Class theClass = null;
//                try 
//                {
//                    theClass = Class.forName( "jp.lang.DistributedRuntime", true, Thread.currentThread().getContextClassLoader() );
//                    int nodeNumber = 0;
//                    for (int i = 0; i < machines; i++)
//                    {
//                        nodeNumber++;
//                        if (nodeNumber >= jp.lang.DistributedRuntime.getMachineCnt())
//                        {
//                            nodeNumber = 0;
//                        }
//                        HashMapRemote h = (HashMapRemote) in.readObject();
//                        boolean success = jp.lang.DistributedRuntime.migrate((jp.lang.RemoteObject)h, nodeNumber);
//                        System.out.println("Migrating HashMapRemote to node " + nodeNumber);
//                        hashmaps.add(h);
//                    }
//                }
//                catch (ClassNotFoundException e) 
//                {
//                    // Don't migrate them to nodes
//                    System.out.println("JavaParty not found, not migrating hashmaps to other nodes.");
//                    for (int i = 0; i < machines; i++)
//                    {
//                        HashMapRemote h = (HashMapRemote) in.readObject();
//                        hashmaps.add(h);
//                    }
//                }                
        }        
        
        private void initialize()
        {
            System.out.println("HashMapDistributed allocating for 1/"+machines+" total keys="+(keys));
            throw new RuntimeException("This is commented out to prevent dependencies.  To use javaparty please uncomment this function.");
//            int nodeNumber = 0;
//            for (int i = 0; i < machines; i++)
//            {
//                nodeNumber++;
//                if (nodeNumber >= jp.lang.DistributedRuntime.getMachineCnt())
//                {
//                    nodeNumber = 0;
//                }
//                /** @at nodeNumber */
//                HashMapRemote h = new HashMapRemote(keys/machines);
//                hashmaps.add(h);
//            }		
	}
	public Object get(Object key)
	{
		HashMapRemote h = (HashMapRemote) hashmaps.get(key.hashCode() % machines);
		return h.get(key);
	}
	public Object put(Object key, Object value)
	{
		HashMapRemote h =  (HashMapRemote) hashmaps.get(key.hashCode() % machines);
		return h.put(key, value);
	}
}
