package net.pakl.rl;

import java.util.*;

/**
 *
 * A ActionSet maps {@link State}s to possible {@link Action}s
 * and is used by an {@link Agent} in considering its possible next moves.
 */

public class ActionSet
{
    private HashMap policyMap = new HashMap();
    private final List emptyList = new ArrayList();
    
    /**
     * This method returns a list of all possible actions an agent could
     * take given a {@link State}. If there are no actions,
     * this function returns an empty list (rather than returning a null).
     */
    public List getAllPossibleActions(State state)
    {
        List actions = (List) policyMap.get(state);
        if (actions == null)
        {
            return emptyList;
        }
        return actions;
    }
    
    
    /**
     * This method allows you to program in a possible action given
     * a state.
     */
    public void allowAction(State state, Action newAction)
    {
        List actions = (List) policyMap.get(state);
        if (actions == null)
        {
            actions = new ArrayList();
            actions.add(newAction);
                policyMap.put(state, actions);
        }
        else
        {
            if (!actions.contains(newAction))
            {
                actions.add(newAction);
            }
        }
    }
    
    /**
     * This method allows you to deprogram an action from being possible
     */
    public void removeAction(State state, Action oldAction)
    {
        List actionsForThisState = (List) policyMap.get(state);
        if (actionsForThisState == null)
        {
        }
        else
        {
            actionsForThisState.remove(oldAction);
        }
    }

    
    public Action getRandomAllowedAction(State state)
    {
        List possibleActions = this.getAllPossibleActions(state);
        int randomActionIndex = (int) (Math.random() * (double) possibleActions.size());
        
        return (Action) possibleActions.get(randomActionIndex);
    }
    

    /** Returns a textual representation of this ActionSet */
    public String toText()
    {
        StringBuffer result = new StringBuffer("");
        Iterator i = policyMap.keySet().iterator();
        while (i.hasNext())
        {
            State state = (State) i.next();
            result.append(state.toString());
            List actions = (List) policyMap.get(state);
            for (int j = 0; j < actions.size(); j++)
            {
                result.append(" " + actions.get(j).toString());
            }
            result.append("\n");
        }
        return result.toString();
    }    
}

