/*
 * Decompiled with CFR 0.152.
 */
package uka.util;

import uka.transport.WireHashtable;
import uka.util.Printable;

public class ToString {
    WireHashtable visited = new WireHashtable();

    public static String toString(boolean value) {
        return Boolean.toString(value);
    }

    public static String toString(byte value) {
        return Byte.toString(value);
    }

    public static String toString(char value) {
        if (value < ' ') {
            return "'\\x" + Integer.toHexString(value & 0xFFFF) + "'";
        }
        return "'" + Character.toString(value) + "'";
    }

    public static String toString(short value) {
        return Short.toString(value);
    }

    public static String toString(int value) {
        return Integer.toString(value);
    }

    public static String toString(long value) {
        return Long.toString(value);
    }

    public static String toString(float value) {
        return Float.toString(value);
    }

    public static String toString(double value) {
        return Double.toString(value);
    }

    public String toString(Object value) {
        if (value == null) {
            return "null";
        }
        int id = this.visited.findWireOffset(value);
        Class<?> valueClass = value.getClass();
        if (id >= 0) {
            return ToString.toStringType(valueClass) + "#" + id;
        }
        id = this.visited.assignWireOffset(value);
        if (value instanceof Printable) {
            return ToString.toStringType(valueClass) + "#" + id + "{" + ((Printable)value).toString(this) + "}";
        }
        if (valueClass.isArray()) {
            return ToString.toStringType(valueClass) + "#" + id + "{" + this.toStringArray(value) + "}";
        }
        return ToString.toStringType(valueClass) + "#" + id + "{" + value.toString() + "}";
    }

    public static String toStringType(Class valueClass) {
        if (valueClass.isPrimitive()) {
            if (valueClass == Boolean.TYPE) {
                return "boolean";
            }
            if (valueClass == Byte.TYPE) {
                return "byte";
            }
            if (valueClass == Character.TYPE) {
                return "char";
            }
            if (valueClass == Short.TYPE) {
                return "short";
            }
            if (valueClass == Integer.TYPE) {
                return "int";
            }
            if (valueClass == Long.TYPE) {
                return "long";
            }
            if (valueClass == Float.TYPE) {
                return "float";
            }
            if (valueClass == Double.TYPE) {
                return "double";
            }
            throw new AssertionError();
        }
        if (valueClass.isArray()) {
            return ToString.toStringType(valueClass.getComponentType()) + "[]";
        }
        return valueClass.getName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toStringArray(Object array) {
        Class<?> arrayClass = array.getClass();
        Class<?> componentClass = arrayClass.getComponentType();
        StringBuffer result = new StringBuffer();
        if (componentClass.isPrimitive()) {
            if (componentClass == Boolean.TYPE) {
                ToString.toStringArray(result, (boolean[])array);
                return result.toString();
            } else if (componentClass == Byte.TYPE) {
                ToString.toStringArray(result, (byte[])array);
                return result.toString();
            } else if (componentClass == Character.TYPE) {
                ToString.toStringArray(result, (char[])array);
                return result.toString();
            } else if (componentClass == Short.TYPE) {
                ToString.toStringArray(result, (short[])array);
                return result.toString();
            } else if (componentClass == Integer.TYPE) {
                ToString.toStringArray(result, (int[])array);
                return result.toString();
            } else if (componentClass == Long.TYPE) {
                ToString.toStringArray(result, (long[])array);
                return result.toString();
            } else if (componentClass == Float.TYPE) {
                ToString.toStringArray(result, (float[])array);
                return result.toString();
            } else {
                if (componentClass != Double.TYPE) throw new AssertionError();
                ToString.toStringArray(result, (double[])array);
            }
            return result.toString();
        } else {
            this.toStringArray(result, (Object[])array);
        }
        return result.toString();
    }

    private void toStringArray(StringBuffer result, Object[] array) {
        int length = array.length;
        for (int n = 0; n < length; ++n) {
            if (n > 0) {
                result.append(", ");
            }
            result.append(this.toString(array[n]));
        }
    }

    private static void toStringArray(StringBuffer result, boolean[] array) {
        int length = array.length;
        for (int n = 0; n < length; ++n) {
            if (n > 0) {
                result.append(", ");
            }
            result.append(ToString.toString(array[n]));
        }
    }

    private static void toStringArray(StringBuffer result, byte[] array) {
        int length = array.length;
        for (int n = 0; n < length; ++n) {
            if (n > 0) {
                result.append(", ");
            }
            result.append(ToString.toString(array[n]));
        }
    }

    private static void toStringArray(StringBuffer result, char[] array) {
        int length = array.length;
        for (int n = 0; n < length; ++n) {
            if (n > 0) {
                result.append(", ");
            }
            result.append(ToString.toString(array[n]));
        }
    }

    private static void toStringArray(StringBuffer result, short[] array) {
        int length = array.length;
        for (int n = 0; n < length; ++n) {
            if (n > 0) {
                result.append(", ");
            }
            result.append(ToString.toString(array[n]));
        }
    }

    private static void toStringArray(StringBuffer result, int[] array) {
        int length = array.length;
        for (int n = 0; n < length; ++n) {
            if (n > 0) {
                result.append(", ");
            }
            result.append(ToString.toString(array[n]));
        }
    }

    private static void toStringArray(StringBuffer result, long[] array) {
        int length = array.length;
        for (int n = 0; n < length; ++n) {
            if (n > 0) {
                result.append(", ");
            }
            result.append(ToString.toString(array[n]));
        }
    }

    private static void toStringArray(StringBuffer result, float[] array) {
        int length = array.length;
        for (int n = 0; n < length; ++n) {
            if (n > 0) {
                result.append(", ");
            }
            result.append(ToString.toString(array[n]));
        }
    }

    private static void toStringArray(StringBuffer result, double[] array) {
        int length = array.length;
        for (int n = 0; n < length; ++n) {
            if (n > 0) {
                result.append(", ");
            }
            result.append(ToString.toString(array[n]));
        }
    }
}

