/*
 * Decompiled with CFR 0.152.
 */
package uka.util;

public class Long2ObjectHashtable {
    private int hashSize;
    private int hashMask;
    private int limit;
    private int size;
    private Entry[] table;
    private Entry spare;

    public Long2ObjectHashtable(int initialSize, float fillFactor) {
        int hashSize;
        for (hashSize = 1; hashSize < initialSize; hashSize <<= 1) {
        }
        this.hashSize = hashSize;
        this.hashMask = hashSize - 1;
        this.limit = (int)((float)hashSize * fillFactor);
        this.size = 0;
        this.table = new Entry[hashSize];
    }

    public Long2ObjectHashtable(int initialSize) {
        this(initialSize, 0.75f);
    }

    public Long2ObjectHashtable() {
        this(32);
    }

    public static Long2ObjectHashtable make() {
        return new Long2ObjectHashtable();
    }

    private void dble() {
        this.hashSize <<= 1;
        this.hashMask = this.hashSize - 1;
        this.limit <<= 1;
        Entry[] oldtable = this.table;
        this.table = new Entry[this.hashSize];
        for (int i = 0; i < oldtable.length; ++i) {
            this.copy(oldtable[i]);
        }
    }

    private final int getIndex(long key) {
        return ((int)key ^ (int)(key >>> 32)) & this.hashMask;
    }

    private void copy(Entry e) {
        if (e != null) {
            this.copy(e.next);
            int index = this.getIndex(e.key);
            e.next = this.table[index];
            this.table[index] = e;
        }
    }

    public Object get(long key) {
        int index = this.getIndex(key);
        Entry e = this.table[index];
        while (e != null) {
            if (e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public Object put(long key, Object value) {
        int index = this.getIndex(key);
        Entry prev = null;
        Entry e = this.table[index];
        while (e != null) {
            if (e.key == key) {
                Object oldValue = e.value;
                if (value != null) {
                    e.value = value;
                } else {
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        this.table[index] = e.next;
                    }
                    e.next = this.spare;
                    this.spare = e;
                    --this.size;
                }
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        if (value != null) {
            ++this.size;
            if (this.spare != null) {
                e = this.spare;
                this.spare = this.spare.next;
                e.key = key;
                e.value = value;
                e.next = this.table[index];
            } else {
                if (this.size > this.limit) {
                    this.dble();
                }
                e = new Entry(key, value, this.table[index]);
            }
            this.table[index] = e;
        }
        return null;
    }

    public void remove(long key) {
        this.put(key, null);
    }

    public int size() {
        return this.size;
    }

    public void reset() {
        for (int i = 0; i < this.table.length; ++i) {
            this.table[i] = null;
        }
        this.size = 0;
    }

    private static class Entry {
        long key;
        Object value;
        Entry next;

        Entry(long key, Object value, Entry next) {
            this.key = key;
            this.value = value;
            this.next = next;
        }
    }
}

