/*
 * Decompiled with CFR 0.152.
 */
package uka.util;

public class IntStack {
    protected int sp = 0;
    protected int[] buffer = new int[8];

    public Shadow getShadow() {
        return new Shadow();
    }

    public final int top() {
        return this.buffer[this.sp - 1];
    }

    public final int pop() {
        return this.buffer[--this.sp];
    }

    public final int get(int n) {
        if (n >= this.sp) {
            throw new ArrayIndexOutOfBoundsException(n + ">=" + this.sp);
        }
        return this.buffer[n];
    }

    public final int size() {
        return this.sp;
    }

    public void push(int x) {
        if (this.sp >= this.buffer.length) {
            this.enlarge(1);
        }
        this.buffer[this.sp++] = x;
    }

    public void push(IntStack stack) {
        int base = this.sp;
        int size = stack.size();
        this.pushFrame(size + 1);
        System.arraycopy(stack.buffer, 0, this.buffer, base, size);
        this.buffer[this.sp - 1] = size;
    }

    public final void pop(IntStack stack) {
        int size = this.buffer[this.sp - 1];
        int extra = size - stack.buffer.length;
        if (extra > 0) {
            stack.enlarge(extra);
        }
        System.arraycopy(this.buffer, this.sp - 1 - size, stack.buffer, 0, size);
        stack.sp = size;
        this.popFrame(size + 1);
    }

    public void push(int x, int y) {
        if (this.sp + 2 > this.buffer.length) {
            this.enlarge(2);
        }
        this.buffer[this.sp++] = x;
        this.buffer[this.sp++] = y;
    }

    public void push(int x, int y, int z) {
        if (this.sp + 3 > this.buffer.length) {
            this.enlarge(3);
        }
        this.buffer[this.sp++] = x;
        this.buffer[this.sp++] = y;
        this.buffer[this.sp++] = z;
    }

    public void push(int x, int y, int z, int zz) {
        this.pushFrame(4);
        this.setFrame(0, zz);
        this.setFrame(1, z);
        this.setFrame(2, y);
        this.setFrame(3, x);
    }

    public void pushFrame(int cnt) {
        if (this.sp + cnt > this.buffer.length) {
            this.enlarge(cnt);
        }
        this.sp += cnt;
    }

    public final void popFrame(int cnt) {
        this.sp -= cnt;
    }

    public void setFrame(int pos, int x) {
        this.buffer[this.sp - pos - 1] = x;
    }

    public final int getFrame(int pos) {
        return this.buffer[this.sp - pos - 1];
    }

    public final boolean empty() {
        return this.sp == 0;
    }

    public final void clear() {
        this.sp = 0;
    }

    private final void enlarge(int cnt) {
        int newsize = Math.max(this.buffer.length * 2, this.sp + cnt);
        int[] newbuffer = new int[newsize];
        System.arraycopy(this.buffer, 0, newbuffer, 0, this.sp);
        this.buffer = newbuffer;
    }

    public String toString() {
        return "IntStack(sp=" + this.sp + ")";
    }

    public class Shadow
    extends IntStack {
        protected Shadow() {
            this.sp = IntStack.this.sp;
            this.buffer = IntStack.this.buffer;
        }

        public void push(int x) {
            this.undefine();
        }

        public void push(IntStack stack) {
            this.undefine();
        }

        public void push(int x, int y) {
            this.undefine();
        }

        public void push(int x, int y, int z) {
            this.undefine();
        }

        public void push(int x, int y, int z, int zz) {
            this.undefine();
        }

        public void pushFrame(int cnt) {
            this.undefine();
        }

        public void setFrame(int pos, int x) {
            this.undefine();
        }

        private void undefine() {
            throw new RuntimeException("IntStack.Shadow is pop-only");
        }
    }
}

