/*
 * Decompiled with CFR 0.152.
 */
package uka.util;

import java.io.Serializable;

public class EnlargingLongArray
implements Serializable {
    int length;
    long[] array;
    public static final int MIN_SIZE = 16;
    static final /* synthetic */ boolean $assertionsDisabled;

    public EnlargingLongArray() {
        this.length = 0;
        this.array = new long[16];
    }

    public EnlargingLongArray(int length) {
        this.length = length;
        this.array = new long[length < 16 ? 16 : length];
    }

    public long get(int idx) {
        if (!$assertionsDisabled && idx >= this.length) {
            throw new AssertionError();
        }
        return this.array[idx];
    }

    public long test(int idx) {
        if (idx < this.length) {
            return this.array[idx];
        }
        return 0L;
    }

    public long set(int idx, long obj) {
        if (idx >= this.length) {
            this.enlarge(idx + 1);
        }
        this.array[idx] = obj;
        return this.array[idx];
    }

    public long add(long obj) {
        return this.set(this.length, obj);
    }

    public long pop() {
        if (!$assertionsDisabled && this.length <= 0) {
            throw new AssertionError();
        }
        --this.length;
        long result = this.array[this.length];
        this.array[this.length] = 0L;
        return result;
    }

    public void setSize(int size) {
        if (size > this.length) {
            this.enlarge(size);
            return;
        }
        for (int n = this.length - 1; n >= size; --n) {
            this.array[n] = 0L;
        }
        this.length = size;
    }

    public int size() {
        return this.length;
    }

    public void clear() {
        while (this.length > 0) {
            this.array[--this.length] = 0L;
        }
    }

    private final void enlarge(int newLength) {
        if (newLength <= this.array.length) {
            this.length = newLength;
            return;
        }
        int length2 = this.array.length * 2;
        if (newLength > length2) {
            length2 = newLength;
        }
        long[] newarray = new long[length2];
        System.arraycopy(this.array, 0, newarray, 0, this.length);
        this.array = newarray;
        this.length = newLength;
    }

    static {
        $assertionsDisabled = !EnlargingLongArray.class.desiredAssertionStatus();
    }
}

