/*
 * Decompiled with CFR 0.152.
 */
package uka.util;

import java.io.Serializable;

public class EnlargingIntArray
implements Serializable {
    int length;
    int[] array;
    public static final int MIN_SIZE = 16;
    static final /* synthetic */ boolean $assertionsDisabled;

    public EnlargingIntArray() {
        this.length = 0;
        this.array = new int[16];
    }

    public EnlargingIntArray(int length) {
        this.length = length;
        this.array = new int[length < 16 ? 16 : length];
    }

    public int get(int idx) {
        if (!$assertionsDisabled && idx >= this.length) {
            throw new AssertionError();
        }
        return this.array[idx];
    }

    public int test(int idx) {
        if (idx < this.length) {
            return this.array[idx];
        }
        return 0;
    }

    public int set(int idx, int obj) {
        if (idx >= this.length) {
            this.enlarge(idx + 1);
        }
        this.array[idx] = obj;
        return this.array[idx];
    }

    public int add(int obj) {
        return this.set(this.length, obj);
    }

    public int pop() {
        if (!$assertionsDisabled && this.length <= 0) {
            throw new AssertionError();
        }
        --this.length;
        int result = this.array[this.length];
        this.array[this.length] = 0;
        return result;
    }

    public void setSize(int size) {
        if (size > this.length) {
            this.enlarge(size);
            return;
        }
        for (int n = this.length - 1; n >= size; --n) {
            this.array[n] = 0;
        }
        this.length = size;
    }

    public int size() {
        return this.length;
    }

    public void clear() {
        while (this.length > 0) {
            this.array[--this.length] = 0;
        }
    }

    private final void enlarge(int newLength) {
        if (newLength <= this.array.length) {
            this.length = newLength;
            return;
        }
        int length2 = this.array.length * 2;
        if (newLength > length2) {
            length2 = newLength;
        }
        int[] newarray = new int[length2];
        System.arraycopy(this.array, 0, newarray, 0, this.length);
        this.array = newarray;
        this.length = newLength;
    }

    static {
        $assertionsDisabled = !EnlargingIntArray.class.desiredAssertionStatus();
    }
}

