/*
 * Decompiled with CFR 0.152.
 */
package uka.util;

import java.io.Serializable;

public class EnlargingFloatArray
implements Serializable {
    int length;
    float[] array;
    public static final int MIN_SIZE = 16;
    static final /* synthetic */ boolean $assertionsDisabled;

    public EnlargingFloatArray() {
        this.length = 0;
        this.array = new float[16];
    }

    public EnlargingFloatArray(int length) {
        this.length = length;
        this.array = new float[length < 16 ? 16 : length];
    }

    public float get(int idx) {
        if (!$assertionsDisabled && idx >= this.length) {
            throw new AssertionError();
        }
        return this.array[idx];
    }

    public float test(int idx) {
        if (idx < this.length) {
            return this.array[idx];
        }
        return 0.0f;
    }

    public float set(int idx, float obj) {
        if (idx >= this.length) {
            this.enlarge(idx + 1);
        }
        this.array[idx] = obj;
        return this.array[idx];
    }

    public float add(float obj) {
        return this.set(this.length, obj);
    }

    public float pop() {
        if (!$assertionsDisabled && this.length <= 0) {
            throw new AssertionError();
        }
        --this.length;
        float result = this.array[this.length];
        this.array[this.length] = 0.0f;
        return result;
    }

    public void setSize(int size) {
        if (size > this.length) {
            this.enlarge(size);
            return;
        }
        for (int n = this.length - 1; n >= size; --n) {
            this.array[n] = 0.0f;
        }
        this.length = size;
    }

    public int size() {
        return this.length;
    }

    public void clear() {
        while (this.length > 0) {
            this.array[--this.length] = 0.0f;
        }
    }

    private final void enlarge(int newLength) {
        if (newLength <= this.array.length) {
            this.length = newLength;
            return;
        }
        int length2 = this.array.length * 2;
        if (newLength > length2) {
            length2 = newLength;
        }
        float[] newarray = new float[length2];
        System.arraycopy(this.array, 0, newarray, 0, this.length);
        this.array = newarray;
        this.length = newLength;
    }

    static {
        $assertionsDisabled = !EnlargingFloatArray.class.desiredAssertionStatus();
    }
}

