/*
 * Decompiled with CFR 0.152.
 */
package uka.util;

import java.io.Serializable;

public class EnlargingCharArray
implements Serializable {
    int length;
    char[] array;
    public static final int MIN_SIZE = 16;
    static final /* synthetic */ boolean $assertionsDisabled;

    public EnlargingCharArray() {
        this.length = 0;
        this.array = new char[16];
    }

    public EnlargingCharArray(int length) {
        this.length = length;
        this.array = new char[length < 16 ? 16 : length];
    }

    public char get(int idx) {
        if (!$assertionsDisabled && idx >= this.length) {
            throw new AssertionError();
        }
        return this.array[idx];
    }

    public char test(int idx) {
        if (idx < this.length) {
            return this.array[idx];
        }
        return '\u0000';
    }

    public char set(int idx, char obj) {
        if (idx >= this.length) {
            this.enlarge(idx + 1);
        }
        this.array[idx] = obj;
        return this.array[idx];
    }

    public char add(char obj) {
        return this.set(this.length, obj);
    }

    public char pop() {
        if (!$assertionsDisabled && this.length <= 0) {
            throw new AssertionError();
        }
        --this.length;
        char result = this.array[this.length];
        this.array[this.length] = '\u0000';
        return result;
    }

    public void setSize(int size) {
        if (size > this.length) {
            this.enlarge(size);
            return;
        }
        for (int n = this.length - 1; n >= size; --n) {
            this.array[n] = '\u0000';
        }
        this.length = size;
    }

    public int size() {
        return this.length;
    }

    public void clear() {
        while (this.length > 0) {
            this.array[--this.length] = '\u0000';
        }
    }

    private final void enlarge(int newLength) {
        if (newLength <= this.array.length) {
            this.length = newLength;
            return;
        }
        int length2 = this.array.length * 2;
        if (newLength > length2) {
            length2 = newLength;
        }
        char[] newarray = new char[length2];
        System.arraycopy(this.array, 0, newarray, 0, this.length);
        this.array = newarray;
        this.length = newLength;
    }

    static {
        $assertionsDisabled = !EnlargingCharArray.class.desiredAssertionStatus();
    }
}

