/*
 * Decompiled with CFR 0.152.
 */
package uka.util;

import java.io.Serializable;

public class EnlargingBooleanArray
implements Serializable {
    int length;
    boolean[] array;
    public static final int MIN_SIZE = 16;
    static final /* synthetic */ boolean $assertionsDisabled;

    public EnlargingBooleanArray() {
        this.length = 0;
        this.array = new boolean[16];
    }

    public EnlargingBooleanArray(int length) {
        this.length = length;
        this.array = new boolean[length < 16 ? 16 : length];
    }

    public boolean get(int idx) {
        if (!$assertionsDisabled && idx >= this.length) {
            throw new AssertionError();
        }
        return this.array[idx];
    }

    public boolean test(int idx) {
        if (idx < this.length) {
            return this.array[idx];
        }
        return false;
    }

    public boolean set(int idx, boolean obj) {
        if (idx >= this.length) {
            this.enlarge(idx + 1);
        }
        this.array[idx] = obj;
        return this.array[idx];
    }

    public boolean add(boolean obj) {
        return this.set(this.length, obj);
    }

    public boolean pop() {
        if (!$assertionsDisabled && this.length <= 0) {
            throw new AssertionError();
        }
        --this.length;
        boolean result = this.array[this.length];
        this.array[this.length] = false;
        return result;
    }

    public void setSize(int size) {
        if (size > this.length) {
            this.enlarge(size);
            return;
        }
        for (int n = this.length - 1; n >= size; --n) {
            this.array[n] = false;
        }
        this.length = size;
    }

    public int size() {
        return this.length;
    }

    public void clear() {
        while (this.length > 0) {
            this.array[--this.length] = false;
        }
    }

    private final void enlarge(int newLength) {
        if (newLength <= this.array.length) {
            this.length = newLength;
            return;
        }
        int length2 = this.array.length * 2;
        if (newLength > length2) {
            length2 = newLength;
        }
        boolean[] newarray = new boolean[length2];
        System.arraycopy(this.array, 0, newarray, 0, this.length);
        this.array = newarray;
        this.length = newLength;
    }

    static {
        $assertionsDisabled = !EnlargingBooleanArray.class.desiredAssertionStatus();
    }
}

