/*
 * Decompiled with CFR 0.152.
 */
package uka.util;

import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;

public class ConfigBundle
extends ResourceBundle {
    ResourceBundle superBundle;
    String prefix;

    public ConfigBundle(ResourceBundle superBundle, String prefix) {
        this.superBundle = superBundle;
        this.prefix = prefix + ".";
    }

    private int complainI(String msg, String key) {
        return (Integer)this.complain(msg, key);
    }

    private Object complain(String msg, String key) {
        throw new MissingResourceException(msg, this.getClass().getName(), this.getFullKey(key)){

            public String toString() {
                return super.toString() + ", key=" + this.getKey();
            }
        };
    }

    protected String getFullKey(String key) {
        if (this.superBundle instanceof ConfigBundle) {
            return ((ConfigBundle)this.superBundle).getFullKey(this.prefix + key);
        }
        return this.prefix + key;
    }

    public Enumeration getKeys() {
        return new Enumeration(){
            Enumeration superEnumeration;
            String nextKey;
            {
                this.superEnumeration = ConfigBundle.this.superBundle.getKeys();
            }

            public boolean hasMoreElements() {
                while (this.nextKey == null && this.superEnumeration.hasMoreElements()) {
                    String key = (String)this.superEnumeration.nextElement();
                    if (!key.startsWith(ConfigBundle.this.prefix)) continue;
                    this.nextKey = key;
                }
                return this.nextKey != null;
            }

            public Object nextElement() {
                if (this.nextKey == null) {
                    throw new NoSuchElementException();
                }
                String result = this.nextKey.substring(ConfigBundle.this.prefix.length());
                this.nextKey = null;
                return result;
            }
        };
    }

    public String getConfigString(String key, String defaultValue) {
        try {
            return this.getConfigString(key);
        }
        catch (MissingResourceException ex) {
            return defaultValue;
        }
    }

    public String getConfigString(String key) {
        try {
            String value = (String)this.handleGetObject(key);
            return value;
        }
        catch (MissingResourceException ex) {
            return (String)this.complain("Missing string configuration entry", key);
        }
    }

    public int getConfigInt(String key, int defaultValue) {
        try {
            return this.getConfigInt(key);
        }
        catch (MissingResourceException ex) {
            return defaultValue;
        }
    }

    public int getConfigInt(String key) {
        try {
            String value = (String)this.handleGetObject(key);
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                return this.complainI("Integer value expected", key);
            }
        }
        catch (MissingResourceException ex) {
            return this.complainI("Missing int configuration entry", key);
        }
    }

    protected Object handleGetObject(String key) {
        return this.superBundle.getObject(this.prefix + key);
    }
}

