/*
 * Decompiled with CFR 0.152.
 */
package uka.transport;

import java.io.Serializable;
import java.util.Arrays;
import uka.util.EnlargingArray;

public class WireHashtable
implements Serializable {
    private EnlargingArray wireHandle2Object;
    private int nextWireOffset;
    private int[] wireHash2Handle;
    private int[] wireNextHandle;
    private int wireHashSizePower = 2;
    private int wireHashLoadFactor = 7;
    private int wireHashCapacity = (1 << this.wireHashSizePower) * this.wireHashLoadFactor;
    static final /* synthetic */ boolean $assertionsDisabled;

    public WireHashtable() {
        this.wireHandle2Object = new EnlargingArray();
        this.wireNextHandle = new int[4];
        this.wireHash2Handle = new int[(1 << this.wireHashSizePower) - 1];
        Arrays.fill(this.wireHash2Handle, 0, this.wireHash2Handle.length, -1);
    }

    public int reset() {
        int result = this.nextWireOffset;
        this.wireHandle2Object.clear();
        Arrays.fill(this.wireNextHandle, 0, this.nextWireOffset, 0);
        Arrays.fill(this.wireHash2Handle, 0, this.wireHash2Handle.length, -1);
        this.nextWireOffset = 0;
        return result;
    }

    public int findWireOffset(Object obj) {
        int hash = System.identityHashCode(obj);
        int index = (hash & Integer.MAX_VALUE) % this.wireHash2Handle.length;
        int handle = this.wireHash2Handle[index];
        while (handle >= 0) {
            if (this.wireHandle2Object.get(handle) == obj) {
                return handle;
            }
            handle = this.wireNextHandle[handle];
        }
        return -1;
    }

    public int assignWireOffset(Object obj) {
        if (this.nextWireOffset == this.wireNextHandle.length) {
            int[] oldnexthandles = this.wireNextHandle;
            this.wireNextHandle = new int[this.nextWireOffset * 2];
            System.arraycopy(oldnexthandles, 0, this.wireNextHandle, 0, this.nextWireOffset);
        }
        if (this.nextWireOffset >= this.wireHashCapacity) {
            this.growWireHash2Handle();
        }
        this.wireHandle2Object.add(obj);
        this.hashInsert(obj, this.nextWireOffset);
        return this.nextWireOffset++;
    }

    public int getNextWireOffset() {
        return this.nextWireOffset;
    }

    public Object getObject(int id) {
        return this.wireHandle2Object.get(id);
    }

    public EnlargingArray getWireHandle2Object() {
        return this.wireHandle2Object;
    }

    private void growWireHash2Handle() {
        ++this.wireHashSizePower;
        this.wireHash2Handle = new int[(1 << this.wireHashSizePower) - 1];
        Arrays.fill(this.wireHash2Handle, 0, this.wireHash2Handle.length, -1);
        for (int i = 0; i < this.nextWireOffset; ++i) {
            this.wireNextHandle[i] = 0;
        }
        int size = this.wireHandle2Object.size();
        for (int i = 0; i < size; ++i) {
            this.hashInsert(this.wireHandle2Object.get(i), i);
        }
        this.wireHashCapacity = (1 << this.wireHashSizePower) * this.wireHashLoadFactor;
    }

    private void hashInsert(Object obj, int offset) {
        int hash = System.identityHashCode(obj);
        int index = (hash & Integer.MAX_VALUE) % this.wireHash2Handle.length;
        this.wireNextHandle[offset] = this.wireHash2Handle[index];
        this.wireHash2Handle[index] = offset;
    }

    public void setNextWireOffset(int next) {
        if (!$assertionsDisabled && next > this.nextWireOffset) {
            throw new AssertionError();
        }
        while (this.nextWireOffset > next) {
            --this.nextWireOffset;
            Object obj = this.wireHandle2Object.pop();
            int hash = System.identityHashCode(obj);
            int index = (hash & Integer.MAX_VALUE) % this.wireHash2Handle.length;
            this.wireHash2Handle[index] = this.wireNextHandle[this.nextWireOffset];
            this.wireNextHandle[this.nextWireOffset] = 0;
        }
    }

    static {
        $assertionsDisabled = !WireHashtable.class.desiredAssertionStatus();
    }
}

