/*
 * Decompiled with CFR 0.152.
 */
package uka.transport;

import java.io.IOException;
import uka.transport.BasicIO;
import uka.transport.MarshalStream;
import uka.transport.UnmarshalStream;

public final class ValueIO
extends BasicIO {
    public static final void writeValue(MarshalStream s, byte[] array) throws IOException {
        byte[] buffer = s.getBuffer();
        s.reserve(4);
        int pos = s.getPosition();
        if (array == null) {
            pos = ValueIO.insert(buffer, pos, -1);
            s.deliver(4);
            return;
        }
        int length = array.length;
        pos = ValueIO.insert(buffer, pos, length);
        s.deliver(4);
        s.write(array, 0, length);
    }

    public static final void writeValue(MarshalStream s, int[] array) throws IOException {
        int direct;
        byte[] buffer = s.getBuffer();
        s.reserve(4);
        int pos = s.getPosition();
        if (array == null) {
            pos = ValueIO.insert(buffer, pos, -1);
            s.deliver(4);
            return;
        }
        int length = array.length;
        pos = ValueIO.insert(buffer, pos, length);
        s.deliver(4);
        for (int cnt = 0; cnt < length; cnt += direct) {
            direct = length - cnt > 512 ? 512 : length - cnt;
            int directBytes = direct * 4;
            s.reserve(directBytes);
            pos = s.getPosition();
            pos = BasicIO.insert(buffer, pos, array, cnt, direct);
            s.deliver(directBytes);
        }
    }

    public static final void writeValue(MarshalStream s, char[] array) throws IOException {
        int direct;
        byte[] buffer = s.getBuffer();
        s.reserve(4);
        int pos = s.getPosition();
        if (array == null) {
            pos = ValueIO.insert(buffer, pos, -1);
            s.deliver(4);
            return;
        }
        int length = array.length;
        pos = ValueIO.insert(buffer, pos, length);
        s.deliver(4);
        for (int cnt = 0; cnt < length; cnt += direct) {
            direct = length - cnt > 1024 ? 1024 : length - cnt;
            int directBytes = direct * 2;
            s.reserve(directBytes);
            pos = s.getPosition();
            pos = BasicIO.insert(buffer, pos, array, cnt, direct);
            s.deliver(directBytes);
        }
    }

    public static final void writeValue(MarshalStream s, float[] array) throws IOException {
        int direct;
        byte[] buffer = s.getBuffer();
        s.reserve(4);
        int pos = s.getPosition();
        if (array == null) {
            pos = ValueIO.insert(buffer, pos, -1);
            s.deliver(4);
            return;
        }
        int length = array.length;
        pos = ValueIO.insert(buffer, pos, length);
        s.deliver(4);
        for (int cnt = 0; cnt < length; cnt += direct) {
            direct = length - cnt > 512 ? 512 : length - cnt;
            int directBytes = direct * 4;
            s.reserve(directBytes);
            pos = s.getPosition();
            pos = BasicIO.insert(buffer, pos, array, cnt, direct);
            s.deliver(directBytes);
        }
    }

    public static final void writeValue(MarshalStream s, long[] array) throws IOException {
        int direct;
        byte[] buffer = s.getBuffer();
        s.reserve(4);
        int pos = s.getPosition();
        if (array == null) {
            pos = ValueIO.insert(buffer, pos, -1);
            s.deliver(4);
            return;
        }
        int length = array.length;
        pos = ValueIO.insert(buffer, pos, length);
        s.deliver(4);
        for (int cnt = 0; cnt < length; cnt += direct) {
            direct = length - cnt > 256 ? 256 : length - cnt;
            int directBytes = direct * 8;
            s.reserve(directBytes);
            pos = s.getPosition();
            pos = BasicIO.insert(buffer, pos, array, cnt, direct);
            s.deliver(directBytes);
        }
    }

    public static final void writeValue(MarshalStream s, double[] array) throws IOException {
        int direct;
        byte[] buffer = s.getBuffer();
        s.reserve(4);
        int pos = s.getPosition();
        if (array == null) {
            pos = ValueIO.insert(buffer, pos, -1);
            s.deliver(4);
            return;
        }
        int length = array.length;
        pos = ValueIO.insert(buffer, pos, length);
        s.deliver(4);
        for (int cnt = 0; cnt < length; cnt += direct) {
            direct = length - cnt > 256 ? 256 : length - cnt;
            int directBytes = direct * 8;
            s.reserve(directBytes);
            pos = s.getPosition();
            pos = BasicIO.insert(buffer, pos, array, cnt, direct);
            s.deliver(directBytes);
        }
    }

    public static final void writeValue(MarshalStream s, short[] array) throws IOException {
        int direct;
        byte[] buffer = s.getBuffer();
        s.reserve(4);
        int pos = s.getPosition();
        if (array == null) {
            pos = ValueIO.insert(buffer, pos, -1);
            s.deliver(4);
            return;
        }
        int length = array.length;
        pos = ValueIO.insert(buffer, pos, length);
        s.deliver(4);
        for (int cnt = 0; cnt < length; cnt += direct) {
            direct = length - cnt > 1024 ? 1024 : length - cnt;
            int directBytes = direct * 2;
            s.reserve(directBytes);
            pos = s.getPosition();
            pos = BasicIO.insert(buffer, pos, array, cnt, direct);
            s.deliver(directBytes);
        }
    }

    public static final void writeValue(MarshalStream s, boolean[] array) throws IOException {
        int direct;
        byte[] buffer = s.getBuffer();
        s.reserve(4);
        int pos = s.getPosition();
        if (array == null) {
            pos = ValueIO.insert(buffer, pos, -1);
            s.deliver(4);
            return;
        }
        int length = array.length;
        pos = ValueIO.insert(buffer, pos, length);
        s.deliver(4);
        for (int cnt = 0; cnt < length; cnt += direct) {
            direct = length - cnt > 2048 ? 2048 : length - cnt;
            int directBytes = direct * 1;
            s.reserve(directBytes);
            pos = s.getPosition();
            pos = BasicIO.insert(buffer, pos, array, cnt, direct);
            s.deliver(directBytes);
        }
    }

    public static final void writeValue(MarshalStream s, byte[][] array) throws IOException {
        byte[] buffer = s.getBuffer();
        s.reserve(4);
        int pos = s.getPosition();
        if (array == null) {
            pos = ValueIO.insert(buffer, pos, -1);
            s.deliver(4);
            return;
        }
        int length = array.length;
        pos = ValueIO.insert(buffer, pos, length);
        s.deliver(4);
        for (int n = 0; n < length; ++n) {
            ValueIO.writeValue(s, array[n]);
        }
    }

    public static final void writeValue(MarshalStream s, int[][] array) throws IOException {
        byte[] buffer = s.getBuffer();
        s.reserve(4);
        int pos = s.getPosition();
        if (array == null) {
            pos = ValueIO.insert(buffer, pos, -1);
            s.deliver(4);
            return;
        }
        int length = array.length;
        pos = ValueIO.insert(buffer, pos, length);
        s.deliver(4);
        for (int n = 0; n < length; ++n) {
            ValueIO.writeValue(s, array[n]);
        }
    }

    public static final void writeValue(MarshalStream s, char[][] array) throws IOException {
        byte[] buffer = s.getBuffer();
        s.reserve(4);
        int pos = s.getPosition();
        if (array == null) {
            pos = ValueIO.insert(buffer, pos, -1);
            s.deliver(4);
            return;
        }
        int length = array.length;
        pos = ValueIO.insert(buffer, pos, length);
        s.deliver(4);
        for (int n = 0; n < length; ++n) {
            ValueIO.writeValue(s, array[n]);
        }
    }

    public static final void writeValue(MarshalStream s, float[][] array) throws IOException {
        byte[] buffer = s.getBuffer();
        s.reserve(4);
        int pos = s.getPosition();
        if (array == null) {
            pos = ValueIO.insert(buffer, pos, -1);
            s.deliver(4);
            return;
        }
        int length = array.length;
        pos = ValueIO.insert(buffer, pos, length);
        s.deliver(4);
        for (int n = 0; n < length; ++n) {
            ValueIO.writeValue(s, array[n]);
        }
    }

    public static final void writeValue(MarshalStream s, long[][] array) throws IOException {
        byte[] buffer = s.getBuffer();
        s.reserve(4);
        int pos = s.getPosition();
        if (array == null) {
            pos = ValueIO.insert(buffer, pos, -1);
            s.deliver(4);
            return;
        }
        int length = array.length;
        pos = ValueIO.insert(buffer, pos, length);
        s.deliver(4);
        for (int n = 0; n < length; ++n) {
            ValueIO.writeValue(s, array[n]);
        }
    }

    public static final void writeValue(MarshalStream s, double[][] array) throws IOException {
        byte[] buffer = s.getBuffer();
        s.reserve(4);
        int pos = s.getPosition();
        if (array == null) {
            pos = ValueIO.insert(buffer, pos, -1);
            s.deliver(4);
            return;
        }
        int length = array.length;
        pos = ValueIO.insert(buffer, pos, length);
        s.deliver(4);
        for (int n = 0; n < length; ++n) {
            ValueIO.writeValue(s, array[n]);
        }
    }

    public static final void writeValue(MarshalStream s, short[][] array) throws IOException {
        byte[] buffer = s.getBuffer();
        s.reserve(4);
        int pos = s.getPosition();
        if (array == null) {
            pos = ValueIO.insert(buffer, pos, -1);
            s.deliver(4);
            return;
        }
        int length = array.length;
        pos = ValueIO.insert(buffer, pos, length);
        s.deliver(4);
        for (int n = 0; n < length; ++n) {
            ValueIO.writeValue(s, array[n]);
        }
    }

    public static final void writeValue(MarshalStream s, boolean[][] array) throws IOException {
        byte[] buffer = s.getBuffer();
        s.reserve(4);
        int pos = s.getPosition();
        if (array == null) {
            pos = ValueIO.insert(buffer, pos, -1);
            s.deliver(4);
            return;
        }
        int length = array.length;
        pos = ValueIO.insert(buffer, pos, length);
        s.deliver(4);
        for (int n = 0; n < length; ++n) {
            ValueIO.writeValue(s, array[n]);
        }
    }

    public static final byte[] readValueArrayByte(UnmarshalStream s) throws IOException {
        byte[] buffer = s.getBuffer();
        s.request(4);
        int pos = s.getPosition();
        int length = ValueIO.extractInt(buffer, pos);
        s.accept(4);
        if (length < 0) {
            return null;
        }
        byte[] result = new byte[length];
        s.readFully(result, 0, length);
        return result;
    }

    public static final int[] readValueArrayInt(UnmarshalStream s) throws IOException {
        int direct;
        byte[] buffer = s.getBuffer();
        s.request(4);
        int pos = s.getPosition();
        int length = ValueIO.extractInt(buffer, pos);
        s.accept(4);
        if (length < 0) {
            return null;
        }
        int[] result = new int[length];
        for (int cnt = 0; cnt < length; cnt += direct) {
            direct = length - cnt > 512 ? 512 : length - cnt;
            int directBytes = direct * 4;
            s.request(directBytes);
            int pos2 = s.getPosition();
            pos2 = BasicIO.extract(buffer, pos2, result, cnt, direct);
            s.accept(directBytes);
        }
        return result;
    }

    public static final char[] readValueArrayChar(UnmarshalStream s) throws IOException {
        int direct;
        byte[] buffer = s.getBuffer();
        s.request(4);
        int pos = s.getPosition();
        int length = ValueIO.extractInt(buffer, pos);
        s.accept(4);
        if (length < 0) {
            return null;
        }
        char[] result = new char[length];
        for (int cnt = 0; cnt < length; cnt += direct) {
            direct = length - cnt > 1024 ? 1024 : length - cnt;
            int directBytes = direct * 2;
            s.request(directBytes);
            int pos2 = s.getPosition();
            pos2 = BasicIO.extract(buffer, pos2, result, cnt, direct);
            s.accept(directBytes);
        }
        return result;
    }

    public static final float[] readValueArrayFloat(UnmarshalStream s) throws IOException {
        int direct;
        byte[] buffer = s.getBuffer();
        s.request(4);
        int pos = s.getPosition();
        int length = ValueIO.extractInt(buffer, pos);
        s.accept(4);
        if (length < 0) {
            return null;
        }
        float[] result = new float[length];
        for (int cnt = 0; cnt < length; cnt += direct) {
            direct = length - cnt > 512 ? 512 : length - cnt;
            int directBytes = direct * 4;
            s.request(directBytes);
            int pos2 = s.getPosition();
            pos2 = BasicIO.extract(buffer, pos2, result, cnt, direct);
            s.accept(directBytes);
        }
        return result;
    }

    public static final long[] readValueArrayLong(UnmarshalStream s) throws IOException {
        int direct;
        byte[] buffer = s.getBuffer();
        s.request(4);
        int pos = s.getPosition();
        int length = ValueIO.extractInt(buffer, pos);
        s.accept(4);
        if (length < 0) {
            return null;
        }
        long[] result = new long[length];
        for (int cnt = 0; cnt < length; cnt += direct) {
            direct = length - cnt > 256 ? 256 : length - cnt;
            int directBytes = direct * 8;
            s.request(directBytes);
            int pos2 = s.getPosition();
            pos2 = BasicIO.extract(buffer, pos2, result, cnt, direct);
            s.accept(directBytes);
        }
        return result;
    }

    public static final double[] readValueArrayDouble(UnmarshalStream s) throws IOException {
        int direct;
        byte[] buffer = s.getBuffer();
        s.request(4);
        int pos = s.getPosition();
        int length = ValueIO.extractInt(buffer, pos);
        s.accept(4);
        if (length < 0) {
            return null;
        }
        double[] result = new double[length];
        for (int cnt = 0; cnt < length; cnt += direct) {
            direct = length - cnt > 256 ? 256 : length - cnt;
            int directBytes = direct * 8;
            s.request(directBytes);
            int pos2 = s.getPosition();
            pos2 = BasicIO.extract(buffer, pos2, result, cnt, direct);
            s.accept(directBytes);
        }
        return result;
    }

    public static final short[] readValueArrayShort(UnmarshalStream s) throws IOException {
        int direct;
        byte[] buffer = s.getBuffer();
        s.request(4);
        int pos = s.getPosition();
        int length = ValueIO.extractInt(buffer, pos);
        s.accept(4);
        if (length < 0) {
            return null;
        }
        short[] result = new short[length];
        for (int cnt = 0; cnt < length; cnt += direct) {
            direct = length - cnt > 1024 ? 1024 : length - cnt;
            int directBytes = direct * 2;
            s.request(directBytes);
            int pos2 = s.getPosition();
            pos2 = BasicIO.extract(buffer, pos2, result, cnt, direct);
            s.accept(directBytes);
        }
        return result;
    }

    public static final boolean[] readValueArrayBoolean(UnmarshalStream s) throws IOException {
        int direct;
        byte[] buffer = s.getBuffer();
        s.request(4);
        int pos = s.getPosition();
        int length = ValueIO.extractInt(buffer, pos);
        s.accept(4);
        if (length < 0) {
            return null;
        }
        boolean[] result = new boolean[length];
        for (int cnt = 0; cnt < length; cnt += direct) {
            direct = length - cnt > 2048 ? 2048 : length - cnt;
            int directBytes = direct * 1;
            s.request(directBytes);
            int pos2 = s.getPosition();
            pos2 = BasicIO.extract(buffer, pos2, result, cnt, direct);
            s.accept(directBytes);
        }
        return result;
    }

    public static final byte[][] readValueArrayArrayByte(UnmarshalStream s) throws IOException {
        byte[] buffer = s.getBuffer();
        s.request(4);
        int pos = s.getPosition();
        int length = ValueIO.extractInt(buffer, pos);
        s.accept(4);
        if (length < 0) {
            return null;
        }
        byte[][] result = new byte[length][];
        for (int n = 0; n < length; ++n) {
            result[n] = ValueIO.readValueArrayByte(s);
        }
        return result;
    }

    public static final int[][] readValueArrayArrayInt(UnmarshalStream s) throws IOException {
        byte[] buffer = s.getBuffer();
        s.request(4);
        int pos = s.getPosition();
        int length = ValueIO.extractInt(buffer, pos);
        s.accept(4);
        if (length < 0) {
            return null;
        }
        int[][] result = new int[length][];
        for (int n = 0; n < length; ++n) {
            result[n] = ValueIO.readValueArrayInt(s);
        }
        return result;
    }

    public static final char[][] readValueArrayArrayChar(UnmarshalStream s) throws IOException {
        byte[] buffer = s.getBuffer();
        s.request(4);
        int pos = s.getPosition();
        int length = ValueIO.extractInt(buffer, pos);
        s.accept(4);
        if (length < 0) {
            return null;
        }
        char[][] result = new char[length][];
        for (int n = 0; n < length; ++n) {
            result[n] = ValueIO.readValueArrayChar(s);
        }
        return result;
    }

    public static final float[][] readValueArrayArrayFloat(UnmarshalStream s) throws IOException {
        byte[] buffer = s.getBuffer();
        s.request(4);
        int pos = s.getPosition();
        int length = ValueIO.extractInt(buffer, pos);
        s.accept(4);
        if (length < 0) {
            return null;
        }
        float[][] result = new float[length][];
        for (int n = 0; n < length; ++n) {
            result[n] = ValueIO.readValueArrayFloat(s);
        }
        return result;
    }

    public static final long[][] readValueArrayArrayLong(UnmarshalStream s) throws IOException {
        byte[] buffer = s.getBuffer();
        s.request(4);
        int pos = s.getPosition();
        int length = ValueIO.extractInt(buffer, pos);
        s.accept(4);
        if (length < 0) {
            return null;
        }
        long[][] result = new long[length][];
        for (int n = 0; n < length; ++n) {
            result[n] = ValueIO.readValueArrayLong(s);
        }
        return result;
    }

    public static final double[][] readValueArrayArrayDouble(UnmarshalStream s) throws IOException {
        byte[] buffer = s.getBuffer();
        s.request(4);
        int pos = s.getPosition();
        int length = ValueIO.extractInt(buffer, pos);
        s.accept(4);
        if (length < 0) {
            return null;
        }
        double[][] result = new double[length][];
        for (int n = 0; n < length; ++n) {
            result[n] = ValueIO.readValueArrayDouble(s);
        }
        return result;
    }

    public static final short[][] readValueArrayArrayShort(UnmarshalStream s) throws IOException {
        byte[] buffer = s.getBuffer();
        s.request(4);
        int pos = s.getPosition();
        int length = ValueIO.extractInt(buffer, pos);
        s.accept(4);
        if (length < 0) {
            return null;
        }
        short[][] result = new short[length][];
        for (int n = 0; n < length; ++n) {
            result[n] = ValueIO.readValueArrayShort(s);
        }
        return result;
    }

    public static final boolean[][] readValueArrayArrayBoolean(UnmarshalStream s) throws IOException {
        byte[] buffer = s.getBuffer();
        s.request(4);
        int pos = s.getPosition();
        int length = ValueIO.extractInt(buffer, pos);
        s.accept(4);
        if (length < 0) {
            return null;
        }
        boolean[][] result = new boolean[length][];
        for (int n = 0; n < length; ++n) {
            result[n] = ValueIO.readValueArrayBoolean(s);
        }
        return result;
    }
}

