/*
 * Decompiled with CFR 0.152.
 */
package uka.transport;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import uka.transport.BasicIO;
import uka.transport.BinaryInputStream;
import uka.transport.Index;
import uka.transport.MarshalAdapter;
import uka.transport.Resolvable;
import uka.transport.TransportConstants;
import uka.transport.Transportable;
import uka.util.EnlargingArray;

public class UnmarshalStream
extends BinaryInputStream
implements TransportConstants,
ObjectInput {
    protected Bridge iin;
    protected boolean iin_init = false;
    protected boolean iin_used = false;
    int defaultUnmarshalCnt;
    protected EnlargingArray wireObjectTable;
    protected final EnlargingArray wireConstrTable;
    private final Object[] thisArg = new Object[]{this};
    private static final Class[] classArg = new Class[]{UnmarshalStream.class};
    boolean enableResolve = false;
    DataInputStream lazy_din = null;

    public UnmarshalStream(InputStream in) throws IOException {
        this(in, new EnlargingArray(), new EnlargingArray());
    }

    protected UnmarshalStream(InputStream in, EnlargingArray wireObjectTable, EnlargingArray wireConstrTable) throws IOException {
        super(in);
        this.wireObjectTable = wireObjectTable;
        this.wireConstrTable = wireConstrTable;
    }

    public EnlargingArray setObjectSpace(EnlargingArray wireObjectTable) {
        EnlargingArray oldWireObjectTable = this.wireObjectTable;
        this.wireObjectTable = wireObjectTable;
        return oldWireObjectTable;
    }

    public void symmetricReset() throws IOException {
        if (this.iin_used) {
            try {
                Object x = this.iin.readObject();
                if (x != null) {
                    throw new StreamCorruptedException("null expected");
                }
            }
            catch (ClassNotFoundException ex) {
                throw new StreamCorruptedException("null expected (" + ex + ")");
            }
            this.iin_used = false;
        }
        this.wireObjectTable.clear();
    }

    public void symmetricResetType() throws IOException {
        if (this.iin_used) {
            try {
                Object x = this.iin.readObject();
                if (x != null) {
                    throw new StreamCorruptedException("null expected");
                }
            }
            catch (ClassNotFoundException ex) {
                throw new StreamCorruptedException("null expected (" + ex + ")");
            }
            this.iin_used = false;
        }
        this.wireObjectTable.clear();
        this.wireConstrTable.clear();
    }

    public final Object readObject() throws ClassNotFoundException, IOException {
        byte code;
        block14: while (true) {
            if (this.requestTest(1) < 1) {
                throw new EOFException("assertion " + UnmarshalStream.class.getName() + ".request(" + 1 + ") failed");
            }
            code = this.buf[this.bufcnt];
            switch (code) {
                case 1: {
                    Object x;
                    ++this.bufcnt;
                    if (this.iin_used) {
                        x = this.iin.readObject();
                        if (x != null) {
                            throw new StreamCorruptedException("null expected");
                        }
                        this.iin_used = false;
                    }
                    this.wireObjectTable.clear();
                    continue block14;
                }
                case 2: {
                    Object x;
                    ++this.bufcnt;
                    if (this.iin_used) {
                        x = this.iin.readObject();
                        if (x != null) {
                            throw new StreamCorruptedException("null expected");
                        }
                        this.iin_used = false;
                    }
                    this.wireObjectTable.clear();
                    this.wireConstrTable.clear();
                    continue block14;
                }
                case 3: {
                    ++this.bufcnt;
                    return null;
                }
                case 4: {
                    ++this.bufcnt;
                    int wireoffset = this.readInt();
                    return this.wireObjectTable.get(wireoffset);
                }
                case 5: {
                    Object obj;
                    ++this.bufcnt;
                    Constructor constr = this.readConstructor();
                    try {
                        Transportable ref = (Transportable)constr.newInstance(this.thisArg);
                        this.wireObjectTable.add(ref);
                        ref.unmarshalReferences(this);
                        obj = ref;
                    }
                    catch (InstantiationException ex) {
                        throw new IOException("class incompatibility: received object is of an abstract class (" + constr + ")");
                    }
                    catch (IllegalAccessException ex) {
                        throw new IOException("constructor of transportable class is not accessible: " + constr);
                    }
                    catch (IllegalArgumentException ex) {
                        throw new InternalError("wrong constructor type: " + constr);
                    }
                    catch (InvocationTargetException ex) {
                        System.err.println("transportable object creation failed: " + ex);
                        ex.getTargetException().printStackTrace();
                        throw new IOException("can not instantiate object (" + constr + "): " + ex + " inner exception was " + ex.getTargetException());
                    }
                    if (obj instanceof Resolvable) {
                        obj = ((Resolvable)obj).readResolve();
                    }
                    if (this.enableResolve) {
                        obj = this.resolveObject(obj);
                    }
                    return obj;
                }
                case 6: {
                    ++this.bufcnt;
                    return this.inputArray();
                }
                case 7: {
                    ++this.bufcnt;
                    if (!this.iin_init) {
                        this.iin = new Bridge();
                        this.iin_init = true;
                    }
                    this.iin_used = true;
                    this.defaultUnmarshalCnt = 0;
                    Object result = this.iin.readObject();
                    int cnt = this.defaultUnmarshalCnt;
                    for (int n = 0; n < cnt; ++n) {
                        this.wireObjectTable.add(this.iin.readObject());
                    }
                    return result;
                }
            }
            break;
        }
        MarshalAdapter adapter = MarshalAdapter.getAdapter(code);
        if (adapter != null) {
            ++this.bufcnt;
            return adapter.unmarshal(this);
        }
        throw new StreamCorruptedException("unknown token (" + code + ")");
    }

    private Constructor readConstructor() throws IOException, ClassNotFoundException {
        if (this.requestTest(1) < 1) {
            throw new EOFException("assertion " + UnmarshalStream.class.getName() + ".request(" + 1 + ") failed");
        }
        byte ccode = this.buf[this.bufcnt++];
        switch (ccode) {
            case 4: {
                int wireoffset = this.readInt();
                return (Constructor)this.wireConstrTable.get(wireoffset);
            }
            case 8: {
                String className = this.readChars();
                Class<?> objClass = Class.forName(className);
                try {
                    Constructor<?> constr = objClass.getConstructor(classArg);
                    this.wireConstrTable.add(constr);
                    return constr;
                }
                catch (NoSuchMethodException ex) {
                    throw new IOException("object not transportable: no matching constructor for class '" + objClass + "'");
                }
            }
        }
        throw new StreamCorruptedException("no type descriptor ('" + ccode + "')");
    }

    private Class readClass() throws IOException, ClassNotFoundException {
        if (this.requestTest(1) < 1) {
            throw new EOFException("assertion " + UnmarshalStream.class.getName() + ".request(" + 1 + ") failed");
        }
        byte ccode = this.buf[this.bufcnt++];
        switch (ccode) {
            case 4: {
                int wireoffset = this.readInt();
                return (Class)this.wireConstrTable.get(wireoffset);
            }
            case 8: {
                String className = this.readChars();
                Class<?> clazz = Class.forName(className);
                this.wireConstrTable.add(clazz);
                return clazz;
            }
        }
        throw new StreamCorruptedException("no type descriptor ('" + ccode + "')");
    }

    protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
        return this.iin.super_resolveClass(v);
    }

    protected Object resolveObject(Object obj) throws IOException {
        return obj;
    }

    protected void readStreamHeader() throws IOException, StreamCorruptedException {
        if (this.requestTest(4) < 4) {
            throw new EOFException("assertion " + UnmarshalStream.class.getName() + ".request(" + 4 + ") failed");
        }
        byte[] buf = this.buf;
        int bufcnt = this.bufcnt;
        if (buf[bufcnt++] != 85) {
            throw new StreamCorruptedException("header 0");
        }
        if (buf[bufcnt++] != 75) {
            throw new StreamCorruptedException("header 1");
        }
        if (buf[bufcnt++] != 65) {
            throw new StreamCorruptedException("header 2");
        }
        if (buf[bufcnt++] != 1) {
            throw new StreamCorruptedException("header 3");
        }
        this.bufcnt += 4;
    }

    protected boolean enableResolveObject(boolean enable) throws SecurityException {
        boolean previous = this.enableResolve;
        this.enableResolve = enable;
        return previous;
    }

    private final DataInputStream getDataInputStream() {
        if (this.lazy_din == null) {
            this.lazy_din = new DataInputStream(this);
        }
        return this.lazy_din;
    }

    public String readUTF() throws IOException {
        return this.getDataInputStream().readUTF();
    }

    public String readLine() throws IOException {
        return this.getDataInputStream().readLine();
    }

    private Object inputArray() throws IOException, ClassNotFoundException {
        Class arrayclass = this.readClass();
        Class<?> componentclass = arrayclass.getComponentType();
        int length = this.readInt();
        Object obj = Array.newInstance(componentclass, length);
        this.wireObjectTable.add(obj);
        if (length == 0) {
            return obj;
        }
        if (componentclass.isPrimitive()) {
            if (componentclass == Byte.TYPE) {
                byte[] array = (byte[])obj;
                if (length <= 2048) {
                    if (this.requestTest(length * 1) < length * 1) {
                        throw new EOFException("assertion " + UnmarshalStream.class.getName() + ".request(" + length * 1 + ") failed");
                    }
                    this.bufcnt = BasicIO.extract(this.buf, this.bufcnt, array, 0, length);
                } else {
                    this.readHugeByteArray(array, 0, length);
                }
                return array;
            }
            if (componentclass == Boolean.TYPE) {
                boolean[] array = (boolean[])obj;
                if (length <= 2048) {
                    if (this.requestTest(length * 1) < length * 1) {
                        throw new EOFException("assertion " + UnmarshalStream.class.getName() + ".request(" + length * 1 + ") failed");
                    }
                    this.bufcnt = BasicIO.extract(this.buf, this.bufcnt, array, 0, length);
                } else {
                    this.readHugeBooleanArray(array, 0, length);
                }
                return array;
            }
            if (componentclass == Character.TYPE) {
                char[] array = (char[])obj;
                if (length <= 1024) {
                    if (this.requestTest(length * 2) < length * 2) {
                        throw new EOFException("assertion " + UnmarshalStream.class.getName() + ".request(" + length * 2 + ") failed");
                    }
                    this.bufcnt = BasicIO.extract(this.buf, this.bufcnt, array, 0, length);
                } else {
                    this.readHugeCharArray(array, 0, length);
                }
                return array;
            }
            if (componentclass == Short.TYPE) {
                short[] array = (short[])obj;
                if (length <= 1024) {
                    if (this.requestTest(length * 2) < length * 2) {
                        throw new EOFException("assertion " + UnmarshalStream.class.getName() + ".request(" + length * 2 + ") failed");
                    }
                    this.bufcnt = BasicIO.extract(this.buf, this.bufcnt, array, 0, length);
                } else {
                    this.readHugeShortArray(array, 0, length);
                }
                return array;
            }
            if (componentclass == Integer.TYPE) {
                int[] array = (int[])obj;
                if (length <= 512) {
                    if (this.requestTest(length * 4) < length * 4) {
                        throw new EOFException("assertion " + UnmarshalStream.class.getName() + ".request(" + length * 4 + ") failed");
                    }
                    this.bufcnt = BasicIO.extract(this.buf, this.bufcnt, array, 0, length);
                } else {
                    this.readHugeIntArray(array, 0, length);
                }
                return array;
            }
            if (componentclass == Long.TYPE) {
                long[] array = (long[])obj;
                if (length <= 256) {
                    if (this.requestTest(length * 8) < length * 8) {
                        throw new EOFException("assertion " + UnmarshalStream.class.getName() + ".request(" + length * 8 + ") failed");
                    }
                    this.bufcnt = BasicIO.extract(this.buf, this.bufcnt, array, 0, length);
                } else {
                    this.readHugeLongArray(array, 0, length);
                }
                return array;
            }
            if (componentclass == Float.TYPE) {
                float[] array = (float[])obj;
                if (length <= 512) {
                    if (this.requestTest(length * 4) < length * 4) {
                        throw new EOFException("assertion " + UnmarshalStream.class.getName() + ".request(" + length * 4 + ") failed");
                    }
                    this.bufcnt = BasicIO.extract(this.buf, this.bufcnt, array, 0, length);
                } else {
                    this.readHugeFloatArray(array, 0, length);
                }
                return array;
            }
            if (componentclass == Double.TYPE) {
                double[] array = (double[])obj;
                if (length <= 256) {
                    if (this.requestTest(length * 8) < length * 8) {
                        throw new EOFException("assertion " + UnmarshalStream.class.getName() + ".request(" + length * 8 + ") failed");
                    }
                    this.bufcnt = BasicIO.extract(this.buf, this.bufcnt, array, 0, length);
                } else {
                    this.readHugeDoubleArray(array, 0, length);
                }
                return array;
            }
            throw new IOException("unknown array type '" + arrayclass.getName() + "'");
        }
        Object[] array = (Object[])obj;
        for (int i = 0; i < length; ++i) {
            array[i] = this.readObject();
        }
        return array;
    }

    public class Bridge
    extends ObjectInputStream {
        public Bridge() throws IOException {
            super(UnmarshalStream.this);
            this.enableResolveObject(true);
        }

        public UnmarshalStream getParent() {
            return UnmarshalStream.this;
        }

        protected Object resolveObject(Object obj) throws IOException {
            if (obj instanceof Index) {
                int id = ((Index)obj).get();
                return UnmarshalStream.this.wireObjectTable.get(id);
            }
            if (UnmarshalStream.this.enableResolve) {
                obj = UnmarshalStream.this.resolveObject(obj);
            }
            ++UnmarshalStream.this.defaultUnmarshalCnt;
            return obj;
        }

        Class super_resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
            return super.resolveClass(v);
        }

        protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
            return UnmarshalStream.this.resolveClass(v);
        }
    }
}

